/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.contract.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.impl.InnerHandler;
import com.artfess.base.context.BaseContext;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.bpm.persistence.dao.BpmProcessInstanceDao;
import com.artfess.bpm.persistence.dao.BpmTaskDao;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.file.util.MinioUtil;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.dao.YearBudgetDetailedDao;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.contract.dao.WorkOrderInformationDao;
import com.artfess.yhxt.contract.manager.BillOfQuantitiesManager;
import com.artfess.yhxt.contract.manager.BillQuantiTypeManagManager;
import com.artfess.yhxt.contract.manager.ContractItemManager;
import com.artfess.yhxt.contract.manager.ContractManager;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.BillQuantiTypeManag;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.ContractItem;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.BillOfQuantitiesVo;
import com.artfess.yhxt.contract.vo.OrderCashVo;
import com.artfess.yhxt.contract.vo.OrderCheckVO;
import com.artfess.yhxt.contract.vo.OrderItemCountVo;
import com.artfess.yhxt.contract.vo.OrderMoneyVO;
import com.artfess.yhxt.contract.vo.OrderMonthVO;
import com.artfess.yhxt.contract.vo.OrderReportVO;
import com.artfess.yhxt.contract.vo.OrderSpecialCashVo;
import com.artfess.yhxt.contract.vo.OrderWorkFinishVO;
import com.artfess.yhxt.contract.vo.WorkOrderAndBaseIdVo;
import com.artfess.yhxt.contract.vo.WorkOrderCountVO;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.contract.vo.WorkOrderInformationVo;
import com.artfess.yhxt.contract.vo.WorkOrderParamVo;
import com.artfess.yhxt.contract.vo.WorkOrderVo;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.manager.BizProjectBeginApplyForManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.model.BizProjectBeginApplyFor;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.statistics.dao.WorkStatisticDao;
import com.artfess.yhxt.statistics.vo.Org4AppVO;
import com.artfess.yhxt.statistics.vo.OrgVO;
import com.artfess.yhxt.util.ArithUtil;
import com.artfess.yhxt.util.PermissionUtils;
import com.artfess.yhxt.util.PoiStyleUtil;
import com.artfess.yhxt.util.StreamUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkOrderInformationManagerImpl
extends BaseManagerImpl<WorkOrderInformationDao, WorkOrderInformation>
implements WorkOrderInformationManager {
    @Resource
    private BillOfQuantitiesManager billOfQuantitiesManager;
    @Resource
    private ContractItemManager contractItemManager;
    @Resource
    private DiseaseManager diseaseManager;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private ContractManager contractManager;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    private IFlowManager iFlowManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    private OrgUserManager orgUserManager;
    @Resource
    private UserManager userManager;
    @Resource
    private BpmTaskDao bpmTaskDao;
    @Resource
    private BillQuantiTypeManagManager billQuantiTypeManagManager;
    @Resource
    private BpmProcessInstanceDao bpmProcessInstanceDao;
    @Resource
    private OrgDao orgDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private WorkStatisticDao workStatisticDao;
    @Autowired
    private YearBudgetManager yearBudgetManager;
    @Autowired
    private YearBudgetDetailedManager yearBudgetDetailedManager;
    @Autowired
    private PermissionUtils permissionUtils;
    @Autowired
    private YearBudgetDetailedDao yearBudgetDetailedDao;
    @Autowired
    private WorkOrderInformationDao workOrderInformationDao;
    @Resource
    InnerHandler innerHandler;
    @Autowired
    private BizEngineeringProjectManager bizEngineeringProjectManager;
    @Resource
    BizProjectBeginApplyForManager bizProjectBeginApplyForManager;
    @Resource
    MeasurementPaymentManager measurementPaymentManager;

    @Override
    public List<OrderMonthVO> getMonthReport(String year, String orgId) {
        ArrayList<OrderMonthVO> vos = new ArrayList<OrderMonthVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            OrderMonthVO vo = new OrderMonthVO();
            vo.setRoadName(road.getName());
            vo.setOrgName("\u91cd\u5e86\u8fd0\u8425\u7ba1\u7406\u603b\u90e8");
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            if (yearBudget != null) {
                QueryWrapper detailedQueryWrapper = new QueryWrapper();
                detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                detailedQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                detailedQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                List daily = this.yearBudgetDetailedManager.list((Wrapper)detailedQueryWrapper);
                QueryWrapper speQueryWrapper = new QueryWrapper();
                speQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                speQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                speQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                speQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"FRCZX");
                List spe = this.yearBudgetDetailedManager.list((Wrapper)detailedQueryWrapper);
                BigDecimal dailyMoney = BigDecimal.ZERO;
                BigDecimal speMoney = BigDecimal.ZERO;
                BigDecimal dailyFinish = BigDecimal.ZERO;
                BigDecimal speFinish = BigDecimal.ZERO;
                BigDecimal allMoney = BigDecimal.ZERO;
                BigDecimal allFinish = BigDecimal.ZERO;
                if (spe.size() > 0) {
                    List speMoneys = spe.stream().filter(s -> s != null && s.getTotalPrice() != null).map(YearBudgetDetailed::getTotalPrice).collect(Collectors.toList());
                    List speFinishs = spe.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                    for (BigDecimal speDe : speMoneys) {
                        speMoney = speMoney.add(speDe);
                    }
                    for (BigDecimal speFi : speFinishs) {
                        speFinish = speFinish.add(speFi);
                    }
                }
                if (daily.size() > 0) {
                    List dailyMoneys = daily.stream().filter(s -> s != null && s.getTotalPrice() != null).map(YearBudgetDetailed::getTotalPrice).collect(Collectors.toList());
                    List dailyFinishs = daily.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                    for (BigDecimal dailyDe : dailyMoneys) {
                        dailyMoney = dailyMoney.add(dailyDe);
                    }
                    allMoney = dailyMoney.add(speMoney);
                    for (BigDecimal dailyFi : dailyFinishs) {
                        dailyFinish = dailyFinish.add(dailyFi);
                    }
                }
                allFinish = dailyFinish.add(speFinish);
                vo.setDailyMoney(dailyMoney);
                vo.setDailyFinish(dailyFinish);
                vo.setSpeMoney(speMoney);
                vo.setSpeFinish(speFinish);
                vo.setAllFinish(allFinish);
                vo.setAllMoney(allMoney);
                if (!dailyMoney.equals(BigDecimal.ZERO) && !dailyFinish.equals(BigDecimal.ZERO)) {
                    vo.setDailyRate(dailyFinish.divide(dailyMoney, 2, 0));
                } else {
                    vo.setDailyRate(BigDecimal.ZERO);
                }
                if (!speMoney.equals(BigDecimal.ZERO) && !speFinish.equals(BigDecimal.ZERO)) {
                    vo.setSpeRate(speFinish.divide(speMoney, 2, 0));
                } else {
                    vo.setSpeRate(BigDecimal.ZERO);
                }
                if (!allFinish.equals(BigDecimal.ZERO) && !allMoney.equals(BigDecimal.ZERO)) {
                    vo.setAllRate(allFinish.divide(allMoney, 2, 0));
                } else {
                    vo.setAllRate(BigDecimal.ZERO);
                }
            } else {
                vo.setSpeRate(BigDecimal.ZERO);
                vo.setSpeMoney(BigDecimal.ZERO);
                vo.setSpeFinish(BigDecimal.ZERO);
                vo.setDailyRate(BigDecimal.ZERO);
                vo.setDailyFinish(BigDecimal.ZERO);
                vo.setDailyMoney(BigDecimal.ZERO);
                vo.setAllRate(BigDecimal.ZERO);
                vo.setAllMoney(BigDecimal.ZERO);
                vo.setAllFinish(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<OrderCheckVO> getCheckReport(String year, String orgId) {
        ArrayList<OrderCheckVO> vos = new ArrayList<OrderCheckVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(road.getId());
            OrderCheckVO vo = new OrderCheckVO();
            vo.setRoadName(road.getName());
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("accDateYear", year);
            params.put("roadSegmentId", ids);
            params.put("ids", ids);
            List<WorkOrderCountVO> mapList = this.workStatisticDao.countWorkOrder4New(params);
            List userTask1list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask1")).collect(Collectors.toList());
            List userTask2list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask2")).collect(Collectors.toList());
            List endEvent1list = mapList.stream().filter(s -> s.getTaskKey().equals("EndEvent1")).collect(Collectors.toList());
            vo.setFinishCount(endEvent1list.size());
            vo.setConstructionCount(endEvent1list.size() - userTask1list.size() - userTask2list.size());
            if (mapList.size() > 0 && endEvent1list.size() > 0) {
                vo.setFinishRate(new BigDecimal(vo.getFinishCount()).divide(new BigDecimal(mapList.size()), 2, 0));
            } else {
                vo.setFinishRate(new BigDecimal(0));
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<OrderWorkFinishVO> getWorkFinishReport(String year, String orgId) {
        ArrayList<OrderWorkFinishVO> vos = new ArrayList<OrderWorkFinishVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            QueryWrapper orderWrapper = new QueryWrapper();
            orderWrapper.eq((Object)"IS_DELE_", (Object)"0");
            orderWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            orderWrapper.apply("date_format(ISSUE_DATE_,'%Y') = {0}", new Object[]{year});
            List allList = this.list((Wrapper)orderWrapper);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(road.getId());
            OrderWorkFinishVO vo = new OrderWorkFinishVO();
            vo.setRoadName(road.getName());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("accDateYear", year);
            params.put("roadSegmentId", ids);
            params.put("ids", ids);
            List<WorkOrderCountVO> mapList = this.workStatisticDao.countWorkOrder4New(params);
            List userTask1list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask1")).collect(Collectors.toList());
            List userTask3list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask3")).collect(Collectors.toList());
            List endEvent1list = mapList.stream().filter(s -> s.getTaskKey().equals("EndEvent1")).collect(Collectors.toList());
            BigDecimal task1Money = new BigDecimal(0);
            if (userTask1list.size() > 0) {
                List task1 = userTask1list.stream().map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List worlMoneyF = this.billOfQuantitiesManager.list((Wrapper)new QueryWrapper().in((Object)"WORK_ORDER_INFORMATION_ID_", task1)).stream().filter(s -> s != null && s.getMoney() != null).map(BillOfQuantities::getMoney).collect(Collectors.toList());
                for (Float aFloat : worlMoneyF) {
                    task1Money = task1Money.add(new BigDecimal(Float.toString(aFloat.floatValue())));
                }
            }
            BigDecimal task3Money = new BigDecimal(0);
            if (userTask3list.size() > 0) {
                List task3 = userTask3list.stream().map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List worlMoneyF = this.billOfQuantitiesManager.list((Wrapper)new QueryWrapper().in((Object)"WORK_ORDER_INFORMATION_ID_", task3)).stream().filter(s -> s != null && s.getReceiverMoney() != null).map(BillOfQuantities::getReceiverMoney).collect(Collectors.toList());
                for (Float aFloat : worlMoneyF) {
                    task3Money = task3Money.add(new BigDecimal(Float.toString(aFloat.floatValue())));
                }
            }
            vo.setIssuedMoney(task1Money);
            vo.setIssuedCount(userTask1list.size());
            vo.setWorkCount(userTask3list.size());
            vo.setWorkMoney(task3Money);
            vo.setFinishCount(endEvent1list.size());
            List deseasaList = allList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getDiseaseId())).collect(Collectors.toList());
            vo.setDeseasaCount(deseasaList.size());
            vo.setEseasaFinishCount(deseasaList.stream().filter(p -> p.getStatus().equals("1")).collect(Collectors.toList()).size());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<OrderMoneyVO> getMoneyReport(String year, String orgId) {
        ArrayList<OrderMoneyVO> vos = new ArrayList<OrderMoneyVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        LocalDateTime now = LocalDateTime.now();
        int month = now.getMonthValue();
        for (Road road : roads) {
            BigDecimal finishRate = BigDecimal.ZERO;
            OrderMoneyVO vo = new OrderMoneyVO();
            vo.setRoadName(road.getName());
            QueryWrapper contractWrapper = new QueryWrapper();
            contractWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            contractWrapper.eq((Object)"IS_DELE_", (Object)"0");
            contractWrapper.orderByDesc((Object)"CREATE_TIME_");
            contractWrapper.last("limit 1");
            Contract contract = (Contract)((Object)this.contractManager.getOne((Wrapper)contractWrapper));
            if (contract != null) {
                vo.setContractMoney(new BigDecimal(String.valueOf(contract.getContractAmount())));
                vo.setContractName(contract.getName());
            } else {
                vo.setContractMoney(BigDecimal.ZERO);
            }
            String monthstr = month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
            List WorkOrderInformationIds = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId())).isNotNull((Object)"END_TIME_")).apply("date_format(ISSUE_DATE_,'%Y-%m') = '" + year + "-" + monthstr + "'", new Object[0])).stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
            BigDecimal workOrderMoney = new BigDecimal(0);
            if (WorkOrderInformationIds.size() > 0) {
                List worlMoneyF = this.billOfQuantitiesManager.list((Wrapper)new QueryWrapper().in((Object)"WORK_ORDER_INFORMATION_ID_", WorkOrderInformationIds)).stream().filter(s -> s != null && s.getTaxMoney() != null).map(BillOfQuantities::getTaxMoney).collect(Collectors.toList());
                for (Float aFloat : worlMoneyF) {
                    workOrderMoney = workOrderMoney.add(new BigDecimal(Float.toString(aFloat.floatValue())));
                }
            }
            vo.setMonthMoney(workOrderMoney);
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            if (yearBudget != null) {
                QueryWrapper detailedQueryWrapper = new QueryWrapper();
                detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                detailedQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                detailedQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                detailedQueryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
                detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
                YearBudgetDetailed detaileds = (YearBudgetDetailed)((Object)this.yearBudgetDetailedManager.getOne((Wrapper)detailedQueryWrapper));
                if (detaileds != null) {
                    vo.setFinishMoney(detaileds.getImageProgress().multiply(new BigDecimal(10000)));
                    if (!vo.getContractMoney().equals(BigDecimal.ZERO) && !detaileds.getImageProgress().equals(BigDecimal.ZERO)) {
                        finishRate = finishRate.add(vo.getFinishMoney().divide(vo.getContractMoney(), 2, 0));
                    }
                }
            }
            vo.setFinishRate(finishRate);
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<OrderReportVO> getReport(String year, String orgId) {
        ArrayList<OrderReportVO> vos = new ArrayList<OrderReportVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            OrderReportVO vo = new OrderReportVO();
            QueryWrapper orderWrapper = new QueryWrapper();
            orderWrapper.eq((Object)"IS_DELE_", (Object)"0");
            orderWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            orderWrapper.apply("date_format(ISSUE_DATE_,'%Y') = {0}", new Object[]{year});
            List allList = this.list((Wrapper)orderWrapper);
            vo.setOrderCount(allList.size());
            vo.setRoadName(road.getName());
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            BigDecimal money = BigDecimal.ZERO;
            if (yearBudget != null) {
                QueryWrapper detailedQueryWrapper = new QueryWrapper();
                detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                detailedQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                detailedQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                detailedQueryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
                detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
                YearBudgetDetailed detaileds = (YearBudgetDetailed)((Object)this.yearBudgetDetailedManager.getOne((Wrapper)detailedQueryWrapper));
                if (detaileds != null) {
                    money = money.add(detaileds.getTotalPrice().multiply(new BigDecimal(10000)));
                }
            }
            vo.setMoney(money);
            if (allList.size() > 0) {
                List finishList = allList.stream().filter(p -> p.getStatus().equals("1")).collect(Collectors.toList());
                vo.setFinishCount(finishList.size());
                List runList = allList.stream().filter(p -> p.getStatus().equals("0")).collect(Collectors.toList());
                vo.setRunCount(runList.size());
                if (finishList.size() > 0) {
                    vo.setFinishRate(new BigDecimal(finishList.size()).divide(new BigDecimal(allList.size()), 2, 0));
                } else {
                    vo.setFinishRate(new BigDecimal(0));
                }
                List overList = allList.stream().filter(p -> p.getOverdue() == 1).collect(Collectors.toList());
                vo.setOverCount(overList.size());
                if (overList.size() > 0) {
                    vo.setOverRate(new BigDecimal(overList.size()).divide(new BigDecimal(allList.size()), 2, 0));
                } else {
                    vo.setOverRate(new BigDecimal(0));
                }
                List deseasaList = allList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getDiseaseId())).collect(Collectors.toList());
                vo.setDeseasaOrderCount(deseasaList.size());
                vo.setUnDeseasaOrderCount(allList.size() - deseasaList.size());
                List WorkOrderInformationIds = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId())).isNotNull((Object)"END_TIME_")).apply("date_format(ISSUE_DATE_,'%Y') = {0}", new Object[]{year})).stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
                BigDecimal workOrderMoney = new BigDecimal(0);
                if (WorkOrderInformationIds.size() > 0) {
                    List worlMoneyF = this.billOfQuantitiesManager.list((Wrapper)new QueryWrapper().in((Object)"WORK_ORDER_INFORMATION_ID_", WorkOrderInformationIds)).stream().filter(s -> s != null && s.getTaxMoney() != null).map(BillOfQuantities::getTaxMoney).collect(Collectors.toList());
                    for (Float aFloat : worlMoneyF) {
                        workOrderMoney = workOrderMoney.add(new BigDecimal(Float.toString(aFloat.floatValue())));
                    }
                }
                vo.setFinishMoney(workOrderMoney);
                if (!workOrderMoney.equals(BigDecimal.ZERO) && !vo.getMoney().equals(BigDecimal.ZERO)) {
                    vo.setFinishMoneyRate(workOrderMoney.divide(vo.getMoney(), 2, 0));
                } else {
                    vo.setFinishMoneyRate(new BigDecimal(0));
                }
            } else {
                vo.setFinishMoneyRate(new BigDecimal(0));
                vo.setOverRate(new BigDecimal(0));
                vo.setFinishRate(new BigDecimal(0));
                vo.setFinishMoney(new BigDecimal(0));
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public PageList<WorkOrderInformation> queryWorkOrderInformation(QueryFilter<WorkOrderInformation> queryFilter) {
        IPage<WorkOrderInformation> result = ((WorkOrderInformationDao)this.baseMapper).queryWorkOrderInformation((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public WorkOrderInformation getWorkOrderInformationById(String id) {
        WorkOrderInformation workOrderInformation = (WorkOrderInformation)((Object)((WorkOrderInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return workOrderInformation;
    }

    @Override
    public void saveVo(WorkOrderInformationVo vo) {
        List<Accessory> accessorySufList;
        List<Accessory> accessoryUndList;
        List<Accessory> accessoryPreList;
        WorkOrderInformation workOrderInformation = vo.getWorkOrderInformation();
        Road road = (Road)this.roadManager.get((Serializable)((Object)workOrderInformation.getRoadSegmentId()));
        String yhgd = null;
        try {
            yhgd = this.sysIdentityManager.nextId(road.getSimplicity().toUpperCase(Locale.ROOT) + "yhgd");
        }
        catch (Exception e) {
            yhgd = this.sysIdentityManager.nextId("yhgd");
        }
        workOrderInformation.setJobNumber(road.getSimplicity().toUpperCase(Locale.ROOT) + "-" + yhgd);
        this.create((Model)workOrderInformation);
        String workId = workOrderInformation.getId();
        String diseaseId = workOrderInformation.getDiseaseId();
        if (StringUtils.isNotEmpty((CharSequence)diseaseId)) {
            List<String> ids = Arrays.asList(diseaseId.split(";"));
            for (String id : ids) {
                Disease disease = (Disease)((Object)this.diseaseManager.getById((Serializable)((Object)id)));
                Integer handlingSituation = disease.getHandlingSituation();
                disease.setJobNumber(yhgd);
                LocalDate demandFinishTime = workOrderInformation.getDemandFinishTime();
                if (disease.getHandlingSituation() != null && disease.getHandlingSituation() != 0) continue;
                disease.setHandlingSituation(1);
                disease.setHandledTimeStart(LocalDateTime.now());
                this.diseaseManager.update((Model)disease);
            }
        }
        if (null != vo && vo.getBillOfQuantities() != null && vo.getBillOfQuantities().size() > 0) {
            List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();
            for (BillOfQuantities billOfQuantity : billOfQuantities) {
                billOfQuantity.setWorkOrderInformationId(workId);
                billOfQuantity.setBillType(1);
            }
            this.billOfQuantitiesManager.saveBatch(billOfQuantities);
        }
        if (null != vo && vo.getBillOutOfQuantities() != null && vo.getBillOutOfQuantities().size() > 0) {
            List<BillOfQuantities> billOutOfQuantities = vo.getBillOutOfQuantities();
            for (BillOfQuantities billOfQuantity : billOutOfQuantities) {
                billOfQuantity.setWorkOrderInformationId(workId);
                billOfQuantity.setBillType(2);
                billOfQuantity.setSonSubjectName(billOfQuantity.getSubjectName());
            }
            this.billOfQuantitiesManager.saveBatch(billOutOfQuantities);
            ArrayList billQuantiTypeManags = new ArrayList();
            billOutOfQuantities.forEach(s -> {
                BillQuantiTypeManag billQuantiTypeManag = new BillQuantiTypeManag();
                List list = this.billQuantiTypeManagManager.list((Wrapper)new QueryWrapper().lambda().eq(StringUtils.isNotEmpty((CharSequence)s.getSubjectName()), BillQuantiTypeManag::getProjectName, (Object)s.getSubjectName()));
                if (list.size() > 0) {
                    billQuantiTypeManag.setId(((BillQuantiTypeManag)((Object)((Object)list.get(0)))).getId());
                }
                billQuantiTypeManag.setPrice(new BigDecimal(s.getPrice().toString()));
                billQuantiTypeManag.setAmount(new BigDecimal(s.getAmount().toString()));
                billQuantiTypeManag.setRoadSegmentId(road.getId());
                billQuantiTypeManag.setRoadSegmentName(road.getName());
                billQuantiTypeManag.setCompanyId(road.getCompanyId());
                billQuantiTypeManag.setCompanyName(road.getCompanyName());
                billQuantiTypeManag.setProjectName(s.getSubjectName());
                billQuantiTypeManags.add(billQuantiTypeManag);
            });
            if (billQuantiTypeManags.size() > 0) {
                this.billQuantiTypeManagManager.saveOrUpdateBatch(billQuantiTypeManags);
            }
        }
        this.accessoryManager.delAccessoryBySourceId(workOrderInformation.getId());
        List<Accessory> accessoryWorkOrderList = vo.getAccessoriesWorkOrder();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("workOrder");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }
        if (null != (accessoryPreList = vo.getAccessoriesPre()) && accessoryPreList.size() > 0) {
            accessoryPreList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionPre");
            });
            this.accessoryManager.saveBatch(accessoryPreList);
        }
        if (null != (accessoryUndList = vo.getAccessoriesUnd()) && accessoryUndList.size() > 0) {
            accessoryUndList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionUnd");
            });
            this.accessoryManager.saveBatch(accessoryUndList);
        }
        if (null != (accessorySufList = vo.getAccessoriesSuf()) && accessorySufList.size() > 0) {
            accessorySufList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionSuf");
            });
            this.accessoryManager.saveBatch(accessorySufList);
        }
    }

    @Override
    public void updateVo(WorkOrderInformationVo vo) {
        List<Accessory> accessorySufList;
        List<Accessory> accessoryUndList;
        List<Accessory> accessoryPreList;
        WorkOrderInformation workOrderInformation = vo.getWorkOrderInformation();
        this.update((Model)workOrderInformation);
        String workId = workOrderInformation.getId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"WORK_ORDER_INFORMATION_ID_", (Object)workId);
        this.billOfQuantitiesManager.getBaseMapper().delete((Wrapper)queryWrapper);
        if (null != vo && vo.getBillOfQuantities() != null && vo.getBillOfQuantities().size() > 0) {
            List billOfQuantities = vo.getBillOfQuantities();
            for (BillOfQuantities billOfQuantity : billOfQuantities) {
                billOfQuantity.setWorkOrderInformationId(workId);
                billOfQuantity.setBillType(1);
            }
            billOfQuantities = billOfQuantities.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BillOfQuantities>(Comparator.comparing(o -> o.getContractItemId()))), ArrayList::new));
            vo.setBillOfQuantities(billOfQuantities);
            this.billOfQuantitiesManager.saveOrUpdateBatch(billOfQuantities);
        }
        if (null != vo && vo.getBillOutOfQuantities() != null && vo.getBillOutOfQuantities().size() > 0) {
            List<BillOfQuantities> billOutOfQuantities = vo.getBillOutOfQuantities();
            for (BillOfQuantities billOfQuantity : billOutOfQuantities) {
                billOfQuantity.setWorkOrderInformationId(workId);
                billOfQuantity.setBillType(2);
            }
            this.billOfQuantitiesManager.saveOrUpdateBatch(billOutOfQuantities);
        }
        this.accessoryManager.delAccessoryBySourceId(workOrderInformation.getId());
        List<Accessory> accessoryWorkOrderList = vo.getAccessoriesWorkOrder();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("workOrder");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }
        if (null != (accessoryPreList = vo.getAccessoriesPre()) && accessoryPreList.size() > 0) {
            accessoryPreList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionPre");
            });
            this.accessoryManager.saveBatch(accessoryPreList);
        }
        if (null != (accessoryUndList = vo.getAccessoriesUnd()) && accessoryUndList.size() > 0) {
            accessoryUndList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionUnd");
            });
            this.accessoryManager.saveBatch(accessoryUndList);
        }
        if (null != (accessorySufList = vo.getAccessoriesSuf()) && accessorySufList.size() > 0) {
            accessorySufList.forEach(s -> {
                s.setSourceId(workOrderInformation.getId());
                s.setGroup("constructionSuf");
            });
            this.accessoryManager.saveBatch(accessorySufList);
        }
    }

    @Override
    public WorkOrderInformationVo getVo(String id) {
        List<Accessory> accessories;
        WorkOrderInformationVo orderInformationVo = new WorkOrderInformationVo();
        WorkOrderInformation workOrderInformation = (WorkOrderInformation)((Object)this.getById((Serializable)((Object)id)));
        if (null == workOrderInformation) {
            throw new BaseException("\u5de5\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)workOrderInformation.getRoadSegmentId())));
        workOrderInformation.setRoad(road);
        String diseaseIds = workOrderInformation.getDiseaseId();
        orderInformationVo.setWorkOrderInformation(workOrderInformation);
        if (StringUtils.isNotBlank((CharSequence)diseaseIds)) {
            List<String> detailsIdList = Arrays.asList(diseaseIds.split(";"));
            if (detailsIdList.size() > 0) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"ID_", detailsIdList);
                List diseases = this.diseaseManager.getBaseMapper().selectList((Wrapper)queryWrapper);
                if (diseases.size() > 0) {
                    for (Disease disease : diseases) {
                        QueryWrapper accessoryQueryWrapper = new QueryWrapper();
                        accessoryQueryWrapper.eq((Object)"SOURCE_ID_", (Object)disease.getId());
                        accessoryQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                        accessories = this.accessoryManager.getBaseMapper().selectList((Wrapper)accessoryQueryWrapper);
                        disease.setAccessories(accessories);
                    }
                    orderInformationVo.setDiseases(diseases);
                }
            }
        } else {
            orderInformationVo.setDiseases(new ArrayList<Disease>(0));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"WORK_ORDER_INFORMATION_ID_", (Object)id);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq((Object)"BILL_TYPE_", (Object)"1");
        List list = this.billOfQuantitiesManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        ArrayList<BillOfQuantities> billList = new ArrayList<BillOfQuantities>();
        if (null != list && list.size() > 0) {
            for (BillOfQuantities billOfQuantities : list) {
                ContractItem contractItem;
                String contractItemId;
                BillOfQuantities bill = new BillOfQuantities();
                BeanUtils.copyProperties((Object)((Object)billOfQuantities), (Object)((Object)bill));
                if (null == billOfQuantities.getSonSubjectCode() && !"".equals(billOfQuantities.getSonSubjectCode()) && null != (contractItemId = billOfQuantities.getContractItemId()) && !"".equals(contractItemId) && null != (contractItem = (ContractItem)this.contractItemManager.get((Serializable)((Object)contractItemId)))) {
                    bill.setSonSubjectCode(contractItem.getSonSubjectCode());
                    bill.setSonSubjectName(contractItem.getSonSubjectName());
                }
                billList.add(bill);
            }
        }
        orderInformationVo.setBillOfQuantities(billList);
        QueryWrapper queryBillOutOfQuantitiesWrapper = new QueryWrapper();
        queryBillOutOfQuantitiesWrapper.eq((Object)"WORK_ORDER_INFORMATION_ID_", (Object)workOrderInformation.getId());
        queryBillOutOfQuantitiesWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryBillOutOfQuantitiesWrapper.eq((Object)"BILL_TYPE_", (Object)"2");
        List outList = this.billOfQuantitiesManager.getBaseMapper().selectList((Wrapper)queryBillOutOfQuantitiesWrapper);
        orderInformationVo.setBillOutOfQuantities(outList);
        String contractId = workOrderInformation.getContractId();
        if (StringUtils.isNotBlank((CharSequence)contractId)) {
            Contract contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)contractId)));
            orderInformationVo.setContract(contract);
        } else {
            orderInformationVo.setContract(new Contract());
        }
        accessories = this.accessoryManager.getAccessoryBySourceId(workOrderInformation.getId());
        ArrayList<Accessory> accessoryPreList = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoryUndList = new ArrayList<Accessory>();
        ArrayList<Accessory> accessorySufList = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoryWorkOrderList = new ArrayList<Accessory>();
        if (null != accessories && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("constructionPre".equalsIgnoreCase(group)) {
                    accessoryPreList.add((Accessory)((Object)s));
                }
                if ("constructionUnd".equalsIgnoreCase(group)) {
                    accessoryUndList.add((Accessory)((Object)s));
                }
                if ("constructionSuf".equalsIgnoreCase(group)) {
                    accessorySufList.add((Accessory)((Object)s));
                }
                if ("workOrder".equalsIgnoreCase(group)) {
                    accessoryWorkOrderList.add((Accessory)((Object)s));
                }
            });
        }
        orderInformationVo.setAccessoriesPre(accessoryPreList);
        orderInformationVo.setAccessoriesUnd(accessoryUndList);
        orderInformationVo.setAccessoriesSuf(accessorySufList);
        orderInformationVo.setAccessoriesWorkOrder(accessoryWorkOrderList);
        return orderInformationVo;
    }

    public static List<OrgVO> getChild(List<OrgVO> allList, String pCode) {
        ArrayList<OrgVO> returnList = new ArrayList<OrgVO>();
        for (OrgVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(WorkOrderInformationManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            WorkOrderInformationManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    @Override
    public List<Org4AppVO> getWorkOrderCountList4App(String level, String dimension, String date) {
        if ("0".equals(level)) {
            dimension = "1419863231459102720";
        }
        Org pOrg = this.orgDao.get((Serializable)((Object)dimension));
        ArrayList<Org4AppVO> lists = new ArrayList<Org4AppVO>();
        if (pOrg != null) {
            List orgList = this.orgDao.getByParentId(pOrg.getId());
            for (Org org : orgList) {
                Org4AppVO fvo = new Org4AppVO();
                BeanUtils.copyProperties((Object)org, (Object)fvo);
                lists.add(fvo);
            }
            return this.setCountList4App(lists, date);
        }
        return lists;
    }

    @Override
    public Org4AppVO getWorkOrderCount4App(String level, String dimension, String date) {
        if ("0".equals(level)) {
            dimension = "1419863231459102720";
        }
        Org org = this.orgDao.get((Serializable)((Object)dimension));
        Org4AppVO fvo = new Org4AppVO();
        BeanUtils.copyProperties((Object)org, (Object)fvo);
        return this.setCount4App(fvo, date);
    }

    public List<Org4AppVO> setCountList4App(List<Org4AppVO> list, String date) {
        Iterator<Org4AppVO> it = list.iterator();
        while (it.hasNext()) {
            Org4AppVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<Object> roadList = new ArrayList();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("accDateDay", date);
                params.put("roadSegmentId", roadList);
                params.put("ids", roadList);
                List<Map<String, Object>> mapList = this.workStatisticDao.countWorkOrder(params);
                orgVO.setAllCount(String.valueOf(mapList.size()));
                continue;
            }
            it.remove();
        }
        return list;
    }

    public Org4AppVO setCount4App(Org4AppVO orgVO, String year) {
        Integer grade = Integer.valueOf(orgVO.getGrade());
        List<String> roadList = new ArrayList<String>();
        if (grade < 4) {
            QueryWrapper roadQueryWrapper = new QueryWrapper();
            roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
            roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
        } else if (grade == 4) {
            QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
            roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
            roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
        }
        if (roadList.size() > 0) {
            orgVO = this.dayCountWorkOrder(roadList, orgVO, year);
        } else {
            orgVO.setCheckCount("0");
            orgVO.setAllCount("0");
            orgVO.setConstructionCount("0");
            orgVO.setExamineCount("0");
            orgVO.setFinishCount("0");
            orgVO.setOverdueCount("0");
            orgVO.setDistributionCount("0");
        }
        return orgVO;
    }

    @Override
    public List<OrgVO> getWorkOrderCount(String startDate, String endDate) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<OrgVO> lists = new ArrayList<OrgVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = WorkOrderInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            OrgVO fvo = new OrgVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = WorkOrderInformationManagerImpl.getChild(lists, orgId);
        return this.setCount(lists, startDate, endDate);
    }

    public List<OrgVO> setCount(List<OrgVO> list, String startDate, String endDate) {
        Iterator<OrgVO> it = list.iterator();
        while (it.hasNext()) {
            OrgVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO, startDate, endDate);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren(), startDate, endDate);
        }
        return list;
    }

    public Org4AppVO dayCountWorkOrder(List<String> ids, Org4AppVO orgVO, String date) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accDateDay", date);
        params.put("roadSegmentId", ids);
        params.put("ids", ids);
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List<Map<String, Object>> mapList = this.workStatisticDao.countWorkOrder(params);
        long userTask1 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
        long userTask2 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
        long userTask3 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
        long userTask4 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
        long userTask5 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
        long userTask6 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
        long userTask7 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
        long endEvent1 = mapList.stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
        orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        orderQueryWrapper.apply("date_format(ISSUE_DATE_,'%Y-%m-%d') = {0}", new Object[]{date});
        List overList = ((WorkOrderInformationDao)this.baseMapper).selectList((Wrapper)orderQueryWrapper);
        long overdueWorkOrderCountUnFinish = overList.size();
        orgVO.setDistributionCount(String.valueOf(userTask1 + userTask7));
        orgVO.setConstructionCount(String.valueOf(userTask2 + userTask3));
        orgVO.setCheckCount(String.valueOf(userTask4));
        orgVO.setExamineCount(String.valueOf(userTask5 + userTask6));
        orgVO.setFinishCount(String.valueOf(endEvent1));
        orgVO.setOverdueCount(String.valueOf(overdueWorkOrderCountUnFinish));
        orgVO.setAllCount(String.valueOf(mapList.size()));
        return orgVO;
    }

    public OrgVO newCountWorkOrder(List<String> ids, OrgVO orgVO, String startDate, String endDate) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("roadSegmentId", ids);
        params.put("ids", ids);
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List<WorkOrderCountVO> mapList = this.workStatisticDao.countWorkOrder4New(params);
        List userTask1list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask1")).collect(Collectors.toList());
        List userTask2list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask2")).collect(Collectors.toList());
        List userTask3list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask3")).collect(Collectors.toList());
        List userTask4list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask4")).collect(Collectors.toList());
        List userTask5list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask5")).collect(Collectors.toList());
        List userTask6list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask6")).collect(Collectors.toList());
        List userTask7list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask7")).collect(Collectors.toList());
        List endEvent1list = mapList.stream().filter(s -> s.getTaskKey().equals("EndEvent1")).collect(Collectors.toList());
        orgVO.setFinishMoney(this.workStatisticDao.countWorkOrderFinishMoney(params));
        long userTask1 = userTask1list.size();
        long userTask2 = userTask2list.size();
        long userTask3 = userTask3list.size();
        long userTask4 = userTask4list.size();
        long userTask5 = userTask5list.size();
        long userTask6 = userTask6list.size();
        long userTask7 = userTask7list.size();
        long endEvent1 = endEvent1list.size();
        orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.between((Object)"ISSUE_DATE_", (Object)startDate, (Object)endDate);
        List overList = ((WorkOrderInformationDao)this.baseMapper).selectList((Wrapper)orderQueryWrapper);
        ArrayList distributionCountList = new ArrayList();
        distributionCountList.addAll(userTask7list);
        distributionCountList.addAll(userTask1list);
        int distributionSize = distributionCountList.stream().map(a -> overList.stream().filter(b -> Objects.nonNull(a.getWorkId()) && Objects.nonNull(b.getId()) && Objects.equals(a.getWorkId(), b.getId())).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()).size();
        orgVO.setDistributionOverdue(distributionSize);
        ArrayList constructionCountList = new ArrayList();
        constructionCountList.addAll(userTask2list);
        constructionCountList.addAll(userTask3list);
        int constructionSize = constructionCountList.stream().map(a -> overList.stream().filter(b -> Objects.nonNull(a.getWorkId()) && Objects.nonNull(b.getId()) && Objects.equals(a.getWorkId(), b.getId())).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()).size();
        orgVO.setConstructionOverdue(constructionSize);
        ArrayList examineCountList = new ArrayList();
        examineCountList.addAll(userTask5list);
        examineCountList.addAll(userTask6list);
        int examineSize = examineCountList.stream().map(a -> overList.stream().filter(b -> Objects.nonNull(a.getWorkId()) && Objects.nonNull(b.getId()) && Objects.equals(a.getWorkId(), b.getId())).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()).size();
        orgVO.setExamineOverdue(examineSize);
        int checkSize = userTask4list.stream().map(a -> overList.stream().filter(b -> Objects.nonNull(a.getWorkId()) && Objects.nonNull(b.getId()) && Objects.equals(a.getWorkId(), b.getId())).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()).size();
        orgVO.setCheckOverdue(checkSize);
        long overdueWorkOrderCountUnFinish = overList.size();
        orgVO.setDistributionCount(String.valueOf(userTask1 + userTask7));
        orgVO.setConstructionCount(String.valueOf(userTask2 + userTask3));
        orgVO.setCheckCount(String.valueOf(userTask4));
        orgVO.setExamineCount(String.valueOf(userTask5 + userTask6));
        orgVO.setFinishCount(String.valueOf(endEvent1));
        orgVO.setOverdueCount(String.valueOf(overdueWorkOrderCountUnFinish));
        orgVO.setAllCount(String.valueOf(mapList.size()));
        if ("4".equals(orgVO.getGrade()) && mapList.size() > 0) {
            orgVO.setRoadId(mapList.get(0).getRoadId());
        }
        return orgVO;
    }

    @Override
    public PageList<WorkOrderVo> getWorkOrderVo(QueryFilter queryFilter) {
        List querys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        List<Object> roadList = new ArrayList();
        if (ObjectUtils.isEmpty(map.get("croadSegmentId"))) {
            QueryWrapper roadQueryWrapper = new QueryWrapper();
            roadQueryWrapper.like(StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()), (Object)"COMPANY_IDS_", (Object)this.baseContext.getCurrentOrgId());
            roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            queryFilter.addFilter("croadSegmentId", roadList, QueryOP.IN);
        }
        if (null != (querys = queryFilter.getQuerys())) {
            for (QueryField query : querys) {
                ArrayList ids;
                String state = query.getProperty();
                if (!state.equals("state")) continue;
                String value = (String)query.getValue();
                HashMap<String, Object> paramsf = new HashMap<String, Object>();
                paramsf.put("roadSegmentId", roadList);
                paramsf.put("ids", roadList);
                query.setProperty("cid");
                query.setOperation(QueryOP.IN);
                query.setRelation(FieldRelation.AND);
                query.setGroup("ids");
                if (value.equals("0")) {
                    query.setProperty("cstatus");
                    query.setOperation(QueryOP.LIKE);
                    query.setRelation(FieldRelation.AND);
                    query.setGroup("advance");
                    query.setValue((Object)"0");
                    break;
                }
                if (value.equals("1")) {
                    query.setProperty("cstatus");
                    query.setOperation(QueryOP.LIKE);
                    query.setRelation(FieldRelation.AND);
                    query.setGroup("advance");
                    query.setValue((Object)"1");
                    break;
                }
                if (value.equals("2")) {
                    QueryWrapper orderQueryWrapper = new QueryWrapper();
                    orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
                    orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                    orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", roadList);
                    List overList = ((WorkOrderInformationDao)this.baseMapper).selectList((Wrapper)orderQueryWrapper);
                    if (null != overList && overList.size() > 0) {
                        List<String> ids2 = StreamUtil.toList(overList, WorkOrderInformation::getId);
                        query.setValue(ids2);
                        break;
                    }
                    query.setValue((Object)"-1");
                    break;
                }
                List<WorkOrderCountVO> mapList = this.workStatisticDao.countWorkOrder4New(paramsf);
                List userTask1list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask1")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List userTask2list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask2")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List userTask3list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask3")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List userTask4list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask4")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List userTask6list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask6")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                List userTask7list = mapList.stream().filter(s -> s.getTaskKey().equals("UserTask7")).map(WorkOrderCountVO::getWorkId).collect(Collectors.toList());
                if (value.equals("3")) {
                    ids = new ArrayList();
                    if (null != userTask1list) {
                        ids.addAll(userTask1list);
                    }
                    if (null != userTask7list) {
                        ids.addAll(userTask7list);
                    }
                    query.setValue(ids);
                    break;
                }
                if (value.equals("4")) {
                    ids = new ArrayList();
                    if (null != userTask2list) {
                        ids.addAll(userTask2list);
                    }
                    if (null != userTask3list) {
                        ids.addAll(userTask3list);
                    }
                    query.setValue(ids);
                    break;
                }
                if (value.equals("5")) {
                    ids = new ArrayList();
                    if (null != userTask4list) {
                        ids.addAll(userTask4list);
                    }
                    query.setValue(ids);
                    break;
                }
                if (value.equals("6")) {
                    ids = new ArrayList();
                    if (null != userTask6list) {
                        ids.addAll(userTask6list);
                    }
                    query.setValue(ids);
                    break;
                }
                query.setValue((Object)"-1");
            }
        }
        IPage<WorkOrderVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderVoList((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        for (WorkOrderVo record : results.getRecords()) {
            String contractId = record.getWorkOrderInformation().getContractId();
            Contract contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)contractId)));
            record.setContract(contract);
            record.getWorkOrderInformation().setTotalMoney(((WorkOrderInformationDao)this.baseMapper).selectSumMoney(record.getWorkOrderInformation().getId()));
        }
        return new PageList(results);
    }

    @Override
    public PageList<WorkOrderDiseaseVo> getWorkOrder(QueryFilter queryFilter) {
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        HashMap map = new HashMap();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        Object roadId = map.get("roadId");
        IPage<WorkOrderDiseaseVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderInformation((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        for (WorkOrderDiseaseVo record : results.getRecords()) {
            List<String> ids;
            WorkOrderInformation workOrderInformation = record.getWorkOrderInformation();
            String contractId = workOrderInformation.getContractId();
            Contract contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)contractId)));
            record.setContract(contract);
            String diseaseId = workOrderInformation.getDiseaseId();
            if (StringUtils.isNotBlank((CharSequence)diseaseId) && (ids = Arrays.asList(diseaseId.split(";"))).size() > 0) {
                QueryWrapper diseaseQueryWrapper = new QueryWrapper();
                diseaseQueryWrapper.in((Object)"ID_", ids);
                diseaseQueryWrapper.eq(roadId != null, (Object)"ROAD_ID_", roadId);
                List diseaseList = this.diseaseManager.getBaseMapper().selectList((Wrapper)diseaseQueryWrapper);
                record.setDiseaseList(diseaseList);
            }
            QueryWrapper queryBillOfQuantitiesWrapper = new QueryWrapper();
            queryBillOfQuantitiesWrapper.eq((Object)"WORK_ORDER_INFORMATION_ID_", (Object)workOrderInformation.getId());
            queryBillOfQuantitiesWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryBillOfQuantitiesWrapper.eq((Object)"BILL_TYPE_", (Object)"1");
            List billOfQuantitieslist = this.billOfQuantitiesManager.getBaseMapper().selectList((Wrapper)queryBillOfQuantitiesWrapper);
            record.setBillOfQuantities(billOfQuantitieslist);
            QueryWrapper queryBillOutOfQuantitiesWrapper = new QueryWrapper();
            queryBillOutOfQuantitiesWrapper.eq((Object)"WORK_ORDER_INFORMATION_ID_", (Object)workOrderInformation.getId());
            queryBillOutOfQuantitiesWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryBillOutOfQuantitiesWrapper.eq((Object)"BILL_TYPE_", (Object)"2");
            List billOutOfQuantitieslist = this.billOfQuantitiesManager.getBaseMapper().selectList((Wrapper)queryBillOutOfQuantitiesWrapper);
            record.setBillOutOfQuantities(billOutOfQuantitieslist);
        }
        return new PageList(results);
    }

    @Override
    public CompletableFuture<PageList<Map<String, Object>>> getDoneInstList(String currentUserAccout, QueryFilter queryFilter, String status) throws Exception {
        PageList mapPageList = (PageList)this.iFlowManager.getDoneInstList(currentUserAccout, queryFilter, status).get();
        List rows = mapPageList.getRows();
        if (rows.size() > 0) {
            for (Map row : rows) {
                Object bizKey;
                Object procDefKey = row.get("procDefKey");
                if (!procDefKey.toString().equals("yhgd") || !ObjectUtils.isNotEmpty(bizKey = row.get("bizKey"))) continue;
                WorkOrderInformation workOrderInformation = (WorkOrderInformation)((Object)this.getById((Serializable)((Object)bizKey.toString())));
                Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)workOrderInformation.getRoadSegmentId())));
                workOrderInformation.setRoad(road);
                row.put("workOrderInformation", workOrderInformation);
            }
        }
        return CompletableFuture.completedFuture(mapPageList);
    }

    @Override
    public String getBizkey(String bpmnInstId) {
        return ((WorkOrderInformationDao)this.baseMapper).getBizkey(bpmnInstId);
    }

    @Override
    public Road getRoad(String roadSegmentId) {
        return (Road)((Object)this.roadManager.getById((Serializable)((Object)roadSegmentId)));
    }

    @Override
    public PageList<WorkOrderVo> getWorkOrderVoByBridge(WorkOrderAndBaseIdVo workOrderByBridgeVo) {
        HashMap<String, Integer> diseaseParams;
        QueryFilter queryFilter = workOrderByBridgeVo.getQueryFilter();
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        String bridgeId = workOrderByBridgeVo.getId();
        ArrayList<String> diseaseIdList = new ArrayList<String>();
        QueryFilter queryDiseaseFilter = QueryFilter.build();
        queryDiseaseFilter.addParams("flag", (Object)0);
        PageBean pageBean = queryDiseaseFilter.getPageBean();
        if (null == pageBean) {
            pageBean = new PageBean();
        }
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryDiseaseFilter.setPageBean(pageBean);
        queryDiseaseFilter.addFilter("brige_id_", (Object)bridgeId, QueryOP.EQUAL);
        PageList<Disease> jsonBridgeDiseaseCheck = this.diseaseManager.getJsonBridgeDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck && null != jsonBridgeDiseaseCheck.getRows() && jsonBridgeDiseaseCheck.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (null == (diseaseParams = queryDiseaseFilter.getParams())) {
            diseaseParams = new HashMap<String, Integer>();
        }
        diseaseParams.put("flag", 1);
        PageList<Disease> jsonBridgeDiseaseCheck1 = this.diseaseManager.getJsonBridgeDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck1 && null != jsonBridgeDiseaseCheck1.getRows() && jsonBridgeDiseaseCheck1.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck1.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (diseaseIdList.size() == 0) {
            PageList workOrderVoPageList = new PageList();
            workOrderVoPageList.setTotal(0L);
            workOrderVoPageList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
            workOrderVoPageList.setPage((long)queryFilter.getPageBean().getPage().intValue());
            workOrderVoPageList.setRows(new ArrayList());
            return workOrderVoPageList;
        }
        for (String id : diseaseIdList) {
            queryFilter.addFilter("DISEASE_ID_", (Object)id, QueryOP.LIKE, FieldRelation.OR, "DISEASE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<WorkOrderVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderVo((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public PageList<WorkOrderVo> getWorkOrderVoByTunnel(WorkOrderAndBaseIdVo workOrderByBridgeVo) {
        HashMap<String, Integer> diseaseParams;
        QueryFilter queryFilter = workOrderByBridgeVo.getQueryFilter();
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        String bridgeId = workOrderByBridgeVo.getId();
        ArrayList<String> diseaseIdList = new ArrayList<String>();
        QueryFilter queryDiseaseFilter = QueryFilter.build();
        queryDiseaseFilter.addParams("flag", (Object)0);
        PageBean pageBean = queryDiseaseFilter.getPageBean();
        if (null == pageBean) {
            pageBean = new PageBean();
        }
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryDiseaseFilter.setPageBean(pageBean);
        queryDiseaseFilter.addFilter("TUNNEL_ID_", (Object)bridgeId, QueryOP.EQUAL);
        PageList<Disease> jsonBridgeDiseaseCheck = this.diseaseManager.getJsonTunnelDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck && null != jsonBridgeDiseaseCheck.getRows() && jsonBridgeDiseaseCheck.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (null == (diseaseParams = queryDiseaseFilter.getParams())) {
            diseaseParams = new HashMap<String, Integer>();
        }
        diseaseParams.put("flag", 1);
        PageList<Disease> jsonBridgeDiseaseCheck1 = this.diseaseManager.getJsonTunnelDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck1 && null != jsonBridgeDiseaseCheck1.getRows() && jsonBridgeDiseaseCheck1.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck1.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (diseaseIdList.size() == 0) {
            PageList workOrderVoPageList = new PageList();
            workOrderVoPageList.setTotal(0L);
            workOrderVoPageList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
            workOrderVoPageList.setPage((long)queryFilter.getPageBean().getPage().intValue());
            workOrderVoPageList.setRows(new ArrayList());
            return workOrderVoPageList;
        }
        for (String id : diseaseIdList) {
            queryFilter.addFilter("DISEASE_ID_", (Object)id, QueryOP.LIKE, FieldRelation.OR, "DISEASE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<WorkOrderVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderVo((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public PageList<WorkOrderVo> getWorkOrderVoByCulvert(WorkOrderAndBaseIdVo workOrderByBridgeVo) {
        HashMap<String, Integer> diseaseParams;
        QueryFilter queryFilter = workOrderByBridgeVo.getQueryFilter();
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        String bridgeId = workOrderByBridgeVo.getId();
        ArrayList<String> diseaseIdList = new ArrayList<String>();
        QueryFilter queryDiseaseFilter = QueryFilter.build();
        queryDiseaseFilter.addParams("flag", (Object)0);
        PageBean pageBean = queryDiseaseFilter.getPageBean();
        if (null == pageBean) {
            pageBean = new PageBean();
        }
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryDiseaseFilter.setPageBean(pageBean);
        queryDiseaseFilter.addFilter("CULVERT_ID_", (Object)bridgeId, QueryOP.EQUAL);
        PageList<Disease> jsonBridgeDiseaseCheck = this.diseaseManager.getJsonCulvertDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck && null != jsonBridgeDiseaseCheck.getRows() && jsonBridgeDiseaseCheck.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (null == (diseaseParams = queryDiseaseFilter.getParams())) {
            diseaseParams = new HashMap<String, Integer>();
        }
        diseaseParams.put("flag", 1);
        PageList<Disease> jsonBridgeDiseaseCheck1 = this.diseaseManager.getJsonCulvertDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck1 && null != jsonBridgeDiseaseCheck1.getRows() && jsonBridgeDiseaseCheck1.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck1.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (diseaseIdList.size() == 0) {
            PageList workOrderVoPageList = new PageList();
            workOrderVoPageList.setTotal(0L);
            workOrderVoPageList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
            workOrderVoPageList.setPage((long)queryFilter.getPageBean().getPage().intValue());
            workOrderVoPageList.setRows(new ArrayList());
            return workOrderVoPageList;
        }
        for (String id : diseaseIdList) {
            queryFilter.addFilter("DISEASE_ID_", (Object)id, QueryOP.LIKE, FieldRelation.OR, "DISEASE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<WorkOrderVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderVo((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public PageList<WorkOrderVo> getWorkOrderVoBySideSlope(WorkOrderAndBaseIdVo workOrderByBridgeVo) {
        HashMap<String, Integer> diseaseParams;
        QueryFilter queryFilter = workOrderByBridgeVo.getQueryFilter();
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        String bridgeId = workOrderByBridgeVo.getId();
        ArrayList<String> diseaseIdList = new ArrayList<String>();
        QueryFilter queryDiseaseFilter = QueryFilter.build();
        queryDiseaseFilter.addParams("flag", (Object)0);
        PageBean pageBean = queryDiseaseFilter.getPageBean();
        if (null == pageBean) {
            pageBean = new PageBean();
        }
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryDiseaseFilter.setPageBean(pageBean);
        queryDiseaseFilter.addFilter("SIDE_SLOPE_ID_", (Object)bridgeId, QueryOP.EQUAL);
        PageList<Disease> jsonBridgeDiseaseCheck = this.diseaseManager.getJsonSideDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck && null != jsonBridgeDiseaseCheck.getRows() && jsonBridgeDiseaseCheck.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (null == (diseaseParams = queryDiseaseFilter.getParams())) {
            diseaseParams = new HashMap<String, Integer>();
        }
        diseaseParams.put("flag", 1);
        PageList<Disease> jsonBridgeDiseaseCheck1 = this.diseaseManager.getJsonSideDiseaseCheck((QueryFilter<Disease>)queryDiseaseFilter);
        if (null != jsonBridgeDiseaseCheck1 && null != jsonBridgeDiseaseCheck1.getRows() && jsonBridgeDiseaseCheck1.getRows().size() > 0) {
            List rows = jsonBridgeDiseaseCheck1.getRows();
            for (Disease disease : rows) {
                if (null == disease || !StringUtils.isNotBlank((CharSequence)disease.getId())) continue;
                diseaseIdList.add(disease.getId());
            }
        }
        if (diseaseIdList.size() == 0) {
            PageList workOrderVoPageList = new PageList();
            workOrderVoPageList.setTotal(0L);
            workOrderVoPageList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
            workOrderVoPageList.setPage((long)queryFilter.getPageBean().getPage().intValue());
            workOrderVoPageList.setRows(new ArrayList());
            return workOrderVoPageList;
        }
        for (String id : diseaseIdList) {
            queryFilter.addFilter("DISEASE_ID_", (Object)id, QueryOP.LIKE, FieldRelation.OR, "DISEASE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<WorkOrderVo> results = ((WorkOrderInformationDao)this.baseMapper).getWorkOrderVo((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public void exportWorkOrder(String ids, HttpServletResponse response) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5de5\u5355");
        }
        long time = System.currentTimeMillis();
        String fileName = "\u5de5\u5355\u4fe1\u606f" + time;
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        List<String> strings = Arrays.asList(ids.split(","));
        for (String id : strings) {
            FileOutputStream os;
            WorkOrderInformationVo vo = this.getVo(id);
            WorkOrderInformation workOrderInformation = vo.getWorkOrderInformation();
            List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();
            List<BillOfQuantities> billOutOfQuantities = vo.getBillOutOfQuantities();
            ArrayList<BillOfQuantities> billOfQuantitiesAll = new ArrayList<BillOfQuantities>();
            billOfQuantitiesAll.addAll(billOutOfQuantities);
            billOfQuantitiesAll.addAll(billOfQuantities);
            Contract contract = vo.getContract();
            List<Accessory> accessoriesPre = vo.getAccessoriesPre();
            List<Accessory> accessoriesUnd = vo.getAccessoriesUnd();
            List<Accessory> accessoriesSuf = vo.getAccessoriesSuf();
            List collect = ((Stream)Stream.iterate(0, f -> f + 1).limit((billOfQuantitiesAll.size() + 5) / 6).parallel()).map(a -> ((Stream)billOfQuantitiesAll.stream().skip(a * 6).limit(6L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("\u516c\u8def\u65e5\u5e38\u517b\u62a4\u5de5\u7a0b");
            sheet.setColumnWidth(0, 2560);
            sheet.setColumnWidth(1, 7680);
            sheet.setColumnWidth(2, 2560);
            sheet.setColumnWidth(3, 2560);
            sheet.setColumnWidth(4, 3840);
            sheet.setColumnWidth(5, 2048);
            sheet.setColumnWidth(6, 3840);
            sheet.setColumnWidth(7, 2048);
            sheet.setColumnWidth(8, 2048);
            sheet.setColumnWidth(9, 2048);
            sheet.setColumnWidth(10, 2048);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
            HSSFCellStyle cellStyleLeft = workbook.createCellStyle();
            HSSFCellStyle cellStyleLeftAlign = workbook.createCellStyle();
            HSSFCellStyle cellStyleRight = workbook.createCellStyle();
            HSSFCellStyle cellStyleSmall = workbook.createCellStyle();
            HSSFCellStyle cellStyleNoLine = workbook.createCellStyle();
            HSSFCellStyle cellStyleTitleNoLine = workbook.createCellStyle();
            PoiStyleUtil.setExcelStyle(cellStyle, workbook);
            PoiStyleUtil.setExcelStyleNoLine(cellStyleNoLine, workbook);
            PoiStyleUtil.setExcelStyleSmall(cellStyleSmall, workbook);
            PoiStyleUtil.setExcelStyleTitleOne(cellStyleTitle, workbook);
            PoiStyleUtil.setExcelStyleTitleNoLine(cellStyleTitleNoLine, workbook);
            PoiStyleUtil.setExcelStyleLeft(cellStyleLeft, workbook);
            PoiStyleUtil.setExcelStyleRight(cellStyleRight, workbook);
            PoiStyleUtil.setExcelStyleLeftAlign(cellStyleLeftAlign, workbook);
            sheet.getPrintSetup().setPaperSize((short)9);
            sheet.getPrintSetup().setLandscape(true);
            Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)workOrderInformation.getRoadSegmentId())));
            int num = 0;
            if (collect.size() > 0) {
                for (List ofQuantities : collect) {
                    HSSFRow row9;
                    int i;
                    HSSFRow row = sheet.createRow(num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                    ++num;
                    HSSFCell cell = row.createCell(0);
                    cell.setCellValue(road.getCode() + road.getName() + "\u516c\u8def\u65e5\u5e38\u517b\u62a4\u5de5\u7a0b");
                    cell.setCellStyle(cellStyleNoLine);
                    row.createCell(1).setCellStyle(cellStyleNoLine);
                    row.createCell(2).setCellStyle(cellStyleNoLine);
                    row.createCell(3).setCellStyle(cellStyleNoLine);
                    row.createCell(4).setCellStyle(cellStyleNoLine);
                    row.createCell(5).setCellStyle(cellStyleNoLine);
                    row.createCell(6).setCellStyle(cellStyleNoLine);
                    row.createCell(7).setCellStyle(cellStyleNoLine);
                    row.createCell(8).setCellStyle(cellStyleNoLine);
                    row.createCell(9).setCellStyle(cellStyleNoLine);
                    row.createCell(10).setCellStyle(cellStyleNoLine);
                    HSSFRow row1 = sheet.createRow(num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                    ++num;
                    HSSFCell cell1 = row1.createCell(0);
                    cell1.setCellValue("\u6d3e\u5de5/\u9a8c\u6536\u8ba1\u91cf\u5355");
                    cell1.setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(1).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(2).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(3).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(4).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(5).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(6).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(7).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(8).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(9).setCellStyle(cellStyleTitleNoLine);
                    row1.createCell(10).setCellStyle(cellStyleTitleNoLine);
                    HSSFRow row2 = sheet.createRow(num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 10));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    HSSFCell cell2 = row2.createCell(0);
                    cell2.setCellValue("\u6d3e\u5de5\u7f16\u53f7");
                    cell2.setCellStyle(cellStyle);
                    HSSFCell cell3 = row2.createCell(2);
                    cell3.setCellValue(workOrderInformation.getJobNumber());
                    cell3.setCellStyle(cellStyle);
                    row2.createCell(1).setCellStyle(cellStyle);
                    row2.createCell(3).setCellStyle(cellStyle);
                    row2.createCell(4).setCellStyle(cellStyle);
                    row2.createCell(5).setCellStyle(cellStyle);
                    row2.createCell(6).setCellStyle(cellStyle);
                    row2.createCell(7).setCellStyle(cellStyle);
                    row2.createCell(8).setCellStyle(cellStyle);
                    row2.createCell(9).setCellStyle(cellStyle);
                    row2.createCell(10).setCellStyle(cellStyle);
                    HSSFRow row3 = sheet.createRow(++num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                    HSSFCell cell4 = row3.createCell(0);
                    cell4.setCellValue("\u6d3e       \u5de5       \u65b9");
                    HSSFCell cell5 = row3.createCell(2);
                    cell5.setCellValue(contract.getFirstParty());
                    HSSFCell cell6 = row3.createCell(6);
                    cell6.setCellValue("\u627f       \u5305       \u65b9");
                    HSSFCell cell7 = row3.createCell(7);
                    cell7.setCellValue(contract.getSecondParty());
                    cell4.setCellStyle(cellStyle);
                    cell5.setCellStyle(cellStyle);
                    cell6.setCellStyle(cellStyle);
                    cell7.setCellStyle(cellStyle);
                    row3.createCell(1).setCellStyle(cellStyle);
                    row3.createCell(3).setCellStyle(cellStyle);
                    row3.createCell(4).setCellStyle(cellStyle);
                    row3.createCell(5).setCellStyle(cellStyle);
                    row3.createCell(8).setCellStyle(cellStyle);
                    row3.createCell(9).setCellStyle(cellStyle);
                    row3.createCell(10).setCellStyle(cellStyle);
                    HSSFRow row4 = sheet.createRow(++num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                    HSSFCell cell8 = row4.createCell(0);
                    cell8.setCellValue("\u6d3e   \u5de5   \u539f   \u56e0   ");
                    HSSFCell cell9 = row4.createCell(2);
                    cell9.setCellValue(workOrderInformation.getTaskContent());
                    HSSFCell cell10 = row4.createCell(6);
                    cell10.setCellValue("\u6869  \u53f7   \u4f4d   \u7f6e   ");
                    HSSFCell cell11 = row4.createCell(7);
                    cell11.setCellValue(workOrderInformation.getPosition());
                    cell8.setCellStyle(cellStyle);
                    cell9.setCellStyle(cellStyle);
                    cell10.setCellStyle(cellStyle);
                    cell11.setCellStyle(cellStyle);
                    row4.createCell(1).setCellStyle(cellStyle);
                    row4.createCell(3).setCellStyle(cellStyle);
                    row4.createCell(4).setCellStyle(cellStyle);
                    row4.createCell(5).setCellStyle(cellStyle);
                    row4.createCell(8).setCellStyle(cellStyle);
                    row4.createCell(9).setCellStyle(cellStyle);
                    row4.createCell(10).setCellStyle(cellStyle);
                    HSSFRow row5 = sheet.createRow(++num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                    ++num;
                    HSSFCell cell12 = row5.createCell(0);
                    cell12.setCellValue("\u5de5  \u4f5c   \u6982   \u51b5   ");
                    HSSFCell cell13 = row5.createCell(2);
                    cell13.setCellValue(workOrderInformation.getRemarks());
                    HSSFCell cell14 = row5.createCell(6);
                    cell14.setCellValue("\u5de5  \u671f   \u8981   \u6c42   ");
                    HSSFCell cell15 = row5.createCell(7);
                    cell15.setCellValue(workOrderInformation.getDemandFinishTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    cell12.setCellStyle(cellStyle);
                    cell13.setCellStyle(cellStyle);
                    cell14.setCellStyle(cellStyle);
                    cell15.setCellStyle(cellStyle);
                    row5.createCell(1).setCellStyle(cellStyle);
                    row5.createCell(3).setCellStyle(cellStyle);
                    row5.createCell(4).setCellStyle(cellStyle);
                    row5.createCell(5).setCellStyle(cellStyle);
                    row5.createCell(8).setCellStyle(cellStyle);
                    row5.createCell(9).setCellStyle(cellStyle);
                    row5.createCell(10).setCellStyle(cellStyle);
                    HSSFRow row7 = sheet.createRow(num);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                    ++num;
                    HSSFCell cell16 = row7.createCell(0);
                    cell16.setCellValue("\u6d3e\u5de5\u8054");
                    HSSFCell cell17 = row7.createCell(6);
                    cell17.setCellValue("\u8d28\u91cf\u8981\u6c42\u3001\u9a8c\u6536\u6807\u51c6\u3001\u7b80\u56fe\u3001\u8ba1\u7b97\u5f0f\u7b49");
                    HSSFCell cell18 = row7.createCell(7);
                    cell18.setCellValue("\u9a8c\u6536\u3001\u8ba1\u91cf\u5355");
                    cell16.setCellStyle(cellStyle);
                    cell17.setCellStyle(cellStyle);
                    cell18.setCellStyle(cellStyle);
                    row7.createCell(1).setCellStyle(cellStyle);
                    row7.createCell(2).setCellStyle(cellStyle);
                    row7.createCell(3).setCellStyle(cellStyle);
                    row7.createCell(4).setCellStyle(cellStyle);
                    row7.createCell(5).setCellStyle(cellStyle);
                    row7.createCell(8).setCellStyle(cellStyle);
                    row7.createCell(9).setCellStyle(cellStyle);
                    row7.createCell(10).setCellStyle(cellStyle);
                    HSSFRow row8 = sheet.createRow(num);
                    sheet.addMergedRegion(new CellRangeAddress(num - 1, num, 6, 6));
                    ++num;
                    HSSFCell cell19 = row8.createCell(0);
                    cell19.setCellValue("\u9879\u6b21");
                    HSSFCell cell20 = row8.createCell(1);
                    cell20.setCellValue("\u5de5\u4f5c\u9879");
                    HSSFCell cell21 = row8.createCell(2);
                    cell21.setCellValue("\u5355\u4f4d");
                    HSSFCell cell22 = row8.createCell(3);
                    cell22.setCellValue("\u6570\u91cf");
                    HSSFCell cell23 = row8.createCell(4);
                    cell23.setCellValue("\u5355\u4ef7(\u5143)");
                    HSSFCell cell24 = row8.createCell(5);
                    cell24.setCellValue("\u5408\u4ef7(\u5143)");
                    HSSFCell cell25 = row8.createCell(7);
                    cell25.setCellValue("\u8d28\u91cf\u8bc4\u4ef7");
                    HSSFCell cell26 = row8.createCell(8);
                    cell26.setCellValue("\u6570\u91cf");
                    HSSFCell cell27 = row8.createCell(9);
                    cell27.setCellValue("\u5355\u4ef7(\u5143)");
                    HSSFCell cell28 = row8.createCell(10);
                    cell28.setCellValue("\u5408\u4ef7(\u5143)");
                    cell19.setCellStyle(cellStyle);
                    cell20.setCellStyle(cellStyle);
                    cell21.setCellStyle(cellStyle);
                    cell22.setCellStyle(cellStyle);
                    cell23.setCellStyle(cellStyle);
                    cell24.setCellStyle(cellStyle);
                    cell25.setCellStyle(cellStyle);
                    cell26.setCellStyle(cellStyle);
                    cell27.setCellStyle(cellStyle);
                    cell28.setCellStyle(cellStyle);
                    row8.createCell(6).setCellStyle(cellStyle);
                    row.setHeight((short)640);
                    row1.setHeight((short)640);
                    row2.setHeight((short)500);
                    row3.setHeight((short)440);
                    row4.setHeight((short)440);
                    row5.setHeight((short)440);
                    row7.setHeight((short)440);
                    row8.setHeight((short)440);
                    int itemNumber = 1;
                    for (i = 0; i < ofQuantities.size(); ++i) {
                        row9 = sheet.createRow(num);
                        ++num;
                        BillOfQuantities billOfQuantity = (BillOfQuantities)((Object)ofQuantities.get(i));
                        HSSFCell cell29 = row9.createCell(0);
                        cell29.setCellValue((double)itemNumber++);
                        HSSFCell cell30 = row9.createCell(1);
                        if (billOfQuantity.getSonSubjectName() != null && !"".equals(billOfQuantity.getSonSubjectName())) {
                            cell30.setCellValue(billOfQuantity.getSonSubjectName());
                        } else if (billOfQuantity.getFineSubjectName() != null && !"".equals(billOfQuantity.getFineSubjectName()) && (billOfQuantity.getSonSubjectName() == null || "".equals(billOfQuantity.getSonSubjectName()))) {
                            cell30.setCellValue(billOfQuantity.getFineSubjectName());
                        } else {
                            cell30.setCellValue(billOfQuantity.getSubjectName());
                        }
                        HSSFCell cell31 = row9.createCell(2);
                        cell31.setCellValue(billOfQuantity.getSpec());
                        HSSFCell cell32 = row9.createCell(3);
                        cell32.setCellValue(String.format("%.2f", billOfQuantity.getAmount()));
                        HSSFCell cell33 = row9.createCell(4);
                        cell33.setCellValue(String.format("%.2f", billOfQuantity.getPrice()));
                        HSSFCell cell34 = row9.createCell(5);
                        float v = billOfQuantity.getAmount().floatValue() * billOfQuantity.getPrice().floatValue();
                        cell34.setCellValue(String.format("%.2f", Float.valueOf(v)));
                        HSSFCell cell35 = row9.createCell(7);
                        cell35.setCellValue("\u5408\u683c");
                        HSSFCell cell36 = row9.createCell(8);
                        cell36.setCellValue(String.format("%.2f", billOfQuantity.getAuditAmount()));
                        HSSFCell cell37 = row9.createCell(9);
                        cell37.setCellValue(String.format("%.2f", billOfQuantity.getAuditPrice()));
                        HSSFCell cell38 = row9.createCell(10);
                        cell38.setCellValue(String.format("%.2f", billOfQuantity.getAuditMoney()));
                        cell29.setCellStyle(cellStyle);
                        cell30.setCellStyle(cellStyle);
                        cell31.setCellStyle(cellStyle);
                        cell32.setCellStyle(cellStyle);
                        cell33.setCellStyle(cellStyle);
                        cell34.setCellStyle(cellStyle);
                        cell35.setCellStyle(cellStyle);
                        cell36.setCellStyle(cellStyle);
                        cell37.setCellStyle(cellStyle);
                        cell38.setCellStyle(cellStyle);
                        HSSFCell cell39 = row9.createCell(6);
                        cell39.setCellValue(workOrderInformation.getConstructionDesc());
                        cell39.setCellStyle(cellStyle);
                        row9.setHeight((short)400);
                    }
                    if (ofQuantities.size() < 6) {
                        for (i = 0; i < 6 - ofQuantities.size(); ++i) {
                            row9 = sheet.createRow(num);
                            ++num;
                            HSSFCell cell29 = row9.createCell(0);
                            cell29.setCellValue((double)itemNumber++);
                            HSSFCell cell30 = row9.createCell(1);
                            HSSFCell cell31 = row9.createCell(2);
                            HSSFCell cell32 = row9.createCell(3);
                            HSSFCell cell33 = row9.createCell(4);
                            HSSFCell cell34 = row9.createCell(5);
                            HSSFCell cell35 = row9.createCell(7);
                            HSSFCell cell36 = row9.createCell(8);
                            HSSFCell cell37 = row9.createCell(9);
                            HSSFCell cell38 = row9.createCell(10);
                            cell29.setCellStyle(cellStyle);
                            cell30.setCellStyle(cellStyle);
                            cell31.setCellStyle(cellStyle);
                            cell32.setCellStyle(cellStyle);
                            cell33.setCellStyle(cellStyle);
                            cell34.setCellStyle(cellStyle);
                            cell35.setCellStyle(cellStyle);
                            cell36.setCellStyle(cellStyle);
                            cell37.setCellStyle(cellStyle);
                            cell38.setCellStyle(cellStyle);
                            row9.createCell(6).setCellStyle(cellStyle);
                            row9.setHeight((short)360);
                        }
                    }
                    sheet.addMergedRegion(new CellRangeAddress(num - 6, num - 1, 6, 6));
                    HSSFRow row92 = sheet.createRow(num);
                    ++num;
                    HSSFCell cell29 = row92.createCell(1);
                    cell29.setCellValue("\u5408\u8ba1");
                    cell29.setCellStyle(cellStyle);
                    HSSFCell cell30 = row92.createCell(5);
                    double sum = ofQuantities.stream().mapToDouble(BillOfQuantities::getMoney).sum();
                    double sumAuditMoney = ofQuantities.stream().mapToDouble(BillOfQuantities::getAuditMoney).sum();
                    cell30.setCellValue(String.format("%.2f", sum));
                    cell30.setCellStyle(cellStyle);
                    row92.createCell(0).setCellStyle(cellStyle);
                    row92.createCell(2).setCellStyle(cellStyle);
                    row92.createCell(3).setCellStyle(cellStyle);
                    row92.createCell(4).setCellStyle(cellStyle);
                    row92.createCell(6).setCellStyle(cellStyle);
                    row92.createCell(7).setCellStyle(cellStyle);
                    row92.createCell(8).setCellStyle(cellStyle);
                    row92.createCell(9).setCellStyle(cellStyle);
                    HSSFCell cell47 = row92.createCell(10);
                    cell47.setCellStyle(cellStyle);
                    cell47.setCellValue(String.format("%.2f", sumAuditMoney));
                    row92.setHeight((short)400);
                    HSSFRow row10 = sheet.createRow(num);
                    HSSFCell cell31 = row10.createCell(0);
                    cell31.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
                    HSSFCell cell32 = row10.createCell(2);
                    cell31.setCellStyle(cellStyleLeft);
                    cell32.setCellValue(workOrderInformation.getIssuer());
                    HSSFCell cell33 = row10.createCell(4);
                    cell33.setCellValue("\u627f\u5305\u65b9\u7ecf\u529e\u4eba");
                    row10.createCell(6).setCellValue(workOrderInformation.getAssignedPersonnel());
                    HSSFCell cell34 = row10.createCell(7);
                    cell34.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
                    cell34.setCellStyle(cellStyleLeft);
                    HSSFCell cell35 = row10.createCell(9);
                    cell35.setCellValue(workOrderInformation.getMaintenanceStationAudit());
                    row10.createCell(10).setCellStyle(cellStyleRight);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                    HSSFRow row11 = sheet.createRow(++num);
                    HSSFCell cell36 = row11.createCell(0);
                    cell36.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
                    cell36.setCellStyle(cellStyleLeft);
                    HSSFCell cell37 = row11.createCell(2);
                    cell37.setCellValue(workOrderInformation.getMaintenanceDept());
                    HSSFCell cell38 = row11.createCell(4);
                    cell38.setCellValue("\u627f\u5305\u65b9\u8d1f\u8d23\u4eba");
                    HSSFCell cell388 = row11.createCell(6);
                    cell388.setCellValue(workOrderInformation.getReceivingPartyReview());
                    HSSFCell cell39 = row11.createCell(7);
                    cell39.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
                    cell39.setCellStyle(cellStyleLeft);
                    HSSFCell cell40 = row11.createCell(9);
                    row11.createCell(10).setCellStyle(cellStyleRight);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                    cell40.setCellValue(workOrderInformation.getMaintenanceDept());
                    HSSFRow row12 = sheet.createRow(++num);
                    HSSFCell cell41 = row12.createCell(0);
                    cell41.setCellValue("\u6d3e\u5de5\u65e5\u671f");
                    cell41.setCellStyle(cellStyleLeft);
                    HSSFCell cell42 = row12.createCell(2);
                    if (workOrderInformation.getCreateTime() != null) {
                        row12.createCell(2).setCellValue(workOrderInformation.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    }
                    HSSFCell cell43 = row12.createCell(4);
                    cell43.setCellValue("\u5b8c\u6210\u65e5\u671f");
                    HSSFCell cell45 = row12.createCell(6);
                    if (workOrderInformation.getConstructionFinishTime() != null) {
                        cell45.setCellValue(workOrderInformation.getConstructionFinishTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    }
                    HSSFCell cell44 = row12.createCell(7);
                    cell44.setCellValue("\u9a8c\u6536\u65e5\u671f");
                    cell44.setCellStyle(cellStyleLeft);
                    if (workOrderInformation.getEndTime() != null) {
                        row12.createCell(9).setCellValue(workOrderInformation.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    }
                    row12.createCell(10).setCellStyle(cellStyleRight);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                    row10.setHeight((short)560);
                    row11.setHeight((short)560);
                    row12.setHeight((short)560);
                    HSSFRow row13 = sheet.createRow(++num);
                    HSSFCell cell46 = row13.createCell(0);
                    cell46.setCellValue("\u9644\u4ef6\u8d44\u6599\uff1a\u25a1\u6280\u672f\u4ea4\u5e95\uff1b\u25a1\u65bd\u5de5\u56fe\uff1b\u25a1\u7167\u7247\u8d44\u6599\uff1b\u25a1\u5de5\u7a0b\u91cf\u8ba1\u7b97\u5f0f\uff1b\u25a1\u7ae3\u5de5\u56fe\uff1b\u25a1\u5176\u4ed6");
                    cell46.setCellStyle(cellStyleLeftAlign);
                    row13.createCell(1).setCellStyle(cellStyleLeftAlign);
                    HSSFCell cell48 = row13.createCell(2);
                    cell48.setCellStyle(cellStyleLeftAlign);
                    row13.createCell(3).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(4).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(5).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(6).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(7).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(8).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(9).setCellStyle(cellStyleLeftAlign);
                    row13.createCell(10).setCellStyle(cellStyleLeftAlign);
                    sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                    ++num;
                    row13.setHeight((short)400);
                }
            } else {
                HSSFCell cell35;
                HSSFCell cell34;
                HSSFCell cell33;
                HSSFCell cell32;
                HSSFCell cell31;
                HSSFRow row = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                ++num;
                HSSFCell cell = row.createCell(0);
                cell.setCellValue(road.getCode() + road.getName() + "\u516c\u8def\u65e5\u5e38\u517b\u62a4\u5de5\u7a0b");
                cell.setCellStyle(cellStyleNoLine);
                row.createCell(1).setCellStyle(cellStyleNoLine);
                row.createCell(2).setCellStyle(cellStyleNoLine);
                row.createCell(3).setCellStyle(cellStyleNoLine);
                row.createCell(4).setCellStyle(cellStyleNoLine);
                row.createCell(5).setCellStyle(cellStyleNoLine);
                row.createCell(6).setCellStyle(cellStyleNoLine);
                row.createCell(7).setCellStyle(cellStyleNoLine);
                row.createCell(8).setCellStyle(cellStyleNoLine);
                row.createCell(9).setCellStyle(cellStyleNoLine);
                row.createCell(10).setCellStyle(cellStyleNoLine);
                HSSFRow row1 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                ++num;
                HSSFCell cell1 = row1.createCell(0);
                cell1.setCellValue("\u6d3e\u5de5/\u9a8c\u6536\u8ba1\u91cf\u5355");
                cell1.setCellStyle(cellStyleTitleNoLine);
                row1.createCell(1).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(2).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(3).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(4).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(5).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(6).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(7).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(8).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(9).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(10).setCellStyle(cellStyleTitleNoLine);
                HSSFRow row2 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                ++num;
                HSSFCell cell2 = row2.createCell(8);
                cell2.setCellValue("\u7f16\u53f7");
                cell2.setCellStyle(cellStyle);
                row2.createCell(0).setCellStyle(cellStyle);
                row2.createCell(1).setCellStyle(cellStyle);
                row2.createCell(2).setCellStyle(cellStyle);
                row2.createCell(3).setCellStyle(cellStyle);
                row2.createCell(4).setCellStyle(cellStyle);
                row2.createCell(5).setCellStyle(cellStyle);
                row2.createCell(6).setCellStyle(cellStyle);
                row2.createCell(7).setCellStyle(cellStyle);
                row2.createCell(10).setCellStyle(cellStyle);
                HSSFCell cell3 = row2.createCell(9);
                cell3.setCellValue(workOrderInformation.getJobNumber());
                cell3.setCellStyle(cellStyle);
                HSSFRow row3 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                ++num;
                HSSFCell cell4 = row3.createCell(0);
                cell4.setCellValue("\u6d3e       \u5de5       \u65b9");
                HSSFCell cell5 = row3.createCell(2);
                cell5.setCellValue(contract.getFirstParty());
                HSSFCell cell6 = row3.createCell(6);
                cell6.setCellValue("\u627f       \u5305       \u65b9");
                HSSFCell cell7 = row3.createCell(7);
                cell7.setCellValue(contract.getSecondParty());
                cell4.setCellStyle(cellStyle);
                cell5.setCellStyle(cellStyle);
                cell6.setCellStyle(cellStyle);
                cell7.setCellStyle(cellStyle);
                row3.createCell(1).setCellStyle(cellStyle);
                row3.createCell(3).setCellStyle(cellStyle);
                row3.createCell(4).setCellStyle(cellStyle);
                row3.createCell(5).setCellStyle(cellStyle);
                row3.createCell(8).setCellStyle(cellStyle);
                row3.createCell(9).setCellStyle(cellStyle);
                row3.createCell(10).setCellStyle(cellStyle);
                HSSFRow row4 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                ++num;
                HSSFCell cell8 = row4.createCell(0);
                cell8.setCellValue("\u6d3e   \u5de5   \u539f   \u56e0   ");
                HSSFCell cell9 = row4.createCell(2);
                cell9.setCellValue(workOrderInformation.getTaskContent());
                HSSFCell cell10 = row4.createCell(6);
                cell10.setCellValue("\u6869  \u53f7   \u4f4d   \u7f6e   ");
                HSSFCell cell11 = row4.createCell(7);
                cell11.setCellValue(workOrderInformation.getPosition());
                cell8.setCellStyle(cellStyle);
                cell9.setCellStyle(cellStyle);
                cell10.setCellStyle(cellStyle);
                cell11.setCellStyle(cellStyle);
                row4.createCell(1).setCellStyle(cellStyle);
                row4.createCell(3).setCellStyle(cellStyle);
                row4.createCell(4).setCellStyle(cellStyle);
                row4.createCell(5).setCellStyle(cellStyle);
                row4.createCell(8).setCellStyle(cellStyle);
                row4.createCell(9).setCellStyle(cellStyle);
                row4.createCell(10).setCellStyle(cellStyle);
                HSSFRow row5 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                ++num;
                HSSFCell cell12 = row5.createCell(0);
                cell12.setCellValue("\u5de5  \u4f5c   \u6982   \u51b5   ");
                HSSFCell cell13 = row5.createCell(2);
                cell13.setCellValue(workOrderInformation.getRemarks());
                HSSFCell cell14 = row5.createCell(6);
                cell14.setCellValue("\u5de5  \u671f   \u8981   \u6c42   ");
                HSSFCell cell15 = row5.createCell(7);
                cell15.setCellValue(workOrderInformation.getDemandFinishTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                cell12.setCellStyle(cellStyle);
                cell13.setCellStyle(cellStyle);
                cell14.setCellStyle(cellStyle);
                cell15.setCellStyle(cellStyle);
                row5.createCell(1).setCellStyle(cellStyle);
                row5.createCell(3).setCellStyle(cellStyle);
                row5.createCell(4).setCellStyle(cellStyle);
                row5.createCell(5).setCellStyle(cellStyle);
                row5.createCell(8).setCellStyle(cellStyle);
                row5.createCell(9).setCellStyle(cellStyle);
                row5.createCell(10).setCellStyle(cellStyle);
                HSSFRow row7 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 10));
                ++num;
                HSSFCell cell16 = row7.createCell(0);
                cell16.setCellValue("\u6d3e\u5de5\u8054");
                HSSFCell cell17 = row7.createCell(6);
                cell17.setCellValue("\u8d28\u91cf\u8981\u6c42\u3001\u9a8c\u6536\u6807\u51c6\u3001\u7b80\u56fe\u3001\u8ba1\u7b97\u5f0f\u7b49");
                HSSFCell cell18 = row7.createCell(7);
                cell18.setCellValue("\u9a8c\u6536\u3001\u8ba1\u91cf\u5355");
                cell16.setCellStyle(cellStyle);
                cell17.setCellStyle(cellStyle);
                cell18.setCellStyle(cellStyle);
                row7.createCell(1).setCellStyle(cellStyle);
                row7.createCell(2).setCellStyle(cellStyle);
                row7.createCell(3).setCellStyle(cellStyle);
                row7.createCell(4).setCellStyle(cellStyle);
                row7.createCell(5).setCellStyle(cellStyle);
                row7.createCell(8).setCellStyle(cellStyle);
                row7.createCell(9).setCellStyle(cellStyle);
                row7.createCell(10).setCellStyle(cellStyle);
                HSSFRow row8 = sheet.createRow(num);
                sheet.addMergedRegion(new CellRangeAddress(num - 1, num, 6, 6));
                ++num;
                HSSFCell cell19 = row8.createCell(0);
                cell19.setCellValue("\u9879\u6b21");
                HSSFCell cell20 = row8.createCell(1);
                cell20.setCellValue("\u5de5\u4f5c\u9879");
                HSSFCell cell21 = row8.createCell(2);
                cell21.setCellValue("\u5355\u4f4d");
                HSSFCell cell22 = row8.createCell(3);
                cell22.setCellValue("\u6570\u91cf");
                HSSFCell cell23 = row8.createCell(4);
                cell23.setCellValue("\u5355\u4ef7(\u5143)");
                HSSFCell cell24 = row8.createCell(5);
                cell24.setCellValue("\u5408\u4ef7(\u5143)");
                HSSFCell cell25 = row8.createCell(7);
                cell25.setCellValue("\u8d28\u91cf\u8bc4\u4ef7");
                HSSFCell cell26 = row8.createCell(8);
                cell26.setCellValue("\u6570\u91cf");
                HSSFCell cell27 = row8.createCell(9);
                cell27.setCellValue("\u5355\u4ef7(\u5143)");
                HSSFCell cell28 = row8.createCell(10);
                cell28.setCellValue("\u5408\u4ef7(\u5143)");
                cell19.setCellStyle(cellStyle);
                cell20.setCellStyle(cellStyle);
                cell21.setCellStyle(cellStyle);
                cell22.setCellStyle(cellStyle);
                cell23.setCellStyle(cellStyle);
                cell24.setCellStyle(cellStyle);
                cell25.setCellStyle(cellStyle);
                cell26.setCellStyle(cellStyle);
                cell27.setCellStyle(cellStyle);
                cell28.setCellStyle(cellStyle);
                row8.createCell(6).setCellStyle(cellStyle);
                row.setHeight((short)640);
                row1.setHeight((short)640);
                row2.setHeight((short)260);
                row3.setHeight((short)440);
                row4.setHeight((short)440);
                row5.setHeight((short)440);
                row7.setHeight((short)440);
                row8.setHeight((short)440);
                int itemNumber = 1;
                for (int i = 0; i < 6; ++i) {
                    HSSFRow row9 = sheet.createRow(num);
                    ++num;
                    HSSFCell cell29 = row9.createCell(0);
                    cell29.setCellValue((double)itemNumber++);
                    HSSFCell cell30 = row9.createCell(1);
                    cell31 = row9.createCell(2);
                    cell32 = row9.createCell(3);
                    cell33 = row9.createCell(4);
                    cell34 = row9.createCell(5);
                    cell35 = row9.createCell(7);
                    HSSFCell cell36 = row9.createCell(8);
                    HSSFCell cell37 = row9.createCell(9);
                    HSSFCell cell38 = row9.createCell(10);
                    cell29.setCellStyle(cellStyle);
                    cell30.setCellStyle(cellStyle);
                    cell31.setCellStyle(cellStyle);
                    cell32.setCellStyle(cellStyle);
                    cell33.setCellStyle(cellStyle);
                    cell34.setCellStyle(cellStyle);
                    cell35.setCellStyle(cellStyle);
                    cell36.setCellStyle(cellStyle);
                    cell37.setCellStyle(cellStyle);
                    cell38.setCellStyle(cellStyle);
                    row9.createCell(6).setCellStyle(cellStyle);
                    row9.setHeight((short)400);
                }
                sheet.addMergedRegion(new CellRangeAddress(num - 6, num - 1, 6, 6));
                HSSFRow row9 = sheet.createRow(num);
                ++num;
                HSSFCell cell29 = row9.createCell(1);
                cell29.setCellValue("\u5408\u8ba1");
                cell29.setCellStyle(cellStyle);
                HSSFCell cell30 = row9.createCell(5);
                cell30.setCellValue(0.0);
                cell30.setCellStyle(cellStyle);
                row9.createCell(0).setCellStyle(cellStyle);
                row9.createCell(2).setCellStyle(cellStyle);
                row9.createCell(3).setCellStyle(cellStyle);
                row9.createCell(4).setCellStyle(cellStyle);
                row9.createCell(6).setCellStyle(cellStyle);
                row9.createCell(7).setCellStyle(cellStyle);
                row9.createCell(8).setCellStyle(cellStyle);
                row9.createCell(9).setCellStyle(cellStyle);
                row9.createCell(10).setCellStyle(cellStyle);
                row9.setHeight((short)400);
                HSSFRow row10 = sheet.createRow(num);
                cell31 = row10.createCell(0);
                cell31.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
                cell32 = row10.createCell(2);
                cell31.setCellStyle(cellStyleLeft);
                cell32.setCellValue(workOrderInformation.getIssuer());
                cell33 = row10.createCell(4);
                cell33.setCellValue("\u627f\u5305\u65b9\u7ecf\u529e\u4eba");
                row10.createCell(6).setCellValue(workOrderInformation.getAssignedPersonnel());
                cell34 = row10.createCell(7);
                cell34.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
                cell34.setCellStyle(cellStyleLeft);
                cell35 = row10.createCell(9);
                cell35.setCellValue(workOrderInformation.getIssuer());
                row10.createCell(10).setCellStyle(cellStyleRight);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                HSSFRow row11 = sheet.createRow(++num);
                HSSFCell cell36 = row11.createCell(0);
                cell36.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
                cell36.setCellStyle(cellStyleLeft);
                HSSFCell cell37 = row11.createCell(2);
                cell37.setCellValue(workOrderInformation.getMaintenanceDept());
                HSSFCell cell38 = row11.createCell(4);
                cell38.setCellValue("\u627f\u5305\u65b9\u8d1f\u8d23\u4eba");
                HSSFCell cell388 = row11.createCell(6);
                cell388.setCellValue(workOrderInformation.getReceivingPartyReview());
                HSSFCell cell39 = row11.createCell(7);
                cell39.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
                cell39.setCellStyle(cellStyleLeft);
                HSSFCell cell40 = row11.createCell(9);
                row11.createCell(10).setCellStyle(cellStyleRight);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                cell40.setCellValue(workOrderInformation.getMaintenanceDept());
                HSSFRow row12 = sheet.createRow(++num);
                HSSFCell cell41 = row12.createCell(0);
                cell41.setCellValue("\u6d3e\u5de5\u65e5\u671f");
                cell41.setCellStyle(cellStyleLeft);
                HSSFCell cell42 = row12.createCell(2);
                if (workOrderInformation.getCreateTime() != null) {
                    cell42.setCellValue(workOrderInformation.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                HSSFCell cell43 = row12.createCell(4);
                cell43.setCellValue("\u5b8c\u6210\u65e5\u671f");
                HSSFCell cell45 = row12.createCell(6);
                if (workOrderInformation.getConstructionFinishTime() != null) {
                    cell45.setCellValue(workOrderInformation.getConstructionFinishTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                HSSFCell cell44 = row12.createCell(7);
                cell44.setCellValue("\u9a8c\u6536\u65e5\u671f");
                cell44.setCellStyle(cellStyleLeft);
                if (workOrderInformation.getEndTime() != null) {
                    row12.createCell(9).setCellValue(workOrderInformation.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                }
                row12.createCell(10).setCellStyle(cellStyleRight);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 1));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 2, 3));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 4, 5));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 7, 8));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 9, 10));
                row10.setHeight((short)560);
                row11.setHeight((short)560);
                row12.setHeight((short)560);
                HSSFRow row13 = sheet.createRow(++num);
                HSSFCell cell46 = row13.createCell(0);
                cell46.setCellValue("\u9644\u4ef6\u8d44\u6599\uff1a\u25a1\u6280\u672f\u4ea4\u5e95\uff1b\u25a1\u65bd\u5de5\u56fe\uff1b\u25a1\u7167\u7247\u8d44\u6599\uff1b\u25a1\u5de5\u7a0b\u91cf\u8ba1\u7b97\u5f0f\uff1b\u25a1\u7ae3\u5de5\u56fe\uff1b\u25a1\u5176\u4ed6");
                cell46.setCellStyle(cellStyleLeftAlign);
                row13.createCell(1).setCellStyle(cellStyleLeftAlign);
                HSSFCell cell48 = row13.createCell(2);
                cell48.setCellStyle(cellStyleLeftAlign);
                row13.createCell(3).setCellStyle(cellStyleLeftAlign);
                row13.createCell(4).setCellStyle(cellStyleLeftAlign);
                row13.createCell(5).setCellStyle(cellStyleLeftAlign);
                row13.createCell(6).setCellStyle(cellStyleLeftAlign);
                row13.createCell(7).setCellStyle(cellStyleLeftAlign);
                row13.createCell(8).setCellStyle(cellStyleLeftAlign);
                row13.createCell(9).setCellStyle(cellStyleLeftAlign);
                row13.createCell(10).setCellStyle(cellStyleLeftAlign);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 10));
                ++num;
                row13.setHeight((short)400);
            }
            HSSFWorkbook workbookPhotos = new HSSFWorkbook();
            HSSFSheet sheetPhotos = workbookPhotos.createSheet("\u6d3e\u5355\u3001\u9a8c\u6536\u8ba1\u91cf\u5355\u9644\u4ef6\u8d44\u6599");
            HSSFPatriarch patriarch = sheetPhotos.createDrawingPatriarch();
            HSSFCellStyle cellStylePhotos = workbookPhotos.createCellStyle();
            HSSFCellStyle cellStylePhotoT = workbookPhotos.createCellStyle();
            HSSFCellStyle cellStyleTitlePhotos = workbookPhotos.createCellStyle();
            HSSFCellStyle cellStyleTitlePhotosNoLine = workbookPhotos.createCellStyle();
            sheetPhotos.setColumnWidth(0, 5120);
            sheetPhotos.setColumnWidth(1, 5632);
            sheetPhotos.setColumnWidth(2, 5120);
            sheetPhotos.setColumnWidth(3, 5632);
            PoiStyleUtil.setExcelStylePhotos(cellStylePhotos, workbookPhotos);
            PoiStyleUtil.setExcelStyle(cellStylePhotoT, workbookPhotos);
            PoiStyleUtil.setExcelStylePhotos(cellStyleTitlePhotos, workbookPhotos);
            PoiStyleUtil.setExcelStylePhotosOnLine(cellStyleTitlePhotosNoLine, workbookPhotos);
            sheetPhotos.getPrintSetup().setPaperSize((short)9);
            HSSFRow row20 = sheetPhotos.createRow(0);
            HSSFCell cell66 = row20.createCell(0);
            cell66.setCellValue(road.getCode() + road.getName() + "\u516c\u8def\u65e5\u5e38\u517b\u62a4\u5de5\u7a0b");
            cell66.setCellStyle(cellStyleTitlePhotosNoLine);
            row20.createCell(1).setCellStyle(cellStyleTitlePhotosNoLine);
            row20.createCell(2).setCellStyle(cellStyleTitlePhotosNoLine);
            row20.createCell(3).setCellStyle(cellStyleTitlePhotosNoLine);
            HSSFRow row15 = sheetPhotos.createRow(1);
            HSSFCell cell51 = row15.createCell(0);
            cell51.setCellValue("\u6d3e\u5de5/\u9a8c\u6536\u8ba1\u91cf\u8d44\u6599");
            cell51.setCellStyle(cellStyleTitlePhotosNoLine);
            row15.createCell(1).setCellStyle(cellStyleTitlePhotosNoLine);
            row15.createCell(2).setCellStyle(cellStyleTitlePhotosNoLine);
            row15.createCell(3).setCellStyle(cellStyleTitlePhotosNoLine);
            HSSFRow row16 = sheetPhotos.createRow(2);
            HSSFCell cell52 = row16.createCell(0);
            cell52.setCellValue("\u6d3e\u5de5\u65b9");
            cell52.setCellStyle(cellStylePhotos);
            HSSFCell cell53 = row16.createCell(1);
            cell53.setCellValue(contract.getFirstParty());
            cell53.setCellStyle(cellStylePhotoT);
            HSSFCell cell54 = row16.createCell(2);
            cell54.setCellValue("\u627f\u5305\u65b9");
            cell54.setCellStyle(cellStylePhotos);
            HSSFCell cell55 = row16.createCell(3);
            cell55.setCellStyle(cellStylePhotoT);
            cell55.setCellValue(contract.getSecondParty());
            HSSFRow row17 = sheetPhotos.createRow(3);
            HSSFCell cell49 = row17.createCell(0);
            cell49.setCellValue("\u65bd\u5de5\u6869\u53f7\u4f4d\u7f6e");
            cell49.setCellStyle(cellStylePhotoT);
            HSSFCell cell65 = row17.createCell(1);
            cell65.setCellValue(workOrderInformation.getPosition());
            cell65.setCellStyle(cellStylePhotoT);
            HSSFCell cell1 = row17.createCell(2);
            cell1.setCellStyle(cellStylePhotos);
            cell1.setCellValue("\u6d3e  \u5de5  \u7f16  \u53f7");
            HSSFCell cell2 = row17.createCell(3);
            cell2.setCellStyle(cellStylePhotoT);
            cell2.setCellValue(workOrderInformation.getJobNumber());
            HSSFRow row18 = sheetPhotos.createRow(4);
            HSSFCell cell50 = row18.createCell(0);
            cell50.setCellValue("\u5de5\u4f5c\u6982\u51b5");
            cell50.setCellStyle(cellStylePhotos);
            HSSFCell cell64 = row18.createCell(1);
            cell64.setCellValue(workOrderInformation.getRemarks());
            cell64.setCellStyle(cellStylePhotos);
            row18.createCell(2).setCellStyle(cellStylePhotos);
            row18.createCell(3).setCellStyle(cellStylePhotos);
            HSSFRow row19 = sheetPhotos.createRow(5);
            HSSFCell cell60 = row19.createCell(0);
            cell60.setCellValue("\u65bd\u5de5\u524d\u7167\u7247");
            cell60.setCellStyle(cellStylePhotos);
            HSSFCell cell63 = row19.createCell(2);
            row19.createCell(1).setCellStyle(cellStylePhotos);
            cell63.setCellValue("\u62cd\u6444\u65f6\u95f4");
            cell63.setCellStyle(cellStylePhotos);
            sheetPhotos.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
            sheetPhotos.addMergedRegion(new CellRangeAddress(1, 1, 0, 3));
            sheetPhotos.addMergedRegion(new CellRangeAddress(4, 4, 1, 3));
            sheetPhotos.addMergedRegion(new CellRangeAddress(5, 5, 0, 1));
            row15.setHeight((short)400);
            row16.setHeight((short)640);
            row17.setHeight((short)400);
            row18.setHeight((short)1280);
            row19.setHeight((short)400);
            row20.setHeight((short)400);
            HSSFCell cell = row19.createCell(3);
            cell.setCellStyle(cellStylePhotos);
            HSSFRow rowPhoto24 = sheetPhotos.createRow(6);
            rowPhoto24.setHeight((short)3000);
            if (accessoriesPre.size() > 0) {
                cell.setCellValue(accessoriesPre.get(0).getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                for (int i = 0; i < accessoriesPre.size(); ++i) {
                    int j;
                    InputStream fileStream = MinioUtil.getMinioFile((String)"yhxt", (String)accessoriesPre.get(i).getUrl(), (boolean)false);
                    if (fileStream == null) continue;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    int len = 1024;
                    byte[] tmp = new byte[len];
                    while ((j = fileStream.read(tmp, 0, len)) > 0) {
                        output.write(tmp, 0, j);
                    }
                    if (i == 0) {
                        HSSFClientAnchor anchor = new HSSFClientAnchor(66, 10, 1000, 0, 0, 6, 1, 6);
                        HSSFPicture picture = patriarch.createPicture(anchor, workbookPhotos.addPicture(output.toByteArray(), 5));
                        picture.resize(1.0, 1.0);
                    }
                    if (i == 1) {
                        HSSFClientAnchor anchor2 = new HSSFClientAnchor(66, 10, 1000, 0, 2, 6, 3, 6);
                        patriarch.createPicture(anchor2, workbookPhotos.addPicture(output.toByteArray(), 5)).resize(1.0, 1.0);
                    }
                    if (i == 1) break;
                }
                rowPhoto24.createCell(0).setCellStyle(cellStyleTitlePhotos);
                rowPhoto24.createCell(1).setCellStyle(cellStyleTitlePhotos);
                rowPhoto24.createCell(2).setCellStyle(cellStyleTitlePhotos);
                rowPhoto24.createCell(3).setCellStyle(cellStyleTitlePhotos);
            }
            sheetPhotos.addMergedRegion(new CellRangeAddress(6, 6, 0, 1));
            sheetPhotos.addMergedRegion(new CellRangeAddress(6, 6, 2, 3));
            HSSFRow rowPhoto6 = sheetPhotos.createRow(7);
            HSSFCell cell58 = rowPhoto6.createCell(0);
            cell58.setCellValue("\u65bd\u5de5\u4e2d\u7167\u7247");
            cell58.setCellStyle(cellStylePhotos);
            rowPhoto6.createCell(1).setCellStyle(cellStylePhotos);
            HSSFCell cell59 = rowPhoto6.createCell(2);
            cell59.setCellValue("\u62cd\u6444\u65f6\u95f4");
            cell59.setCellStyle(cellStylePhotos);
            cell59.setCellStyle(cellStylePhotos);
            HSSFCell cell61 = rowPhoto6.createCell(3);
            cell61.setCellStyle(cellStylePhotos);
            HSSFRow rowPhoto23 = sheetPhotos.createRow(8);
            rowPhoto23.setHeight((short)3000);
            sheetPhotos.addMergedRegion(new CellRangeAddress(7, 7, 0, 1));
            if (accessoriesUnd.size() > 0) {
                cell61.setCellValue(accessoriesUnd.get(0).getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                for (int i = 0; i < accessoriesUnd.size(); ++i) {
                    int j;
                    InputStream fileStream = MinioUtil.getMinioFile((String)"yhxt", (String)accessoriesUnd.get(i).getUrl(), (boolean)false);
                    if (fileStream == null) continue;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    int len = 1024;
                    byte[] tmp = new byte[len];
                    while ((j = fileStream.read(tmp, 0, len)) > 0) {
                        output.write(tmp, 0, j);
                    }
                    if (i == 0) {
                        HSSFClientAnchor anchor = new HSSFClientAnchor(66, 10, 1000, 0, 0, 8, 1, 8);
                        patriarch.createPicture(anchor, workbookPhotos.addPicture(output.toByteArray(), 5)).resize(1.0, 1.0);
                    }
                    if (i == 1) {
                        HSSFClientAnchor anchor2 = new HSSFClientAnchor(66, 10, 1000, 0, 2, 8, 3, 8);
                        patriarch.createPicture(anchor2, workbookPhotos.addPicture(output.toByteArray(), 5)).resize(1.0, 1.0);
                    }
                    if (i == 1) break;
                }
                rowPhoto23.createCell(0).setCellStyle(cellStyleTitlePhotos);
                rowPhoto23.createCell(1).setCellStyle(cellStyleTitlePhotos);
                rowPhoto23.createCell(2).setCellStyle(cellStyleTitlePhotos);
                rowPhoto23.createCell(3).setCellStyle(cellStyleTitlePhotos);
            }
            sheetPhotos.addMergedRegion(new CellRangeAddress(8, 8, 0, 1));
            sheetPhotos.addMergedRegion(new CellRangeAddress(8, 8, 2, 3));
            HSSFRow rowPhoto4 = sheetPhotos.createRow(9);
            HSSFCell cell56 = rowPhoto4.createCell(0);
            cell56.setCellValue("\u65bd\u5de5\u540e\u7167\u7247");
            cell56.setCellStyle(cellStylePhotos);
            rowPhoto4.createCell(1).setCellStyle(cellStylePhotos);
            HSSFCell cell57 = rowPhoto4.createCell(2);
            cell57.setCellValue("\u62cd\u6444\u65f6\u95f4");
            cell57.setCellStyle(cellStylePhotos);
            HSSFCell cell62 = rowPhoto4.createCell(3);
            cell62.setCellStyle(cellStylePhotos);
            sheetPhotos.addMergedRegion(new CellRangeAddress(9, 9, 0, 1));
            HSSFRow rowPhoto22 = sheetPhotos.createRow(10);
            rowPhoto22.setHeight((short)3000);
            if (accessoriesSuf.size() > 0) {
                cell62.setCellValue(accessoriesSuf.get(0).getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                for (int i = 0; i < accessoriesSuf.size(); ++i) {
                    int j;
                    InputStream fileStream = MinioUtil.getMinioFile((String)"yhxt", (String)accessoriesSuf.get(i).getUrl(), (boolean)false);
                    if (fileStream == null) continue;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    int len = 1024;
                    byte[] tmp = new byte[len];
                    while ((j = fileStream.read(tmp, 0, len)) > 0) {
                        output.write(tmp, 0, j);
                    }
                    if (i == 0) {
                        HSSFClientAnchor anchor = new HSSFClientAnchor(66, 10, 1000, 0, 0, 10, 1, 10);
                        patriarch.createPicture(anchor, workbookPhotos.addPicture(output.toByteArray(), 5)).resize(1.0, 1.0);
                    }
                    if (i == 1) {
                        HSSFClientAnchor anchor2 = new HSSFClientAnchor(66, 10, 1000, 0, 2, 10, 3, 10);
                        patriarch.createPicture(anchor2, workbookPhotos.addPicture(output.toByteArray(), 5)).resize(1.0, 1.0);
                    }
                    if (i == 1) break;
                }
                rowPhoto22.createCell(0).setCellStyle(cellStyleTitlePhotos);
                rowPhoto22.createCell(1).setCellStyle(cellStyleTitlePhotos);
                rowPhoto22.createCell(2).setCellStyle(cellStyleTitlePhotos);
                rowPhoto22.createCell(3).setCellStyle(cellStyleTitlePhotos);
            }
            sheetPhotos.addMergedRegion(new CellRangeAddress(10, 10, 0, 1));
            sheetPhotos.addMergedRegion(new CellRangeAddress(10, 10, 2, 3));
            HSSFRow row21 = sheetPhotos.createRow(11);
            HSSFCell cell67 = row21.createCell(0);
            cell67.setCellValue("\u627f\u5305\u65b9\u7ecf\u529e\u4eba");
            HSSFCell cell68 = row21.createCell(2);
            HSSFCell cell69 = row21.createCell(1);
            HSSFCell cell70 = row21.createCell(3);
            cell68.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
            cell67.setCellStyle(cellStylePhotos);
            cell69.setCellStyle(cellStylePhotos);
            cell69.setCellValue(workOrderInformation.getAssignedPersonnel());
            cell70.setCellValue(workOrderInformation.getIssuer());
            cell68.setCellStyle(cellStylePhotos);
            cell70.setCellStyle(cellStylePhotos);
            row21.setHeight((short)400);
            try {
                os = new FileOutputStream(file + "/" + workOrderInformation.getJobNumber() + "-Photo" + ".xls");
                workbookPhotos.write((OutputStream)os);
                os.flush();
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
            }
            try {
                os = new FileOutputStream(file + "/" + workOrderInformation.getJobNumber() + ".xls");
                workbook.write((OutputStream)os);
                os.flush();
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
            }
        }
        PoiStyleUtil.zip(fileName, true);
        String zip = fileName + ".zip";
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
        FileUtil.deleteFile((String)zip);
    }

    @Override
    public void exportWorkOrdersConstruction(String startTime, String endTime, String contractId, String type, HttpServletResponse response) throws Exception {
        if (StringUtils.isEmpty((CharSequence)contractId)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5408\u540c");
        }
        long time = System.currentTimeMillis();
        String fileName = "\u5de5\u5355\u4fe1\u606f" + time;
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        Contract contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)contractId)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ge((Object)"END_TIME_", (Object)startTime);
        queryWrapper.le((Object)"END_TIME_", (Object)endTime);
        queryWrapper.eq((Object)"CONTRACT_ID_", (Object)contract.getId());
        queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)contract.getRoadSegmentId());
        List workOrderInformationList = ((WorkOrderInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (null == workOrderInformationList || workOrderInformationList.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5de5\u5355\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6761\u4ef6");
        }
        queryWrapper.clear();
        List orderIds = workOrderInformationList.stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
        QueryFilter filter = QueryFilter.build();
        PageBean pageBean = new PageBean();
        pageBean.setPage(1);
        pageBean.setPageSize(-1);
        filter.setPageBean(pageBean);
        filter.addFilter("wfInst.biz_key_", orderIds, QueryOP.IN, FieldRelation.AND);
        filter.addFilter("type_id_", (Object)"1425741173624016896", QueryOP.IN, FieldRelation.AND);
        PageList mapPageList = (PageList)this.iFlowManager.getDoneInstList(this.baseContext.getCurrentUserAccout(), filter, null).get();
        List rows = mapPageList.getRows();
        ArrayList<String> ids = new ArrayList<String>();
        if (rows.size() > 0) {
            for (Map row : rows) {
                Object bizKey;
                Object procDefKey = row.get("procDefKey");
                if (!procDefKey.toString().equals("yhgd") || !ObjectUtils.isNotEmpty(bizKey = row.get("bizKey"))) continue;
                ids.add(bizKey.toString());
            }
        }
        if (null == ids || ids.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5de5\u5355\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6761\u4ef6");
        }
        List workOrderInformations = ((WorkOrderInformationDao)this.baseMapper).selectBatchIds(ids);
        if (null == workOrderInformations || workOrderInformations.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5de5\u5355\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6761\u4ef6");
        }
        Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)contract.getRoadSegmentId())));
        HSSFWorkbook workbook = this.getExportSheets(endTime, contract, workOrderInformations, road);
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + road.getName() + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868" + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        PoiStyleUtil.zip(fileName, true);
        String zip = fileName + ".zip";
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
        FileUtil.deleteFile((String)zip);
    }

    private HSSFWorkbook getExportSheets(String endTime, Contract contract, List<WorkOrderInformation> workOrderInformations, Road road) throws ParseException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFCellStyle cellStyleOne = workbook.createCellStyle();
        HSSFCellStyle cellStyleTwo = workbook.createCellStyle();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyleNoLine = workbook.createCellStyle();
        HSSFCellStyle cellStyleTitleNoLine = workbook.createCellStyle();
        HSSFCellStyle cellStyleTitleNoLineSmall = workbook.createCellStyle();
        PoiStyleUtil.setExcelStyle(cellStyle, workbook);
        PoiStyleUtil.setExcelStyleOne(cellStyleOne, workbook);
        PoiStyleUtil.setExcelStyleTwo(cellStyleTwo, workbook);
        PoiStyleUtil.setExcelStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setExcelStyleTitleNoLine(cellStyleTitleNoLine, workbook);
        PoiStyleUtil.cellStyleTitleNoLineSmall(cellStyleTitleNoLineSmall, workbook);
        PoiStyleUtil.setExcelStyleNoLine(cellStyleNoLine, workbook);
        HSSFSheet sheet = workbook.createSheet("\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        sheet.setColumnWidth(0, 6400);
        sheet.setColumnWidth(1, 6400);
        sheet.setColumnWidth(2, 3840);
        sheet.setColumnWidth(3, 2560);
        sheet.setColumnWidth(4, 2560);
        sheet.setColumnWidth(5, 3840);
        sheet.setColumnWidth(6, 2560);
        sheet.setColumnWidth(7, 3840);
        ArrayList billOfQuantitiesVos = new ArrayList();
        for (WorkOrderInformation workOrderInformation : workOrderInformations) {
            WorkOrderInformationVo vo = this.getVo(workOrderInformation.getId());
            List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();
            List<BillOfQuantities> billOutOfQuantities = vo.getBillOutOfQuantities();
            billOfQuantities.forEach(s -> {
                BillOfQuantitiesVo bill = new BillOfQuantitiesVo();
                BillOfQuantitiesVo billOfQuantitiesVo = bill.getVo((BillOfQuantities)((Object)s));
                billOfQuantitiesVo.setJobNumber(workOrderInformation.getJobNumber());
                billOfQuantitiesVo.setPosition(workOrderInformation.getPosition());
                billOfQuantitiesVos.add(billOfQuantitiesVo);
            });
            billOutOfQuantities.forEach(s -> {
                BillOfQuantitiesVo bill = new BillOfQuantitiesVo();
                BillOfQuantitiesVo billOfQuantitiesVo = bill.getVo((BillOfQuantities)((Object)s));
                billOfQuantitiesVo.setJobNumber(workOrderInformation.getJobNumber());
                billOfQuantitiesVo.setPosition(workOrderInformation.getPosition());
                billOfQuantitiesVos.add(billOfQuantitiesVo);
            });
        }
        List billOfQuantitiesVoList = billOfQuantitiesVos.stream().sorted(Comparator.comparing(BillOfQuantitiesVo::getJobNumber)).collect(Collectors.toList());
        List collect = ((Stream)Stream.iterate(0, f -> f + 1).limit((billOfQuantitiesVoList.size() + 13) / 14).parallel()).map(a -> ((Stream)billOfQuantitiesVoList.stream().skip(a * 14).limit(14L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        int num = 0;
        if (collect.size() > 0) {
            for (List vos : collect) {
                HSSFRow row = sheet.createRow(num);
                HSSFCell cell = row.createCell(0);
                cell.setCellValue(road.getName() + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868");
                cell.setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(1).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(2).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(3).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(4).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(5).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(6).setCellStyle(cellStyleTitleNoLineSmall);
                row.createCell(7).setCellStyle(cellStyleTitleNoLineSmall);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 7));
                HSSFRow row1 = sheet.createRow(++num);
                HSSFCell cell1 = row1.createCell(0);
                String yearWork = endTime.split("-")[0];
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(endTime);
                cell1.setCellStyle(cellStyleTitleNoLine);
                row1.createCell(1).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(2).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(3).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(4).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(5).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(6).setCellStyle(cellStyleTitleNoLine);
                row1.createCell(7).setCellStyle(cellStyleTitleNoLine);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 7));
                int season = this.getSeason(date);
                String quarter = "";
                switch (season) {
                    case 1: {
                        quarter = "\u4e00";
                        break;
                    }
                    case 2: {
                        quarter = "\u4e8c";
                        break;
                    }
                    case 3: {
                        quarter = "\u4e09";
                        break;
                    }
                    case 4: {
                        quarter = "\u56db";
                        break;
                    }
                    default: {
                        quarter = "\u4e00";
                    }
                }
                cell1.setCellValue(yearWork + "\u5e74\u7b2c" + quarter + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868");
                ++num;
                HSSFRow row2 = sheet.createRow(2);
                HSSFCell cell2 = row2.createCell(0);
                cell2.setCellValue("\u6d3e    \u5de5   \u65b9\uff1a");
                cell2.setCellStyle(cellStyleNoLine);
                HSSFCell cell3 = row2.createCell(1);
                cell3.setCellValue(contract.getFirstParty());
                cell3.setCellStyle(cellStyleNoLine);
                row2.createCell(2).setCellStyle(cellStyleNoLine);
                HSSFCell cell4 = row2.createCell(3);
                cell4.setCellValue("\u627f      \u5305     \u65b9\uff1a");
                cell4.setCellStyle(cellStyleNoLine);
                HSSFCell cell5 = row2.createCell(5);
                cell5.setCellValue(contract.getSecondParty());
                cell5.setCellStyle(cellStyleNoLine);
                row2.createCell(4).setCellStyle(cellStyleNoLine);
                row2.createCell(6).setCellStyle(cellStyleNoLine);
                row2.createCell(7).setCellStyle(cellStyleNoLine);
                sheet.addMergedRegion(new CellRangeAddress(num, num, 5, 7));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 3, 4));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 1, 2));
                HSSFRow row3 = sheet.createRow(++num);
                HSSFCell cell6 = row3.createCell(0);
                cell6.setCellValue("\u5408   \u540c   \u540d   \u79f0\uff1a");
                cell6.setCellStyle(cellStyleNoLine);
                HSSFCell cell7 = row3.createCell(1);
                cell7.setCellValue(contract.getName());
                cell7.setCellStyle(cellStyleNoLine);
                row3.createCell(2).setCellStyle(cellStyleNoLine);
                HSSFCell cell8 = row3.createCell(3);
                cell8.setCellValue("\u5408   \u540c   \u7f16   \u53f7\uff1a");
                cell8.setCellStyle(cellStyleNoLine);
                HSSFCell cell9 = row3.createCell(5);
                cell9.setCellStyle(cellStyleNoLine);
                row3.createCell(4).setCellStyle(cellStyleNoLine);
                row3.createCell(6).setCellStyle(cellStyleNoLine);
                row3.createCell(7).setCellStyle(cellStyleNoLine);
                cell9.setCellValue(contract.getUniqueNumber());
                sheet.addMergedRegion(new CellRangeAddress(num, num, 5, 7));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 3, 4));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 1, 2));
                HSSFRow row4 = sheet.createRow(++num);
                HSSFCell cell10 = row4.createCell(0);
                HSSFCell cell11 = row4.createCell(1);
                HSSFCell cell12 = row4.createCell(2);
                HSSFCell cell13 = row4.createCell(3);
                HSSFCell cell14 = row4.createCell(4);
                HSSFCell cell15 = row4.createCell(5);
                HSSFCell cell16 = row4.createCell(6);
                HSSFCell cell17 = row4.createCell(7);
                cell10.setCellStyle(cellStyle);
                cell11.setCellStyle(cellStyle);
                cell12.setCellStyle(cellStyle);
                cell13.setCellStyle(cellStyle);
                cell14.setCellStyle(cellStyle);
                cell15.setCellStyle(cellStyle);
                cell16.setCellStyle(cellStyle);
                cell17.setCellStyle(cellStyle);
                cell10.setCellValue("\u6d3e\u5de5\u7f16\u53f7");
                cell11.setCellValue("\u5de5\u4f5c\u9879");
                cell12.setCellValue("\u6869\u53f7");
                cell13.setCellValue("\u5355\u4f4d");
                cell14.setCellValue("\u6570\u91cf");
                cell15.setCellValue("\u5355\u4ef7");
                cell16.setCellValue("\u5408\u4ef7");
                cell17.setCellValue("\u5907\u6ce8");
                row.setHeight((short)300);
                row1.setHeight((short)400);
                row2.setHeight((short)640);
                row3.setHeight((short)640);
                row4.setHeight((short)300);
                ++num;
                Map<String, List<BillOfQuantitiesVo>> listMap = vos.stream().collect(Collectors.groupingBy(BillOfQuantitiesVo::getJobNumber));
                for (Map.Entry<String, List<BillOfQuantitiesVo>> entry : listMap.entrySet()) {
                    List<BillOfQuantitiesVo> value = entry.getValue();
                    int itemNumber = num;
                    System.out.println(itemNumber);
                    for (BillOfQuantitiesVo billOfQuantitiesVo : value) {
                        HSSFRow row5 = sheet.createRow(num);
                        HSSFCell cell18 = row5.createCell(0);
                        HSSFCell cell19 = row5.createCell(1);
                        HSSFCell cell20 = row5.createCell(2);
                        HSSFCell cell21 = row5.createCell(3);
                        HSSFCell cell22 = row5.createCell(4);
                        HSSFCell cell23 = row5.createCell(5);
                        HSSFCell cell24 = row5.createCell(6);
                        HSSFCell cell25 = row5.createCell(7);
                        cell18.setCellStyle(cellStyle);
                        cell19.setCellStyle(cellStyle);
                        cell20.setCellStyle(cellStyle);
                        cell21.setCellStyle(cellStyle);
                        cell22.setCellStyle(cellStyle);
                        cell23.setCellStyle(cellStyle);
                        cell24.setCellStyle(cellStyle);
                        cell25.setCellStyle(cellStyle);
                        cell18.setCellValue(billOfQuantitiesVo.getJobNumber());
                        if (billOfQuantitiesVo.getSonSubjectName() != null) {
                            cell19.setCellValue(billOfQuantitiesVo.getFineSubjectName() + "\u3001" + billOfQuantitiesVo.getSonSubjectName());
                        } else {
                            cell19.setCellValue(billOfQuantitiesVo.getFineSubjectName());
                        }
                        if (billOfQuantitiesVo.getPosition() != null) {
                            cell20.setCellValue(billOfQuantitiesVo.getPosition());
                        }
                        if (billOfQuantitiesVo.getSpec() != null) {
                            cell21.setCellValue(billOfQuantitiesVo.getSpec());
                        }
                        if (billOfQuantitiesVo.getAuditAmount() != null) {
                            cell22.setCellValue((double)billOfQuantitiesVo.getAuditAmount().floatValue());
                        }
                        if (billOfQuantitiesVo.getAuditPrice() != null) {
                            cell23.setCellValue((double)billOfQuantitiesVo.getAuditPrice().floatValue());
                        }
                        if (billOfQuantitiesVo.getAuditMoney() != null) {
                            cell24.setCellValue((double)billOfQuantitiesVo.getAuditMoney().floatValue());
                        }
                        cell25.setCellValue("");
                        row5.setHeight((short)380);
                        ++num;
                    }
                    if (num - itemNumber <= 1) continue;
                    sheet.addMergedRegion(new CellRangeAddress(itemNumber, num - 1, 0, 0));
                    sheet.addMergedRegion(new CellRangeAddress(itemNumber, num - 1, 2, 2));
                    sheet.addMergedRegion(new CellRangeAddress(itemNumber, num - 1, 7, 7));
                }
                if (vos.size() < 14) {
                    for (int i = 0; i < 14 - vos.size(); ++i) {
                        HSSFRow row5 = sheet.createRow(num);
                        HSSFCell cell18 = row5.createCell(0);
                        HSSFCell cell19 = row5.createCell(1);
                        HSSFCell cell20 = row5.createCell(2);
                        HSSFCell cell21 = row5.createCell(3);
                        HSSFCell cell22 = row5.createCell(4);
                        HSSFCell cell23 = row5.createCell(5);
                        HSSFCell cell24 = row5.createCell(6);
                        HSSFCell cell25 = row5.createCell(7);
                        cell18.setCellStyle(cellStyle);
                        cell19.setCellStyle(cellStyle);
                        cell20.setCellStyle(cellStyle);
                        cell21.setCellStyle(cellStyle);
                        cell22.setCellStyle(cellStyle);
                        cell23.setCellStyle(cellStyle);
                        cell24.setCellStyle(cellStyle);
                        cell25.setCellStyle(cellStyle);
                        row5.setHeight((short)380);
                        ++num;
                    }
                }
                HSSFRow row9 = sheet.createRow(num);
                HSSFCell cell18 = row9.createCell(0);
                cell18.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
                HSSFCell cell19 = row9.createCell(1);
                HSSFCell cell20 = row9.createCell(2);
                cell20.setCellValue("\u65e5\u671f");
                HSSFCell cell21 = row9.createCell(3);
                HSSFCell cell22 = row9.createCell(4);
                cell22.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
                HSSFCell cell23 = row9.createCell(5);
                HSSFCell cell24 = row9.createCell(6);
                HSSFCell cell25 = row9.createCell(7);
                cell24.setCellValue("\u65e5\u671f");
                HSSFRow row10 = sheet.createRow(++num);
                HSSFCell cell27 = row10.createCell(0);
                cell27.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba");
                HSSFCell cell28 = row10.createCell(1);
                HSSFCell cell29 = row10.createCell(2);
                cell29.setCellValue("\u65e5\u671f");
                HSSFCell cell30 = row10.createCell(3);
                HSSFCell cell31 = row10.createCell(4);
                cell31.setCellValue("\u517b\u62a4\u90e8\u5ba1\u6838\u4eba");
                HSSFCell cell32 = row10.createCell(5);
                HSSFCell cell33 = row10.createCell(6);
                HSSFCell cell34 = row10.createCell(7);
                cell33.setCellValue("\u65e5\u671f");
                ++num;
                row9.setHeight((short)640);
                row10.setHeight((short)640);
            }
        } else {
            HSSFRow row = sheet.createRow(num);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(road.getName() + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868");
            cell.setCellStyle(cellStyleTitleNoLine);
            row.createCell(1).setCellStyle(cellStyleTitleNoLine);
            row.createCell(2).setCellStyle(cellStyleTitleNoLine);
            row.createCell(3).setCellStyle(cellStyleTitleNoLine);
            row.createCell(4).setCellStyle(cellStyleTitleNoLine);
            row.createCell(5).setCellStyle(cellStyleTitleNoLine);
            row.createCell(6).setCellStyle(cellStyleTitleNoLine);
            row.createCell(7).setCellStyle(cellStyleTitleNoLine);
            sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 7));
            HSSFRow row1 = sheet.createRow(++num);
            HSSFCell cell1 = row1.createCell(0);
            String yearWork = endTime.split("-")[0];
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(endTime);
            cell1.setCellStyle(cellStyleTitleNoLine);
            row1.createCell(1).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(2).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(3).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(4).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(5).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(6).setCellStyle(cellStyleTitleNoLine);
            row1.createCell(7).setCellStyle(cellStyleTitleNoLine);
            sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 7));
            int season = this.getSeason(date);
            String quarter = "";
            switch (season) {
                case 1: {
                    quarter = "\u4e00";
                    break;
                }
                case 2: {
                    quarter = "\u4e8c";
                    break;
                }
                case 3: {
                    quarter = "\u4e09";
                    break;
                }
                case 4: {
                    quarter = "\u56db";
                    break;
                }
                default: {
                    quarter = "\u4e00";
                }
            }
            cell1.setCellValue(yearWork + "\u5e74\u7b2c" + quarter + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868");
            ++num;
            HSSFRow row2 = sheet.createRow(2);
            HSSFCell cell2 = row2.createCell(0);
            cell2.setCellValue("\u6d3e    \u5de5   \u65b9\uff1a");
            cell2.setCellStyle(cellStyleNoLine);
            HSSFCell cell3 = row2.createCell(1);
            cell3.setCellValue(contract.getFirstParty());
            cell3.setCellStyle(cellStyleNoLine);
            row2.createCell(2).setCellStyle(cellStyleNoLine);
            HSSFCell cell4 = row2.createCell(3);
            cell4.setCellValue("\u627f      \u5305     \u65b9\uff1a");
            cell4.setCellStyle(cellStyleNoLine);
            HSSFCell cell5 = row2.createCell(5);
            cell5.setCellValue(contract.getSecondParty());
            cell5.setCellStyle(cellStyleNoLine);
            row2.createCell(4).setCellStyle(cellStyleNoLine);
            row2.createCell(6).setCellStyle(cellStyleNoLine);
            row2.createCell(7).setCellStyle(cellStyleNoLine);
            sheet.addMergedRegion(new CellRangeAddress(num, num, 5, 7));
            sheet.addMergedRegion(new CellRangeAddress(num, num, 3, 4));
            sheet.addMergedRegion(new CellRangeAddress(num, num, 1, 2));
            HSSFRow row3 = sheet.createRow(++num);
            HSSFCell cell6 = row3.createCell(0);
            cell6.setCellValue("\u5408   \u540c   \u540d   \u79f0\uff1a");
            cell6.setCellStyle(cellStyleNoLine);
            HSSFCell cell7 = row3.createCell(1);
            cell7.setCellValue(contract.getName());
            cell7.setCellStyle(cellStyleNoLine);
            row3.createCell(2).setCellStyle(cellStyleNoLine);
            HSSFCell cell8 = row3.createCell(3);
            cell8.setCellValue("\u5408   \u540c   \u7f16   \u53f7\uff1a");
            cell8.setCellStyle(cellStyleNoLine);
            HSSFCell cell9 = row3.createCell(5);
            cell9.setCellStyle(cellStyleNoLine);
            row3.createCell(4).setCellStyle(cellStyleNoLine);
            row3.createCell(6).setCellStyle(cellStyleNoLine);
            row3.createCell(7).setCellStyle(cellStyleNoLine);
            cell9.setCellValue(contract.getUniqueNumber());
            sheet.addMergedRegion(new CellRangeAddress(num, num, 5, 7));
            sheet.addMergedRegion(new CellRangeAddress(num, num, 3, 4));
            sheet.addMergedRegion(new CellRangeAddress(num, num, 1, 2));
            HSSFRow row4 = sheet.createRow(++num);
            HSSFCell cell10 = row4.createCell(0);
            HSSFCell cell11 = row4.createCell(1);
            HSSFCell cell12 = row4.createCell(2);
            HSSFCell cell13 = row4.createCell(3);
            HSSFCell cell14 = row4.createCell(4);
            HSSFCell cell15 = row4.createCell(5);
            HSSFCell cell16 = row4.createCell(6);
            HSSFCell cell17 = row4.createCell(7);
            cell10.setCellStyle(cellStyle);
            cell11.setCellStyle(cellStyle);
            cell12.setCellStyle(cellStyle);
            cell13.setCellStyle(cellStyle);
            cell14.setCellStyle(cellStyle);
            cell15.setCellStyle(cellStyle);
            cell16.setCellStyle(cellStyle);
            cell17.setCellStyle(cellStyle);
            cell10.setCellValue("\u6d3e\u5de5\u7f16\u53f7");
            cell11.setCellValue("\u5de5\u4f5c\u9879");
            cell12.setCellValue("\u6869\u53f7");
            cell13.setCellValue("\u5355\u4f4d");
            cell14.setCellValue("\u6570\u91cf");
            cell15.setCellValue("\u5355\u4ef7");
            cell16.setCellValue("\u5408\u4ef7");
            cell17.setCellValue("\u5907\u6ce8");
            row.setHeight((short)300);
            row1.setHeight((short)400);
            row2.setHeight((short)640);
            row3.setHeight((short)640);
            row4.setHeight((short)300);
            ++num;
            for (int i = 0; i < 14; ++i) {
                HSSFRow row5 = sheet.createRow(num);
                HSSFCell cell18 = row5.createCell(0);
                HSSFCell cell19 = row5.createCell(1);
                HSSFCell cell20 = row5.createCell(2);
                HSSFCell cell21 = row5.createCell(3);
                HSSFCell cell22 = row5.createCell(4);
                HSSFCell cell23 = row5.createCell(5);
                HSSFCell cell24 = row5.createCell(6);
                HSSFCell cell25 = row5.createCell(7);
                cell18.setCellStyle(cellStyle);
                cell19.setCellStyle(cellStyle);
                cell20.setCellStyle(cellStyle);
                cell21.setCellStyle(cellStyle);
                cell22.setCellStyle(cellStyle);
                cell23.setCellStyle(cellStyle);
                cell24.setCellStyle(cellStyle);
                cell25.setCellStyle(cellStyle);
                row5.setHeight((short)380);
                ++num;
            }
            HSSFRow row9 = sheet.createRow(num);
            HSSFCell cell18 = row9.createCell(0);
            cell18.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba");
            HSSFCell cell19 = row9.createCell(1);
            HSSFCell cell20 = row9.createCell(2);
            cell20.setCellValue("\u65e5\u671f");
            HSSFCell cell21 = row9.createCell(3);
            HSSFCell cell22 = row9.createCell(4);
            cell22.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u5ba1\u6838\u4eba");
            HSSFCell cell23 = row9.createCell(5);
            HSSFCell cell24 = row9.createCell(6);
            HSSFCell cell25 = row9.createCell(7);
            cell24.setCellValue("\u65e5\u671f");
            HSSFRow row10 = sheet.createRow(++num);
            HSSFCell cell27 = row10.createCell(0);
            cell27.setCellValue("\u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba");
            HSSFCell cell28 = row10.createCell(1);
            HSSFCell cell29 = row10.createCell(2);
            cell29.setCellValue("\u65e5\u671f");
            HSSFCell cell30 = row10.createCell(3);
            HSSFCell cell31 = row10.createCell(4);
            cell31.setCellValue("\u517b\u62a4\u90e8\u5ba1\u6838\u4eba");
            HSSFCell cell32 = row10.createCell(5);
            HSSFCell cell33 = row10.createCell(6);
            HSSFCell cell34 = row10.createCell(7);
            cell33.setCellValue("\u65e5\u671f");
            ++num;
            row9.setHeight((short)640);
            row10.setHeight((short)640);
        }
        return workbook;
    }

    @Override
    public void exportWorkOrders(String startTime, String endTime, String contractId, String type, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((CharSequence)contractId)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5408\u540c");
            }
            long time = System.currentTimeMillis();
            String fileName = "\u5de5\u5355\u4fe1\u606f" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Contract contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)contractId)));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.ge((Object)"END_TIME_", (Object)startTime);
            queryWrapper.le((Object)"END_TIME_", (Object)endTime);
            queryWrapper.eq((Object)"CONTRACT_ID_", (Object)contract.getId());
            queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)contract.getRoadSegmentId());
            List workOrderInformations = ((WorkOrderInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)contract.getRoadSegmentId())));
            HSSFWorkbook workbook = this.getExportSheets(endTime, contract, workOrderInformations, road);
            try {
                FileOutputStream os = new FileOutputStream(file + "/" + road.getName() + "\u5b63\u5ea6\u7ed3\u7b97\u660e\u7ec6\u8868" + ".xls");
                workbook.write((OutputStream)os);
                os.flush();
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            PoiStyleUtil.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @Override
    public List<User> getPrincipal(String userId) {
        String currentOrgId = ContextUtil.getCurrentOrgId((String)userId);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ORG_ID_", (Object)currentOrgId);
        List orgUserList = this.orgUserManager.list((Wrapper)queryWrapper);
        Object[] userIds = (String[])orgUserList.stream().map(OrgUser::getUserId).toArray(String[]::new);
        List<Object> listUser = new ArrayList<User>();
        if (userIds.length > 0) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.in((Object)"ID_", userIds);
            listUser = this.userManager.list((Wrapper)queryWrapper1);
        }
        if (listUser.size() < 0) {
            throw new RuntimeException("\u672a\u627e\u5230\u627f\u5305\u65b9\u8d1f\u8d23\u4eba");
        }
        return listUser;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleWorkOrderInformation(String ids) {
        String userId = this.baseContext.getCurrentUserId();
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new RuntimeException("\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5de5\u5355");
        }
        try {
            List<String> idLList = Arrays.asList(ids.split(","));
            for (String id : idLList) {
                List<DefaultBpmProcessInstance> listBpmProInst = ((WorkOrderInformationDao)this.baseMapper).selectBpmProInst(id);
                if (listBpmProInst.size() > 0) {
                    for (DefaultBpmProcessInstance defaultBpmProcessInstance : listBpmProInst) {
                        User user = ContextUtil.getCurrentUser();
                        boolean admin = user.isAdmin();
                        if (!admin && !userId.equals(defaultBpmProcessInstance.getCreateBy())) {
                            return false;
                        }
                        List<DefaultBpmTask> defaultBpmTaskList = ((WorkOrderInformationDao)this.baseMapper).selectDefaultBpmTask(defaultBpmProcessInstance.getId());
                        for (DefaultBpmTask defaultBpmTask : defaultBpmTaskList) {
                            if (defaultBpmTask == null) continue;
                            if ("UserTask7".equals(defaultBpmTask.getNodeId()) || "UserTask1".equals(defaultBpmTask.getNodeId()) || "UserTask2".equals(defaultBpmTask.getNodeId())) {
                                this.deleteById(id);
                                this.bpmProcessInstanceDao.deleteById((Serializable)((Object)defaultBpmProcessInstance.getId()));
                                this.deleteById(defaultBpmTask.getId());
                                continue;
                            }
                            return false;
                        }
                    }
                    continue;
                }
                this.deleteById(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(String id) {
        WorkOrderInformation workOrderInformation = (WorkOrderInformation)((Object)this.getById((Serializable)((Object)id)));
        if (null != workOrderInformation) {
            workOrderInformation.setIsDele("1");
            workOrderInformation.setUpdateTime(LocalDateTime.now());
            this.update((Model)workOrderInformation);
        }
    }

    @Override
    public List<WorkOrderInformation> listFinishWork(String rodeSegmentId, String first, String last) {
        return ((WorkOrderInformationDao)this.baseMapper).listFinishWork(rodeSegmentId, first, last);
    }

    @Override
    public List<WorkOrderInformation> listWorkAll(String rodeSegmentId, String first, String last) {
        return ((WorkOrderInformationDao)this.baseMapper).listWorkAll(rodeSegmentId, first, last);
    }

    @Override
    public List<WorkOrderInformation> getWorkOrderContract(String contractId, WorkOrderParamVo param) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkOrderInformation::getContractId, (Object)contractId)).ge(param.getStartTime() != null, WorkOrderInformation::getIssueDate, (Object)param.getStartTime())).le(param.getEndTime() != null, WorkOrderInformation::getIssueDate, (Object)param.getEndTime()));
        return list;
    }

    public int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    @Override
    public PageList<OrderCashVo> getOrderCashReport(QueryFilter<YearBudget> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList<YearBudget> pageList = this.yearBudgetManager.queryYearBuget(queryFilter);
        PageList page = new PageList();
        BeanUtils.copyProperties(pageList, (Object)page);
        List rows = pageList.getRows();
        if (null == rows || rows.size() == 0) {
            return page;
        }
        ArrayList<OrderCashVo> cashVos = new ArrayList<OrderCashVo>();
        List<String> pids = StreamUtil.toList(rows, YearBudget::getId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"YEAR_BUDGET_ID_", pids);
        wrapper.eq((Object)"IS_DELE_", (Object)0);
        List detailedList = this.yearBudgetDetailedManager.list((Wrapper)wrapper);
        Map<String, List<YearBudgetDetailed>> detailMap = detailedList.stream().collect(Collectors.groupingBy(YearBudgetDetailed::getYearBudgetId));
        for (YearBudget entity : rows) {
            OrderCashVo orderCashVo = new OrderCashVo();
            orderCashVo.setCompanyName(entity.getCompanyName());
            orderCashVo.setRoadName(entity.getRoadSegmentName());
            orderCashVo.setFundTotal(entity.getBudgetSum());
            orderCashVo.setFundTotalAbort(entity.getAlreadyCount());
            if (entity.getAlreadyCount().compareTo(BigDecimal.ZERO) != 0 && entity.getBudgetSum().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percentageTotal = entity.getAlreadyCount().divide(entity.getBudgetSum(), 2, 5);
                orderCashVo.setPercentageTotal(percentageTotal + "%");
            } else {
                orderCashVo.setPercentageTotal(BigDecimal.ZERO + "%");
            }
            List<YearBudgetDetailed> list = detailMap.get(entity.getId());
            if (null == list || list.isEmpty()) {
                orderCashVo.setFundDaily(BigDecimal.ZERO);
                orderCashVo.setFundSpecial(BigDecimal.ZERO);
            } else {
                BigDecimal fundDailyAbort = new BigDecimal(0);
                BigDecimal fundDaily = new BigDecimal(0);
                BigDecimal fundSpecialAbort = new BigDecimal(0);
                BigDecimal fundSpecial = new BigDecimal(0);
                for (YearBudgetDetailed budgetDetailed : list) {
                    if (null == budgetDetailed.getImageProgress()) {
                        budgetDetailed.setImageProgress(BigDecimal.ZERO);
                    }
                    if (null == budgetDetailed.getTotalPrice()) {
                        budgetDetailed.setTotalPrice(BigDecimal.ZERO);
                    }
                    if ("RCJF".equals(budgetDetailed.getBudgetType())) {
                        fundDailyAbort = fundDailyAbort.add(budgetDetailed.getImageProgress());
                        fundDaily = fundDaily.add(budgetDetailed.getTotalPrice());
                        continue;
                    }
                    fundSpecialAbort = fundDailyAbort.add(budgetDetailed.getImageProgress());
                    fundSpecial = fundDaily.add(budgetDetailed.getTotalPrice());
                }
                orderCashVo.setFundDailyAbort(fundDailyAbort);
                orderCashVo.setFundDaily(fundDaily);
                orderCashVo.setFundSpecialAbort(fundSpecialAbort);
                orderCashVo.setFundSpecial(fundSpecial);
                if (fundDailyAbort.compareTo(BigDecimal.ZERO) != 0 && fundDaily.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal percentageDaily = fundDailyAbort.divide(entity.getBudgetSum(), 2, 5);
                    orderCashVo.setPercentageDaily(percentageDaily + "%");
                } else {
                    orderCashVo.setPercentageDaily(BigDecimal.ZERO + "%");
                }
                if (fundSpecialAbort.compareTo(BigDecimal.ZERO) != 0 && fundSpecial.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal percentageSpecial = fundSpecialAbort.divide(fundSpecial, 2, 5);
                    orderCashVo.setPercentageSpecial(percentageSpecial + "%");
                } else {
                    orderCashVo.setPercentageSpecial(BigDecimal.ZERO + "%");
                }
            }
            cashVos.add(orderCashVo);
        }
        page.setRows(cashVos);
        return page;
    }

    @Override
    public PageList<OrderSpecialCashVo> getOrderSpecialCashReport(QueryFilter<BizEngineeringProject> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizEngineeringProject> pageList = this.bizEngineeringProjectManager.queryBizEngineeringProject(queryFilter);
        PageList page = new PageList();
        BeanUtils.copyProperties(pageList, (Object)page);
        List rows = pageList.getRows();
        if (null == rows || rows.size() == 0) {
            return page;
        }
        ArrayList<OrderSpecialCashVo> cashVos = new ArrayList<OrderSpecialCashVo>();
        List<String> projectIds = StreamUtil.toList(rows, BizEngineeringProject::getId);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"PROJECT_ID_", projectIds);
        queryWrapper.eq((Object)"IS_DELE_", (Object)0);
        List applyForList = this.bizProjectBeginApplyForManager.list((Wrapper)queryWrapper);
        Map<String, List<BizProjectBeginApplyFor>> projectApplyMap = null;
        if (null != applyForList && !applyForList.isEmpty()) {
            projectApplyMap = applyForList.stream().collect(Collectors.groupingBy(BizProjectBeginApplyFor::getProjectId));
        }
        QueryWrapper paymentQueryWrapper = new QueryWrapper();
        paymentQueryWrapper.in((Object)"PROJECT_ID_", projectIds);
        paymentQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        List measurementPayments = this.measurementPaymentManager.list((Wrapper)paymentQueryWrapper);
        Map<String, List<MeasurementPayment>> measurementPaymentMap = null;
        if (null != measurementPayments && !measurementPayments.isEmpty()) {
            measurementPaymentMap = measurementPayments.stream().collect(Collectors.groupingBy(MeasurementPayment::getProjectId));
        }
        for (BizEngineeringProject row : rows) {
            List<BizProjectBeginApplyFor> applys;
            OrderSpecialCashVo cashVo = new OrderSpecialCashVo();
            cashVo.setCompanyName(row.getCompanyName());
            cashVo.setRoadName(row.getRoadSegmentName());
            cashVo.setProjectName(row.getProjectName());
            cashVo.setProjectYear(row.getProjectYear());
            if (null != projectApplyMap && null != (applys = projectApplyMap.get(row.getId())) && !applys.isEmpty()) {
                BizProjectBeginApplyFor applyFor = applys.get(0);
                cashVo.setStartTime(applyFor.getStartupTime().toString());
                if (null != applyFor.getActualCompleteTime()) {
                    cashVo.setDeliverTime(applyFor.getActualCompleteTime().toString());
                } else {
                    cashVo.setDeliverTime(applyFor.getExpectedCompleteTime().toString());
                }
            }
            if (row.getStartupFlag() == 0) {
                cashVo.setStartTime("\u672a\u5f00\u5de5");
                cashVo.setDeliverTime(null);
            }
            if (null != measurementPaymentMap) {
                List<MeasurementPayment> payments = measurementPaymentMap.get(row.getId());
                if (null != payments && payments.size() > 0) {
                    BigDecimal paymentsMoney = payments.stream().filter(e -> null != e.getPaymentCashs()).map(MeasurementPayment::getPaymentCashs).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal projectMoney = row.getProjectMoney();
                    if (paymentsMoney.compareTo(BigDecimal.ZERO) != 0 && null != projectMoney && projectMoney.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal scale = paymentsMoney.divide(projectMoney, 4, 5).multiply(new BigDecimal(100));
                        cashVo.setPercentageMeasurement(scale + "%");
                    } else {
                        cashVo.setPercentageMeasurement("0%");
                    }
                }
            } else {
                cashVo.setPercentageMeasurement("0%");
            }
            cashVo.setConstructUnit(row.getConstructUnit());
            cashVo.setConstructUnitPersonLiable(row.getConstructUnitPersonLiable());
            cashVo.setContractCash(row.getProjectMoney());
            cashVo.setWorkProgress(row.getWorkProgress());
            cashVos.add(cashVo);
        }
        return page;
    }

    @Override
    public void orderItemCountReportExport(QueryFilter<WorkOrderInformation> queryFilter, HttpServletResponse response) throws IOException {
        PageList<OrderItemCountVo> orderItemCountVoPageList = this.orderItemCountReport(queryFilter);
        List lists = orderItemCountVoPageList.getRows();
        if (null == lists || lists.isEmpty()) {
            throw new RuntimeException("\u6682\u65e0\u6570\u636e\u5bfc\u51fa\uff01");
        }
        long time = System.currentTimeMillis();
        String fileName = "\u65e5\u5e38\u517b\u62a4\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868" + time;
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u65e5\u5e38\u517b\u62a4\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868");
        sheet.setColumnWidth(0, 3840);
        sheet.setColumnWidth(1, 7680);
        sheet.setColumnWidth(2, 3840);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 3840);
        sheet.setColumnWidth(5, 3840);
        sheet.setColumnWidth(6, 3840);
        sheet.setColumnWidth(7, 3840);
        sheet.setColumnWidth(8, 3840);
        sheet.setColumnWidth(9, 2048);
        sheet.setColumnWidth(10, 2048);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyleLeft = workbook.createCellStyle();
        HSSFCellStyle cellStyleLeftAlign = workbook.createCellStyle();
        HSSFCellStyle cellStyleRight = workbook.createCellStyle();
        HSSFCellStyle cellStyleSmall = workbook.createCellStyle();
        HSSFCellStyle cellStyleNoLine = workbook.createCellStyle();
        HSSFCellStyle cellStyleTitleNoLine = workbook.createCellStyle();
        PoiStyleUtil.setExcelStyle(cellStyle, workbook);
        PoiStyleUtil.setExcelStyleNoLine(cellStyleNoLine, workbook);
        PoiStyleUtil.setExcelStyleSmall(cellStyleSmall, workbook);
        PoiStyleUtil.setExcelStyleTitleOne(cellStyleTitle, workbook);
        PoiStyleUtil.setExcelStyleTitleNoLine(cellStyleTitleNoLine, workbook);
        PoiStyleUtil.setExcelStyleLeft(cellStyleLeft, workbook);
        PoiStyleUtil.setExcelStyleRight(cellStyleRight, workbook);
        PoiStyleUtil.setExcelStyleLeftAlign(cellStyleLeftAlign, workbook);
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u65e5\u5e38\u517b\u62a4\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868");
        cell.setCellStyle(cellStyleNoLine);
        row.createCell(1).setCellStyle(cellStyleNoLine);
        row.createCell(2).setCellStyle(cellStyleNoLine);
        row.createCell(3).setCellStyle(cellStyleNoLine);
        row.createCell(4).setCellStyle(cellStyleNoLine);
        row.createCell(5).setCellStyle(cellStyleNoLine);
        row.createCell(6).setCellStyle(cellStyleNoLine);
        row.createCell(7).setCellStyle(cellStyleNoLine);
        row.createCell(8).setCellStyle(cellStyleNoLine);
        row.createCell(9).setCellStyle(cellStyleNoLine);
        row.createCell(10).setCellStyle(cellStyleNoLine);
        HSSFCellStyle cellStyleTitleNoLineSmall = workbook.createCellStyle();
        PoiStyleUtil.cellStyleTitleNoLineSmall(cellStyleTitleNoLineSmall, workbook);
        HSSFCell cell01 = row.createCell(0);
        cell01.setCellStyle(cellStyleTitleNoLineSmall);
        cell01.setCellValue("\u8def\u6bb5");
        HSSFCell cell02 = row.createCell(1);
        cell02.setCellValue("\u6210\u672c\u79d1\u76ee");
        cell02.setCellStyle(cellStyleTitleNoLineSmall);
        HSSFCell cell03 = row.createCell(2);
        cell03.setCellStyle(cellStyleTitleNoLineSmall);
        cell03.setCellValue("\u5df2\u5b8c\u6210");
        HSSFCell cell04 = row.createCell(3);
        cell04.setCellStyle(cellStyleTitleNoLineSmall);
        cell04.setCellValue("\u65bd\u5de5\u4e2d");
        HSSFCell cell05 = row.createCell(4);
        cell05.setCellStyle(cellStyleTitleNoLineSmall);
        cell05.setCellValue("\u5df2\u903e\u671f");
        HSSFCell cell06 = row.createCell(5);
        cell06.setCellStyle(cellStyleTitleNoLineSmall);
        cell06.setCellValue("\u5408\u540c\u91d1\u989d");
        HSSFCell cell07 = row.createCell(6);
        cell07.setCellStyle(cellStyleTitleNoLineSmall);
        cell07.setCellValue("\u5b8c\u6210\u91d1\u989d");
        HSSFCell cell08 = row.createCell(7);
        cell08.setCellStyle(cellStyleTitleNoLineSmall);
        cell08.setCellValue("\u6267\u884c\u7387");
        int num = 0;
        for (OrderItemCountVo vo : lists) {
            HSSFRow row1 = sheet.createRow(++num);
            HSSFCell cell1 = row1.createCell(0);
            cell1.setCellValue("\u8def\u6bb5");
            HSSFCell cell2 = row1.createCell(1);
            cell2.setCellValue("\u6210\u672c\u79d1\u76ee");
            HSSFCell cell3 = row1.createCell(2);
            cell3.setCellValue("\u5df2\u5b8c\u6210");
            HSSFCell cell4 = row1.createCell(3);
            cell4.setCellValue("\u65bd\u5de5\u4e2d");
            HSSFCell cell5 = row1.createCell(4);
            cell5.setCellValue("\u5df2\u903e\u671f");
            HSSFCell cell6 = row1.createCell(5);
            cell6.setCellValue("\u5408\u540c\u91d1\u989d");
            HSSFCell cell7 = row1.createCell(6);
            cell7.setCellValue("\u5b8c\u6210\u91d1\u989d");
            HSSFCell cell8 = row1.createCell(7);
            cell8.setCellValue("\u6267\u884c\u7387");
            cell1.setCellValue(vo.getRoadName());
            cell2.setCellValue(vo.getItemName());
            cell3.setCellValue(vo.getFinishCount().toString());
            cell4.setCellValue(vo.getConstructionCount().toString());
            cell5.setCellValue(vo.getOverdueCount().toString());
            cell6.setCellValue(vo.getContractMoney().toString());
            cell7.setCellValue(vo.getFinishMoney().toString());
            cell8.setCellValue(vo.getImplementationRate());
        }
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + "\u65e5\u5e38\u517b\u62a4\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868" + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
        PoiStyleUtil.zip(fileName, true);
        String zip = fileName + ".zip";
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
        FileUtil.deleteFile((String)zip);
    }

    @Override
    public void exportOrderCashReport(QueryFilter<YearBudget> queryFilter, HttpServletResponse response) {
        PageList<OrderCashVo> cashReport = this.getOrderCashReport(queryFilter);
        List rows = cashReport.getRows();
        if (null == rows || rows.isEmpty()) {
            throw new RuntimeException("\u6682\u65e0\u6570\u636e\u5bfc\u51fa\uff01");
        }
        Integer year = ((OrderCashVo)rows.get(0)).getAscriptionYear();
        Workbook workbook = null;
        boolean count = false;
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            long q2 = System.currentTimeMillis();
            workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(year + "\u5e74\u5ea6\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5", year + "\u5e74\u5ea6\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5"), OrderCashVo.class, (Collection)rows);
            String fileName = year + "\u5e74\u5ea6\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5" + System.currentTimeMillis() + ".xls";
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.flushBuffer();
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25,\u8bf7\u91cd\u8bd5");
        }
    }

    @Override
    public PageList<OrderItemCountVo> orderItemCountReport(QueryFilter<WorkOrderInformation> queryFilter) {
        HashMap map = new HashMap();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        List<Object> roadList = new ArrayList();
        if (ObjectUtils.isEmpty(map.get("croadSegmentId"))) {
            QueryWrapper roadQueryWrapper = new QueryWrapper();
            roadQueryWrapper.like(StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()), (Object)"COMPANY_IDS_", (Object)this.baseContext.getCurrentOrgId());
            roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            queryFilter.addFilter("croadSegmentId", roadList, QueryOP.IN);
        }
        List querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if (query.getProperty().equals("croadSegmentId")) {
                query.setProperty("a.ROAD_SEGMENT_ID_");
            }
            if (query.getProperty().equals("cissueDate")) {
                query.setProperty("a.ISSUE_DATE_");
            }
            if (!query.getProperty().equals("companyId")) continue;
            query.setProperty("road.COMPANY_ID");
            query.setOperation(QueryOP.IN);
        }
        IPage<OrderItemCountVo> result = this.workOrderInformationDao.orderItemCountReport((IPage<WorkOrderInformation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<WorkOrderInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (OrderItemCountVo record : records) {
            BigDecimal finishMoney = record.getFinishMoney();
            BigDecimal contractMoney = record.getContractMoney();
            BigDecimal divide = finishMoney.divide(contractMoney, 4, 4);
            BigDecimal multiply = divide.multiply(BigDecimal.valueOf(100L)).setScale(2);
            record.setImplementationRate(multiply + "%");
        }
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(String id, Integer state) {
        User currentUser = ContextUtil.getCurrentUser();
        WorkOrderInformationVo vo = this.getVo(id);
        WorkOrderInformation workOrderInformation = vo.getWorkOrderInformation();
        workOrderInformation.setApproveState(state);
        workOrderInformation.setUpdateBy(currentUser.getId());
        this.update((Model)workOrderInformation);
        if (state == 0) {
            Double zf = 0.0;
            List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();
            for (BillOfQuantities billOfQuantitie : billOfQuantities) {
                Float auditMoney = billOfQuantitie.getTaxMoney();
                if (auditMoney == null) continue;
                zf = ArithUtil.add(zf, (double)auditMoney.floatValue());
            }
            if (zf > 0.0) {
                String roadSegmentId = workOrderInformation.getRoadSegmentId();
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("ASCRIPTION_YEAR_", (Object)workOrderInformation.getEndTime().getYear(), QueryOP.EQUAL);
                queryFilter.addFilter("ROAD_SEGMENT_ID_", (Object)roadSegmentId, QueryOP.EQUAL);
                queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
                List yearBudgetList = this.yearBudgetManager.queryNoPage(queryFilter);
                if (null != yearBudgetList && yearBudgetList.size() > 0) {
                    for (YearBudget yearBudget : yearBudgetList) {
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                        queryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                        queryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                        queryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
                        queryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
                        List detaileds = this.yearBudgetDetailedManager.list((Wrapper)queryWrapper);
                        for (YearBudgetDetailed detailed : detaileds) {
                            BigDecimal imageProgress = detailed.getImageProgress();
                            if (imageProgress == null) {
                                imageProgress = new BigDecimal(0);
                            }
                            BigDecimal bigDecimal = imageProgress.subtract(BigDecimal.valueOf(zf / 10000.0));
                            detailed.setImageProgress(bigDecimal);
                            this.yearBudgetDetailedManager.update((Model)detailed);
                        }
                        yearBudget.setAlreadyCount(this.yearBudgetDetailedDao.sumImageProgress(yearBudget.getId()));
                        this.yearBudgetManager.updateById((Object)yearBudget);
                    }
                }
            }
            String maintenanceDeptId = workOrderInformation.getMaintenanceDeptId();
            User receiverUser = (User)this.userManager.getById((Serializable)((Object)maintenanceDeptId));
            LocalDate now = LocalDate.now();
            String msg = "<p>\u6d88\u606f\u63d0\u9192\uff1a<br/>\u60a8\u7684\u517b\u62a4\u5de5\u5355-\u5de5\u5355\u53f7\u3010" + workOrderInformation.getJobNumber() + "\u3011\u5728" + now + "\u5df2\u7ecf\u88ab\u9a73\u56de\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u517b\u62a4\u5de5\u5355!</p>";
            JmsMessage jmsMessage = new JmsMessage();
            jmsMessage.setContent(msg);
            jmsMessage.setType("inner");
            jmsMessage.setTypeKey("bpmnTaskTrans");
            jmsMessage.setSubject("\u9a73\u56de\u63d0\u9192");
            JmsActor sender = new JmsActor();
            sender.setId(currentUser.getId());
            sender.setAccount(currentUser.getAccount());
            sender.setName(currentUser.getFullname());
            sender.setEmail(currentUser.getEmail());
            sender.setMobile(currentUser.getMobile());
            sender.setWeixin(currentUser.getWeixin());
            sender.setClientId(currentUser.getClientId());
            sender.setClientToken(currentUser.getClientToken());
            jmsMessage.setSender(sender);
            JmsActor receiver = new JmsActor();
            receiver.setId(maintenanceDeptId);
            receiver.setAccount(receiverUser.getAccount());
            receiver.setName(receiverUser.getFullname());
            receiver.setEmail(receiverUser.getEmail());
            receiver.setMobile(receiverUser.getMobile());
            receiver.setWeixin(receiverUser.getWeixin());
            receiver.setClientId(receiverUser.getClientId());
            receiver.setClientToken(receiverUser.getClientToken());
            List<JmsActor> receivers = Arrays.asList(receiver);
            jmsMessage.setReceivers(receivers);
            InnerHandler jmsHandler = this.innerHandler;
            jmsHandler.send(jmsMessage);
        }
    }

    @Override
    public void exportOrderSpecialCashReport(QueryFilter<BizEngineeringProject> queryFilter, HttpServletResponse response) {
        PageList<OrderSpecialCashVo> specialCashReport = this.getOrderSpecialCashReport(queryFilter);
        List rows = specialCashReport.getRows();
        if (null == rows || rows.isEmpty()) {
            throw new RuntimeException("\u6682\u65e0\u6570\u636e\u5bfc\u51fa\uff01");
        }
        String year = ((OrderSpecialCashVo)rows.get(0)).getProjectYear();
        Workbook workbook = null;
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868", "\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868"), OrderSpecialCashVo.class, (Collection)rows);
            String fileName = year + "\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868" + System.currentTimeMillis() + ".xls";
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.flushBuffer();
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25,\u8bf7\u91cd\u8bd5");
        }
    }
}

