## 联动规则

联动规则指当下拉框、复选框、单选按钮为指定的值时，联动其他字段做出相应的变化。


<span style="color:#f00;font-size: bold">特别注意：</span>联动规则只在`ht-select`,`ht-checkbox`,`ht-radio`三种类型的控件上生效。


如下面的代码所示，通过属性`:linkage`来配置联动规则，该属性接收`Array,Object`类型的值。

```html
<ht-select
    v-model="data.ah"
    class="m-r"
    :options="[{ key: '1', value: '爬山' },{ key: '2', value: '游泳' },{ key: '3', value: '下棋' }]"
    :linkage="[{'value':'1','effect':[{'target': 'permission.shan', 'type': '=','value': 'w'}]},
               {'value':'2','effect':[{'target': 'permission.yong', 'type': '=', 'value': 'b'},{'target': 'validate.yong', 'type': '+', 'value': 'min:5'}]},
               {'value':'3','effect':[{'target': 'permission.qi', 'type': '=', 'value': 'w'},{'target': 'validate.qi', 'type': '-', 'value': 'email'}]}]" />
<ht-input :permission="permission.shan" v-model="data.shan" placeholder="喜欢爬哪座山" />
<ht-input :permission="permission.yong" v-model="data.yong" placeholder="喜欢哪种泳姿" />
<ht-input :permission="permission.qi" v-model="data.qi" placeholder="喜欢哪种棋" />
```

每一个`Object`对象的结构为`{value: X,effect: [...]}`格式，表示当前控件的值为X时，联动`effect`中的内容，`effect`为一个数组，其中的每一个对象的结构为`{target: m, type: n, value: t}`，表示要联动的对象为m，联动的类型为n，联动的值为t。

## 联动类型
|类型|说明|示例|
|:---|:---|:---|
|=|赋值操作|`{'target': 'permission.shan', 'type': '=','value': 'w'}`,将`permission.shan`属性赋值为`w`，根据权限控制，当该属性由`n`变为`w`时则实现了由隐藏到可编辑的联动变化。|
|+|追加操作|`{'target': 'validate.yong', 'type': '+', 'value': 'min:5'}`,对`validate.yong`属性追加`min:5`[校验规则](/validation)。追加规则时如果原来已经存在同名规则，则会用新规则覆盖同名规则；如果原来不存在的规则，则新增。|
|-|减少操作|`{'target': 'validate.qi', 'type': '-', 'value': 'email'}`,对`valiate.qi`属性减少`email`[检验规则](/validation)。减少规则时，会从原来的规则中移除掉同名规则。|