let SelecorCodeHtml = {
  code: `<template>
  <div>
    <form data-vv-scope="form2" v-form>
      <el-row :gutter="20">
        <el-col :span="20">
          <MdView>
            <template>
              # 选择器用法
              当前实现的选择器是演示使用的 ，具体到项目中实现时需要实现对应的组件
              例如 维度选择器是MyDemension.vue组件 具体到X7项目实现时可以参考MyDemension.vue实现一个X7Demension.vue的组件
            </template>
          </MdView>数据预览
          <pre>{{data.xxbb}}</pre>
          <CodeBox name="维度选择器" alias="demensionSelector" :code="demo.demensionCode" desc="维度选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission1" permission="w" :options="permissions" />
                <br />
                <my-demension
                  v-model="data.xxbb.szwd"
                  :permission="permission1"
                  :config="{id:'data.xxbb.szwdId',code: 'data.xxbb.szwdCode'}"
                  placeholder="选择你所在的维度"
                />
              </div>
            </template>
          </CodeBox>
          <CodeBox name="组织选择器" alias="orgSelector" :code="demo.orgCode" desc="组织选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission2" permission="w" :options="permissions" />
                <br />
                <my-org-selector
                  v-model="data.xxbb.orgs"
                  :permission="permission2"
                  :config="{id:'data.xxbb.orgIds',code: 'data.xxbb.orgCodes', name: 'data.xxbb.orgNames'}"
                  placeholder="选择你所在的组织"
                />
              </div>
            </template>
          </CodeBox>

          <CodeBox name="角色选择器" alias="roleSelector" :code="demo.roleCode" desc="角色选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission3" permission="w" :options="permissions" />
                <br />
                <my-role-selector
                  v-model="data.xxbb.roles"
                  :permission="permission3"
                  :config="{id:'data.xxbb.roleId',code: 'data.xxbb.roleCode'}"
                  placeholder="请选择"
                />
              </div>
            </template>
          </CodeBox>

          <CodeBox name="用户选择器" alias="userSelector" :code="demo.userCode" desc="用户选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission4" permission="w" :options="permissions" />
                <br />
                <my-user-selector
                  v-model="data.xxbb.users"
                  :permission="permission4"
                  :config="{id:'data.xxbb.userIds',fullname: 'data.xxbb.userFullnames',account: 'data.xxbb.userAccounts'}"
                  placeholder="请选择"
                />
              </div>
            </template>
          </CodeBox>

          <CodeBox name="职务选择器" alias="jobSelector" :code="demo.jobCode" desc="职务选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission5" permission="w" :options="permissions" />
                <br />
                <my-job-selector
                  v-model="data.xxbb.jobs"
                  :permission="permission5"
                  :config="{id:'data.xxbb.jobIds',code: 'data.xxbb.jobCodes'}"
                  placeholder="请选择"
                />
              </div>
            </template>
          </CodeBox>

          <CodeBox name="岗位选择器" alias="postSelector" :code="demo.postCode" desc="岗位选择器">
            <template slot="demo">
              <div>
                权限设置：
                <ht-radio v-model="permission6" permission="w" :options="permissions" />
                <br />
                <my-post-selector
                  v-model="data.xxbb.posts"
                  :permission="permission6"
                  :config="{id:'data.xxbb.postIds',code: 'data.xxbb.postCodes'}"
                  placeholder="请选择"
                />
              </div>
            </template>
          </CodeBox>
        </el-col>
        <el-col :span="4">
          <AnchorWrapper :anchors="demo.anchors" />
        </el-col>
      </el-row>
    </form>
    <el-row>
      <el-col :span="20">
        <form data-vv-scope="form1" v-form>
          <table class="form-table" cellspacing="0" cellpadding="0" border="0">
            <tbody>
              <tr>
                <th class="group-th" colspan="4">
                  选择器 &ensp;&ensp;&ensp;
                  权限设置：
                  <ht-radio v-model="permission" permission="w" :options="permissions" />
                </th>
              </tr>
              <tr v-permit="4">
                <th>所在维度：</th>
                <td>
                  <my-demension
                    v-model="data.xxb.szwd"
                    :permission="permission"
                    :config="{id:'data.xxb.szwdId',code: 'data.xxb.szwdCode'}"
                    placeholder="选择你所在的维度"
                  />
                </td>
                <th>组织选择：</th>
                <td>
                  <my-org-selector
                    v-model="data.xxb.orgs"
                    :permission="permission"
                    :config="{id:'data.xxb.orgIds',code: 'data.xxb.orgCodes', name: 'data.xxb.orgNames'}"
                    placeholder="选择你所在的组织"
                  />
                </td>
              </tr>
              <tr v-permit="4">
                <th>角色选择：</th>
                <td>
                  <my-role-selector
                    v-model="data.xxb.roles"
                    :permission="permission"
                    :config="{id:'data.xxb.roleId',code: 'data.xxb.roleCode'}"
                    placeholder="请选择"
                  />
                </td>
                <th width="10%">用户选择：</th>
                <td>
                  <my-user-selector
                    v-model="data.xxb.users"
                    :permission="permission"
                    :config="{id:'data.xxb.userIds',fullname: 'data.xxb.userFullnames',account: 'data.xxb.userAccounts'}"
                    placeholder="请选择"
                  />
                </td>
              </tr>
              <tr v-permit="4">
                <th>职务选择：</th>
                <td>
                  <my-job-selector
                    v-model="data.xxb.jobs"
                    :permission="permission"
                    :config="{id:'data.xxb.jobIds',code: 'data.xxb.jobCodes'}"
                    placeholder="请选择"
                  />
                </td>
                <th width="10%">岗位选择：</th>
                <td>
                  <my-post-selector
                    v-model="data.xxb.posts"
                    :permission="permission"
                    :config="{id:'data.xxb.postIds',code: 'data.xxb.postCodes'}"
                    placeholder="请选择"
                  />
                </td>
              </tr>
            </tbody>
          </table>
        </form>
        <pre>{{data}}</pre>
        <el-button
          style="margin-top: 20px"
          :loading="loading"
          size="small"
          type="primary"
          @click="submit"
        >提交</el-button>
      </el-col>
    </el-row>
  </div>
</template>
<script>
import CodeBox from "@/components/CodeBox.vue";
import AnchorWrapper from "@/components/AnchorWrapper.vue";
import MdView from "@/views/MdView.vue";
import utils from "@/utils.js";
import service from "@/service.js";
import { Message } from "element-ui";
import { setTimeout } from "timers";
import { Promise } from "q";
import MyDemension from "@/demo/MyDemension.vue";
import MyRoleSelector from "@/demo/MyRoleSelector.vue";
import MyUserSelector from "@/demo/MyUserSelector.vue";
import MyOrgSelector from "@/demo/MyOrgSelector.vue";
import MyJobSelector from "@/demo/MyJobSelector.vue";
import MyPostSelector from "@/demo/MyPostSelector.vue";

export default {
  name: "basic-form",
  components: {
    CodeBox,
    AnchorWrapper,
    MdView,
    MyDemension,
    MyRoleSelector,
    MyUserSelector,
    MyOrgSelector,
    MyJobSelector,
    MyPostSelector
  },
  data() {
    return {
      loading: false,
      permission: "w",
      permission1: "w",
      permission2: "w",
      permission3: "w",
      permission4: "w",
      permission5: "w",
      permission6: "w",
      permissions: [
        { key: "w", value: "编辑" },
        { key: "b", value: "必填" },
        { key: "r", value: "只读" }
      ],
      demo: {
        anchors: [
          {
            content: "维度选择器",
            alias: "demensionSelector"
          },
          {
            content: "组织选择器",
            alias: "orgSelector"
          },
          {
            content: "角色选择器",
            alias: "roleSelector"
          },
          {
            content: "用户选择器",
            alias: "userSelector"
          },
          {
            content: "职务选择器",
            alias: "jobSelector"
          },
          {
            content: "岗位选择器",
            alias: "postSelector"
          }
        ],
        demensionCode: \`
                    <my-demension
                            v-model="data.xxb.szwd"
                            :permission="permission"
                            :config="{id:'data.xxb.szwdId',code: 'data.xxb.szwdCode'}"
                            placeholder="选择你所在的维度"
                          />
        \`,
        orgCode: \`<my-org-selector
                v-model="data.xxb.orgs"
                :permission="permission"
                :config="{id:'data.xxb.orgIds',code: 'data.xxb.orgCodes', name: 'data.xxb.orgNames'}"
                placeholder="选择你所在的组织"/>\`,
        roleCode: \`<my-role-selector
                v-model="data.xxb.roles"
                :permission="permission"
                :config="{id:'data.xxb.roleId',code: 'data.xxb.roleCode'}"
                placeholder="请选择"/>\`,
        userCode: \`<my-user-selector
                v-model="data.xxb.users"
                 :permission="permission"
                :config="{id:'data.xxb.userIds',fullname: 'data.xxb.userFullnames',account: 'data.xxb.userAccounts'}"
                placeholder="请选择"/>\`,
        jobCode: \`<my-job-selector
                v-model="data.xxb.jobs"
                 :permission="permission"
                :config="{id:'data.xxb.jobIds',code: 'data.xxb.jobCodes'}"
                placeholder="请选择"/>\`,
        postCode: \`<my-post-selector
                v-model="data.xxb.posts"
                 :permission="permission"
                :config="{id:'data.xxb.postIds',code: 'data.xxb.postCodes'}"
                placeholder="请选择"/>\`
      },
      data: {
        xxb: {
          xm: "张三",
          xb: "1",
          ah: "1,3",
          csrq: "1986-6-29",
          bysj: "2008-6-30",
          szwd: "行政维度,项目维度",
          szwdId: "1,2",
          szwdCode: "xzwd,xzwd",
          roles: "行政角色",
          roleId: "1",
          roleCode: "aa",
          fjzl:
            '[{"name":"更新日志.txt","size":12764,"percentage":100,"status":"success","state":"success"}]',
          sub_bxxx: [],
          users: "黎扬贵1,黎扬贵2",
          userIds: "1,2",
          userFullnames: "黎扬贵1,黎扬贵2",
          userAccounts: "liyanggui1,liyanggui2",
          orgs: "测试部门,财务部",
          orgNames: "测试部门,财务部",
          orgCodes: "csbm,cwb",
          orgIds: "876613,31784"
        },
        xxbb: {
          szwd: "行政维度,项目维度",
          szwdId: "1,2",
          szwdCode: "xzwd,xzwd",

          roles: "行政角色",
          roleId: "1",
          roleCode: "aa",

          users: "黎扬贵1,黎扬贵2",
          userIds: "1,2",
          userFullnames: "黎扬贵1,黎扬贵2",
          userAccounts: "liyanggui1,liyanggui2",

          orgs: "测试部门,财务部",
          orgNames: "测试部门,财务部",
          orgCodes: "csbm,cwb",
          orgIds: "876613,31784"
        }
      },
      validate: {
        xm: null
      }
    };
  },
  methods: {
    handleSelectOptions: function(query) {
      let _me = this;
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          _me.options.zy = _me.options.zy2;
          resolve();
        }, 1000);
      });
    },
    move: function(ary, item, direct) {
      this.data.xxb.sub_bxxx = utils.arrayMove(ary, item, direct);
    },
    submit: function() {
      this.loading = true;
      setTimeout(() => {
        utils
          .validateForm(this, "form1")
          .then(r => {
            Message.success(JSON.stringify(this.data));
          })
          .catch(reason => {
            Message.error(reason);
          })
          .finally(() => {
            this.loading = false;
          });
      }, 500);
    }
  }
};
</script>
`
}

export default SelecorCodeHtml;