import { IGroup, IShape } from '../../dependents';
import { GAnimateCfg } from '../../interface';
import { AnimateExtraCfg } from '../interface';
/**
 * @ignore
 * 单个 shape 动画
 * shape 以自身中心点逐渐放大的进入动画
 * @param shape 参与动画的图形元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
export declare function zoomIn(shape: IShape | IGroup, animateCfg: GAnimateCfg, cfg: AnimateExtraCfg): void;
/**
 * @ignore
 * 单个 shape 动画
 * 消失动画，shape 以自身为中心点的逐渐缩小
 * @param shape 参与动画的图形元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
export declare function zoomOut(shape: IShape | IGroup, animateCfg: GAnimateCfg, cfg: AnimateExtraCfg): void;
