declare type FontWeight = number | 'normal' | 'bold' | 'bolder' | 'lighter';
export interface DataItem {
    /** 文本内容 */
    text: string;
    /** 该文本所占权重 */
    value: number;
}
export interface Options {
    fields?: [string, string];
    font?: string | ((row: DataItem) => string);
    fontSize?: number | ((row: DataItem) => number);
    fontWeight?: FontWeight | ((row: DataItem) => FontWeight);
    rotate?: number | ((row: DataItem) => number);
    padding?: number | ((row: DataItem) => number);
    size?: [number, number];
    spiral?: 'archimedean' | 'rectangular' | ((size: [number, number]) => (t: number) => number[]);
    timeInterval?: number;
    imageMask?: HTMLImageElement;
}
export {};
