declare type Point = [number, number];
/**
 * 将点连接成路径 path
 * @param points
 */
export declare function getLinePath(points: Point[]): any[][];
/**
 * 将点连成平滑的曲线
 * @param points
 */
export declare function getSmoothLinePath(points: Point[]): any[][];
/**
 * 将数据转成 path，利用 scale 的归一化能力
 * @param data
 * @param width
 * @param height
 * @param smooth
 */
export declare function dataToPath(data: number[], width: number, height: number, smooth?: boolean): any[][];
/**
 * 获得 area 面积的横向连接线的 px 位置
 * @param data
 * @param width
 * @param height
 */
export declare function getAreaLineY(data: number[], height: number): number;
/**
 * 线 path 转 area path
 * @param path
 * @param width
 * @param height
 */
export declare function linePathToAreaPath(path: any[][], width: number, height: number, data: number[]): any[][];
export {};
