package com.artfess.report.bigScreen.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.report.bigScreen.manager.BladeVisualCategoryManager;
import com.artfess.report.bigScreen.manager.BladeVisualManager;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 可视化分类表 前端控制器
 *
 * @author 向贞好
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@RestController
@RequestMapping("/bigScreen/bladeVisualCategory/v1/")
@Api(tags = "可视化分类接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class BladeVisualCategoryController extends BaseController<BladeVisualCategoryManager, BladeVisualCategory> {
    @Autowired
    private BladeVisualCategoryManager bladeVisualCategoryManager;
    @Autowired
    private BladeVisualManager bladeVisualManager;

    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "可视化分类(分页条件查询)数据", httpMethod = "POST", notes = "可视化分类(分页条件查询)数据")
    public PageList<BladeVisualCategory> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BladeVisualCategory> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        return baseService.queryBladeVisualCategory(queryFilter);
    }

    @PostMapping(value = "save")
    @ApiOperation(value = "新增,修改可视化分类", httpMethod = "POST", notes = "新增,修改可视化分类")
    public CommonResult<String> save(@ApiParam(name = "bladeVisualCategory", value = "可视化分类", required = true) @RequestBody BladeVisualCategory bladeVisualCategory) throws Exception {
        String msg = "添加成功";
        bladeVisualCategoryManager.checkByCategoryValue(bladeVisualCategory);
        if (StringUtil.isEmpty(bladeVisualCategory.getId())) {
            bladeVisualCategory.setIsDele("0");
            bladeVisualCategoryManager.create(bladeVisualCategory);
        } else {
            bladeVisualCategoryManager.update(bladeVisualCategory);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBladeVisualCategory(@ApiParam(name = "id", value = "可视化分类ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            bladeVisualCategoryManager.updateBatchBladeVisualCategory(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateBatchList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "POST", notes = "批量逻辑删除")
    public CommonResult<String> updateBatchList(
            @ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BladeVisualCategory> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bladeVisualCategoryManager.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }

    @GetMapping(value = "/get/{categoryValue}")
    @ApiOperation(value = "根据categoryValue查询可视化数据和配置", httpMethod = "GET", notes = "根据categoryValue查询可视化数据和配置")
    public List<BladeVisual> getVisual(@ApiParam(name = "categoryValue", value = "categoryValue", required = true) @PathVariable String categoryValue) {
        List<BladeVisual> bladeVisual = baseService.getVisual(categoryValue);
        return bladeVisual;
    }

}
