package com.artfess.report.bigScreen.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.report.bigScreen.manager.BladeVisualManager;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.vo.BladeVisualConfigVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;

/**
 * 可视化表 前端控制器
 *
 * @author 向贞好
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@RestController
@RequestMapping("/bigScreen/bladeVisual/v1/")
@Api(tags = "可视化数据接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class BladeVisualController extends BaseController<BladeVisualManager, BladeVisual> {
    @Autowired
    private BladeVisualManager bladeVisualManager;

    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "可视化(分页条件查询)数据", httpMethod = "POST", notes = "可视化(分页条件查询)数据")
    public PageList<BladeVisual> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BladeVisual> queryFilter) {
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        return baseService.queryBladeVisual(queryFilter);
    }

    @PostMapping(value = "saveBladeVisualConfigVo")
    @ApiOperation(value = "新增可视化数据", httpMethod = "POST", notes = "新增可视化数据")
    public CommonResult<String> saveBladeVisualConfigVo( @RequestBody BladeVisualConfigVo bladeVisualConfigVo) throws Exception {
        String id= this.bladeVisualManager.saveBladeVisualConfigVo(bladeVisualConfigVo);
        return new CommonResult<String>(id);
    }


    @PostMapping(value = "updateBladeVisualConfigVo")
    @ApiOperation(value = "修改可视化数据", httpMethod = "POST", notes = "可视化数据")
    public CommonResult<String> updateBladeVisualConfigVo(@RequestBody BladeVisualConfigVo bladeVisualConfigVo) throws Exception {
        this.bladeVisualManager.updateBladeVisualConfigVo(bladeVisualConfigVo);
        return new CommonResult<String>("success");
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatch(@ApiParam(name = "id", value = "主键ID", required = true)
                                            @RequestParam(value = "id", required = true) String id) throws Exception {
        if (StringUtils.isNotBlank(id)) {
            UpdateWrapper<BladeVisual> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
            updateWrapper.set("is_dele_", "1");
            bladeVisualManager.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateAllBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "POST", notes = "批量逻辑删除")
    public CommonResult<String> updateAllBatch(@ApiParam(name = "id", value = "可视化分类ID集合以，隔开", required = true)
                                               @RequestParam(value = "ids", required = true) String ids) throws Exception {

        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BladeVisual> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in(idsList.size() > 0, "id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bladeVisualManager.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }


    @RequestMapping(value = "updateStatus", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改发布状态", httpMethod = "POST", notes = "修改发布状态")
    public CommonResult<String> updateStatus(@ApiParam(name = "id", value = "主键ID", required = true)
                                             @RequestParam(value = "id", required = true) String id,
                                             @ApiParam(name = "status", value = "发布状态 0:为发布 1:已发布", required = true)
                                             @RequestParam(value = "status", required = true) Integer status) throws Exception {
        if (StringUtils.isNotBlank(id)) {
            UpdateWrapper<BladeVisual> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
            updateWrapper.set("status_", status);
            bladeVisualManager.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "修改成功");
    }

    @RequestMapping(value = "uploadPhoto", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "上传图片", httpMethod = "POST", notes = "上传图片")
    public CommonResult<String> uploadPhoto(MultipartFile positiveFile) throws Exception {
        String uri = bladeVisualManager.uploadPhoto(positiveFile);
        return new CommonResult<String>(uri);
    }

    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "根据id查询可视化数据和配置", httpMethod = "GET", notes = "根据id查询可视化数据和配置")
    public BladeVisualConfigVo getVisualConfig(@ApiParam(name = "id", value = "主键ID", required = true) @PathVariable String id) {
        BladeVisualConfigVo visualConfigVo = baseService.getVisualConfig(id);
        return visualConfigVo;
    }


}
