/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.model;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bo.exception.BoBaseException;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.util.BoUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BoData {
    private Map<String, Object> row = new HashMap<String, Object>();
    private Map<String, List<BoData>> subMap = new HashMap<String, List<BoData>>();
    private Map<String, Map<String, Object>> initDataMap = new HashMap<String, Map<String, Object>>();
    private BoEnt boEnt = null;
    private BoDef boDef = null;
    private String boDefAlias = null;

    public void setBoEnt(BoEnt ent) {
        this.boEnt = ent;
    }

    public BoEnt getBoEnt() {
        return this.boEnt;
    }

    public void set(String key, Object val) {
        this.row.put(key, val);
    }

    public Object getByKey(String key) {
        return this.row.get(key);
    }

    public boolean containKey(String key) {
        if (BeanUtils.isEmpty(this.row)) {
            return false;
        }
        return this.row.containsKey(key);
    }

    @JsonIgnore
    public boolean isAdd() {
        String pk;
        Map<String, Object> row = this.getData();
        return !row.containsKey(pk = this.boEnt.getPkKey().toLowerCase()) || !StringUtil.isNotEmpty((String)String.valueOf(row.get(pk)));
    }

    public Object getValByKey(String key) throws ParseException {
        BoAttribute attr = this.boEnt.getAttribute(key);
        Object obj = this.row.get(key);
        if (obj == null || obj instanceof NullNode) {
            return null;
        }
        String dataType = "";
        dataType = BeanUtils.isNotEmpty((Object)((Object)attr)) ? attr.getDataType() : this.boEnt.getPkType();
        if ("varchar".equals(dataType) || "clob".equals(dataType)) {
            return obj.toString();
        }
        if ("number".equals(dataType)) {
            String val = obj.toString();
            if (StringUtil.isEmpty((String)val)) {
                return null;
            }
            if (attr.getDecimalLen() == 0) {
                if (attr.getAttrLength() <= 10) {
                    return Integer.parseInt(obj.toString());
                }
                return Long.parseLong(obj.toString());
            }
            return Double.parseDouble(obj.toString());
        }
        if ("date".equals(dataType)) {
            String val = obj.toString();
            if (StringUtil.isEmpty((String)val)) {
                return null;
            }
            String format = attr.getFormat();
            if (StringUtil.isEmpty((String)format)) {
                format = "yyyy-MM-dd HH:mm:ss";
            }
            return DateFormatUtil.parseDate((String)obj.toString(), (String)format);
        }
        return obj.toString();
    }

    public String getString(String key) {
        Object obj = this.row.get(key);
        if (obj != null) {
            if (obj instanceof TextNode) {
                return ((TextNode)obj).asText();
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            throw new BoBaseException(String.format("BoData\u4e2dkey\u4e3a%s\u7684\u5c5e\u6027\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b", key));
        }
        return "";
    }

    public Map<String, Object> getData() {
        return this.row;
    }

    public void setData(Map<String, Object> row) {
        this.row = row;
    }

    public void removeByKey(String key) {
        this.row.remove(key);
    }

    public void addSubRow(String key, BoData data) {
        if (this.subMap.containsKey(key)) {
            List<BoData> list = this.subMap.get(key);
            list.add(data);
        } else {
            ArrayList<BoData> list = new ArrayList<BoData>();
            list.add(data);
            this.subMap.put(key, list);
        }
    }

    public void setSubList(String key, List<BoData> list) {
        this.subMap.put(key, list);
    }

    public List<BoData> getSubByKey(String subKey) {
        return this.subMap.get(subKey);
    }

    public void removeSub(String key) {
        this.subMap.remove(key);
    }

    public Map<String, List<BoData>> getSubMap() {
        return this.subMap;
    }

    public Map<String, Map<String, Object>> getInitDataMap() {
        return this.initDataMap;
    }

    public void setInitDataMap(Map<String, Map<String, Object>> initDataMap) {
        this.initDataMap = initDataMap;
    }

    public void addInitDataMap(String key, Map<String, Object> initRow) {
        this.initDataMap.put(key, initRow);
    }

    public void setInitData(String key, String fieldName, Object val) {
        if (this.initDataMap.containsKey(key)) {
            Map<String, Object> row = this.initDataMap.get(key);
            row.put(fieldName, val);
        } else {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put(fieldName, val);
            this.initDataMap.put(key, row);
        }
    }

    @JsonIgnore
    public BoDef getBoDef() {
        return this.boDef;
    }

    public void setBoDef(BoDef boDef) {
        this.boDef = boDef;
    }

    public String getBoDefAlias() {
        return this.boDefAlias;
    }

    public void setBoDefAlias(String boDefAlias) {
        this.boDefAlias = boDefAlias;
    }

    public String toString() {
        try {
            return BoUtil.toJSON(this, true).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BoBaseException(e.getMessage());
        }
    }
}

