package com.artfess.cqxy.projectApproval.dao;

import java.util.List;
import java.util.Map;

import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;

/**
 * 年度计划表(DecisionAnnualPlan)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-31 16:37:17
 */
public interface DecisionAnnualPlanDao extends BaseMapper<DecisionAnnualPlan> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    DecisionAnnualPlan getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<DecisionAnnualPlan> queryAllByPage(IPage<DecisionAnnualPlan> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DecisionAnnualPlan> convert2Wrapper);

    /**
     * 根据条件查询每月的投资金额
     * @param statisticsVo
     * @return
     */
    List<Map<String, String>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);


}

