package com.artfess.cqxy.ledger.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.annotation.BigDecimalFormat;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 黎沐华
 * @date 2022/6/2 9:56
 */
@Data
@ApiModel("项目支付台账VO")
public class PayLedgerVo extends Model<PayLedgerVo> {

    @Excel(name = "项目名称")
    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @Excel(name = "费用名称")
    @TableField("PURPOSE_")
    @ApiModelProperty(value = "用途（使用字典：1：工程款，）")
    private String purpose;

    @Excel(name = "合同名称")
    @TableField("CONTRACT_NAME_")
    @ApiModelProperty(value = "合同名称（关联合同表合同名称）")
    private String contractName;

    @Excel(name="合同金额（元）")
    @TableField("CONTRACT_AMOUNT_")
    @ApiModelProperty(value = "合同金额（元）")
    private String contractAmount;

    @Excel(name = "收款单位")
    @TableField("REGISTER_PERSON_NAME_")
    @ApiModelProperty(value = "收款单位")
    private String registerPersonName;

    @Excel(name = "支付方式")
    @ApiModelProperty(value = "支付方式")
    private String payType;

    @BigDecimalFormat
    @Excel(name = "本次拨付金额（元）")
    @TableField("PAYEE_AMOUNT_TOTAL_")
    @ApiModelProperty(value = "本次拨付金额（元）")
    private BigDecimal payeeAmountTotal;

    @Excel(name = "累计支付比例")
    @ApiModelProperty(value = "累计支付比例")
    private String payRatio;

    @TableField("REGISTER_DATE_")
    @ApiModelProperty(value = "审批日期")
    @Excel(name = "审批日期",format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate;

    @BigDecimalFormat
    @Excel(name = "已拨款额（元）")
    @TableField("AMOUNT_APPROPRIATED_")
    @ApiModelProperty(value = "已拨款额（元）")
    private BigDecimal amountAppropriated;

    @TableField("REGISTER_PERSON_ID_")
    @ApiModelProperty(value = "开户行")
    private String registerPersonId;

}
