package com.artfess.cqxy.contract.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.contract.manager.AdministrativePaymentManager;
import com.artfess.cqxy.contract.model.AdministrativePayment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

/**
 * (AdministrativePayment)表控制层
 *
 * @author makejava
 * @since 2022-11-28 10:07:39
 */
@Slf4j
@RestController
@Api(tags = "合同管理-行政缴费接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/contract/administrativePayment/v1")
public class AdministrativePaymentController extends BaseController<AdministrativePaymentManager, AdministrativePayment> {

    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("行政缴费-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("投标管理-删除数据接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

}

