package com.artfess.cqxy.wps.vo;

import com.artfess.cqxy.wps.model.File;
import com.artfess.cqxy.wps.model.User;
import com.artfess.cqxy.wps.model.Watermark;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author 黎沐华
 * @date 2022/4/26 9:46
 */
@Data
@NoArgsConstructor
@ApiModel("WPS 文件信息Vo")
public class FileVo {

    @ApiModelProperty("响应状态码")
    private Integer code;

    @ApiModelProperty("响应状态")
    private String status;

    @ApiModelProperty("响应信息")
    private String message;

    @ApiModelProperty("文件数据")
    private File file;

    @ApiModelProperty("用户数据")
    private User user;

    private Watermark watermark;

    public FileVo(Integer code, String status, String message, File file, User user) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.file = file;
        this.user = user;
        this.watermark = new Watermark();
    }
}