package com.artfess.cqxy.processManagermant.model;


import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 过程管理 - 进度管理 - 本次拨款明细(BizProgressManageDefinite)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-04 16:49:48
 */
@Data
@TableName("BIZ_PROGRESS_MANAGE_Definite")
@ApiModel(value="过程管理-进度管理-本次拨款明细对象-ProgressManageDefinite", description="过程管理-进度管理-本次拨款明细表")
public class ProgressManageDefinite extends BizModel<ProgressManageDefinite> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROGRESS_MANAGE_ID_")
    @ApiModelProperty(value = "进度管理表ID（关联进度管理管理表ID）")
    private String progressManageId;

    @TableField("PURPOSE_")
    @ApiModelProperty(value = "支付类型（使用字典：1：工程价款，2：农民工专项款）")
    private String purpose;

    @TableField("PAYEE_UNIT_")
    @ApiModelProperty(value = "收款单位")
    private String payeeUnit;

    @TableField("BANK_OF_DEPOSIT_")
    @ApiModelProperty(value = "开户行")
    private String bankOfDeposit;

    @TableField("PAYEE_NUM_")
    @ApiModelProperty(value = "收款账号")
    private String payeeNum;

    @TableField("PAYEE_AMOUNT_")
    @ApiModelProperty(value = "收款金额（单位：元）")
    private BigDecimal payeeAmount;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "关联的进度管理信息")
    private ProgressManage progressManageInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @Override
    public String toString() {
        return "ProgressManageDefinite{" +
                "id='" + id + '\'' +
                ", progressManageId='" + progressManageId + '\'' +
                ", purpose=" + purpose +
                ", payeeUnit='" + payeeUnit + '\'' +
                ", bankOfDeposit='" + bankOfDeposit + '\'' +
                ", payeeNum='" + payeeNum + '\'' +
                ", payeeAmount=" + payeeAmount +
                ", remarks='" + remarks + '\'' +
                ", progressManageInfo=" + progressManageInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

