/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.constructionPermit.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.constructionPermit.dao.ConstructionPermitDao;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitManager;
import com.artfess.cqxy.constructionPermit.model.ConstructionPermit;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConstructionPermitManagerImpl
extends BaseManagerImpl<ConstructionPermitDao, ConstructionPermit>
implements ConstructionPermitManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(ConstructionPermit entity) {
        boolean save = StringUtils.isEmpty((Object)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.ten.getCode());
            ele.setGroup("ConstructionPermit");
            ele.setNode(ProjectStatusEnum.ten.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.ten.getCode()));
        ProjectManagement projectManagement = (ProjectManagement)this.pmm.get((Serializable)((Object)entity.getProjectId()));
        if (null != projectManagement) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entity.getProposedLocation())) {
                projectManagement.setProjectAddress(entity.getProposedLocation());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entity.getProposedLandArea())) {
                projectManagement.setProjectContent(entity.getProposedLandArea());
            }
            this.pmm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ConstructionPermit entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.fivteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.fivteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.fivteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.fivteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.fivteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.fivteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.fivteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.fivteen.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getCode());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getCode() + "_" + entity.getEstablishmentApprovalUnit() + "_" + entity.getProposedLocation() + "_" + entity.getSupervisorUnit() + "_" + entity.getDesignUnit() + "_" + entity.getConstructionUnit() + "_" + entity.getSurveyUnit() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public ConstructionPermit getById(String id) {
        return ((ConstructionPermitDao)this.baseMapper).getById(id);
    }

    @Override
    public PageList<ConstructionPermit> queryAllByPage(QueryFilter<ConstructionPermit> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bcp", "pm");
        IPage<ConstructionPermit> result = ((ConstructionPermitDao)this.baseMapper).queryAllByPage((IPage<ConstructionPermit>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ConstructionPermit>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ConstructionPermit ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, ConstructionPermit.class, (ImportParams)new ImportParams());
            for (ConstructionPermit ele : data) {
                ele.setProjectId(projectId);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<ConstructionPermit> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u4e94\u65b9\u8d23\u4efb\u4e3b\u4f53-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bcp", "pm");
        List data = ((ConstructionPermitDao)this.baseMapper).queryAllByPage((IPage<ConstructionPermit>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ConstructionPermit>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ConstructionPermit.class, (Collection)data);
        Sheet sheet = workbook.getSheetAt(0);
        for (int i = 2; i <= 17; ++i) {
            sheet.setColumnWidth(i, 4500);
        }
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

