/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.ledger.manager.ContractLedgerManager;
import com.artfess.cqxy.ledger.vo.ContractKeeperVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f0\u8d26-\u5408\u540c\u53f0\u8d26\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/ledger/contractLedger/v1"})
public class ContractLedgerController {
    private static final Logger log = LoggerFactory.getLogger(ContractLedgerController.class);
    @Autowired
    private ContractLedgerManager manager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="POST")
    public CommonResult<Map<String, Object>> page(@ApiParam(name="queryFilter", value="\u9879\u76ee\u7ba1\u7406\u67e5\u8be2\u5668") @RequestBody QueryFilter<Contract> queryFilter) {
        Map<String, Object> result = this.manager.queryByPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u5408\u540c\u67e5\u8be2\u5668")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        this.manager.exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/updateContractReceiverById"})
    @ApiOperation(value="S-\u4fee\u6539\u5408\u540c\u7ecf\u529e\u4eba", httpMethod="POST")
    public CommonResult<String> updateContractReceiverById(@ApiParam(name="queryFilter", value="\u9879\u76ee\u7ba1\u7406\u67e5\u8be2\u5668") @RequestBody ContractKeeperVo contractKeeperVo) {
        this.manager.updateContractReceiverById(contractKeeperVo);
        return new CommonResult(true, "\u6570\u636e\u4fee\u6539\u6210\u529f\uff01", (Object)contractKeeperVo.getId());
    }
}

