/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqxy.ledger.dao.MenuFieldTempDao;
import com.artfess.cqxy.ledger.manager.MenuCustomizeFieldManager;
import com.artfess.cqxy.ledger.manager.MenuFieldTempManager;
import com.artfess.cqxy.ledger.model.MenuCustomizeField;
import com.artfess.cqxy.ledger.model.MenuFieldTemp;
import com.artfess.cqxy.ledger.vo.MenuCustomizeParamVo;
import com.artfess.cqxy.ledger.vo.MenuCustomizeVo;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuFieldTempManagerImpl
extends BaseManagerImpl<MenuFieldTempDao, MenuFieldTemp>
implements MenuFieldTempManager {
    @Resource
    private MenuCustomizeFieldManager menuCustomizeFieldManager;
    @Autowired
    private SysDictionaryManager sdm;

    @Override
    @Transactional(readOnly=true)
    public MenuCustomizeVo getDataById(MenuCustomizeParamVo menuCustomizeParamVo) {
        String id = menuCustomizeParamVo.getId();
        String queryProjectId = menuCustomizeParamVo.getProjectId();
        String projectType = menuCustomizeParamVo.getProjectType();
        String startMoney = menuCustomizeParamVo.getStartMoney();
        String endMoney = menuCustomizeParamVo.getEndMoney();
        String startTime = menuCustomizeParamVo.getStartTime();
        String endTime = menuCustomizeParamVo.getEndTime();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("queryProjectId", StringUtils.isBlank((CharSequence)queryProjectId) ? null : "'" + queryProjectId + "'");
        paramMap.put("projectType", StringUtils.isBlank((CharSequence)projectType) ? null : "'" + projectType + "'");
        paramMap.put("startMoney", StringUtils.isBlank((CharSequence)startMoney) ? null : "'" + startMoney + "'");
        paramMap.put("endMoney", StringUtils.isBlank((CharSequence)endMoney) ? null : "'" + endMoney + "'");
        paramMap.put("startTime", StringUtils.isBlank((CharSequence)startTime) ? null : "'" + startTime + "'");
        paramMap.put("endTime", StringUtils.isBlank((CharSequence)endTime) ? null : "'" + endTime + "'");
        MenuCustomizeVo menuCustomizeVo = new MenuCustomizeVo();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<String> header = new ArrayList<String>();
        MenuFieldTemp menuFieldTemp = (MenuFieldTemp)((Object)((MenuFieldTempDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID_", new Object[]{id});
        queryWrapper.orderByAsc((Object)"SN_");
        List menuCustomizeFieldList = this.menuCustomizeFieldManager.list((Wrapper)queryWrapper);
        menuFieldTemp.setMenuCustomizeFieldList(menuCustomizeFieldList);
        header.add("\u5e8f\u53f7");
        int fieldIndex = 1;
        int num = 1;
        if (null != menuCustomizeFieldList && menuCustomizeFieldList.size() > 0) {
            int columnSize = menuCustomizeFieldList.size() + 1;
            for (MenuCustomizeField menuCustomizeField : menuCustomizeFieldList) {
                Object[] arr;
                int i;
                int j;
                String head = menuCustomizeField.getFieldName();
                header.add(head);
                String field = menuCustomizeField.getField();
                String table = menuCustomizeField.getTable();
                String isDele = null;
                String projectManagement = null;
                String projectId = null;
                String string = isDele = this.haveColumn(table, "IS_DELE_") ? "0" : null;
                if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(table)) {
                    projectManagement = StringUtils.isBlank((CharSequence)queryProjectId) ? null : "'" + queryProjectId + "'";
                } else {
                    paramMap = null;
                    projectId = StringUtils.isBlank((CharSequence)queryProjectId) ? null : "'" + queryProjectId + "'";
                }
                List<Object> fieldDataList = ((MenuFieldTempDao)this.baseMapper).getDataById(field, table, isDele, projectManagement, projectId, paramMap);
                String fieldTypeValue = menuCustomizeField.getFieldTypeValue();
                if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(table) && (null == fieldDataList || fieldDataList.size() == 0)) break;
                if (null == fieldDataList || fieldDataList.size() == 0) {
                    ++fieldIndex;
                    continue;
                }
                int dataListSize = dataList.size();
                if (fieldDataList.size() <= dataListSize) {
                    j = fieldDataList.size();
                    for (i = 0; i < j; ++i) {
                        arr = (Object[])dataList.get(i);
                        arr[0] = num;
                        ++num;
                        arr[fieldIndex] = this.dataFormat(fieldDataList.get(i), fieldTypeValue, menuCustomizeField.getDicKey(), field);
                    }
                } else {
                    j = fieldDataList.size();
                    for (i = 0; i < j; ++i) {
                        arr = null;
                        if (i >= dataList.size()) {
                            arr = new Object[columnSize];
                            arr[fieldIndex] = this.dataFormat(fieldDataList.get(i), fieldTypeValue, menuCustomizeField.getDicKey(), field);
                            dataList.add(arr);
                        } else {
                            arr = (Object[])dataList.get(i);
                            arr[fieldIndex] = this.dataFormat(fieldDataList.get(i), fieldTypeValue, menuCustomizeField.getDicKey(), field);
                        }
                        arr[0] = num;
                        ++num;
                    }
                }
                ++fieldIndex;
            }
        }
        menuCustomizeVo.setDataList(dataList);
        menuCustomizeVo.setHeader(header);
        return menuCustomizeVo;
    }

    @Override
    @Transactional(readOnly=true)
    public MenuCustomizeVo getDataByIds(MenuCustomizeParamVo menuCustomizeParamVo) {
        String id = menuCustomizeParamVo.getId();
        String queryProjectId = menuCustomizeParamVo.getProjectId();
        String projectType = menuCustomizeParamVo.getProjectType();
        String startMoney = menuCustomizeParamVo.getStartMoney();
        String endMoney = menuCustomizeParamVo.getEndMoney();
        String startTime = menuCustomizeParamVo.getStartTime();
        String endTime = menuCustomizeParamVo.getEndTime();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)queryProjectId)) {
            paramMap.put("queryProjectId", null);
        } else {
            String[] split = queryProjectId.split(",");
            ArrayList<String> queryProjectIdList = new ArrayList<String>(split.length);
            for (String str : split) {
                queryProjectIdList.add("'" + str + "'");
            }
            paramMap.put("queryProjectId", queryProjectIdList);
        }
        paramMap.put("projectType", StringUtils.isBlank((CharSequence)projectType) ? null : "'" + projectType + "'");
        paramMap.put("startMoney", StringUtils.isBlank((CharSequence)startMoney) ? null : "'" + startMoney + "'");
        paramMap.put("endMoney", StringUtils.isBlank((CharSequence)endMoney) ? null : "'" + endMoney + "'");
        paramMap.put("startTime", StringUtils.isBlank((CharSequence)startTime) ? null : "'" + startTime + "'");
        paramMap.put("endTime", StringUtils.isBlank((CharSequence)endTime) ? null : "'" + endTime + "'");
        MenuCustomizeVo menuCustomizeVo = new MenuCustomizeVo();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<String> header = new ArrayList<String>();
        MenuFieldTemp menuFieldTemp = (MenuFieldTemp)((Object)((MenuFieldTempDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID_", new Object[]{id});
        queryWrapper.orderByAsc((Object)"SN_");
        List menuCustomizeFieldList = this.menuCustomizeFieldManager.list((Wrapper)queryWrapper);
        menuFieldTemp.setMenuCustomizeFieldList(menuCustomizeFieldList);
        header.add("\u5e8f\u53f7");
        String filedGroup = "";
        HashSet<String> set = new HashSet<String>();
        String tableGroup = "";
        String whereGroup = " WHERE 1=1 ";
        LinkedHashMap<Integer, MenuCustomizeField> dicFieldMap = new LinkedHashMap<Integer, MenuCustomizeField>();
        if (null != menuCustomizeFieldList && menuCustomizeFieldList.size() > 0) {
            int j = menuCustomizeFieldList.size();
            for (int i = 0; i < j; ++i) {
                MenuCustomizeField menuCustomizeField = (MenuCustomizeField)((Object)menuCustomizeFieldList.get(i));
                String head = menuCustomizeField.getFieldName();
                header.add(head);
                String table = menuCustomizeField.getTable();
                if (!"biz_project_management".equalsIgnoreCase(table)) {
                    set.add(table);
                }
                String field = menuCustomizeField.getField();
                filedGroup = i == j - 1 ? filedGroup + table + "." + field : filedGroup + table + "." + field + ",";
                dicFieldMap.put(i, menuCustomizeField);
            }
            for (String tableName : set) {
                tableGroup = tableGroup + " INNER JOIN " + tableName + " ON biz_project_management.ID_ = " + tableName + ".PROJECT_ID_ ";
                if (!this.haveColumn(tableName, "IS_DELE_")) continue;
                whereGroup = whereGroup + " AND " + tableName + ".IS_DELE_=0 ";
            }
            List<LinkedHashMap<String, Object>> fieldDataList = ((MenuFieldTempDao)this.baseMapper).getDataByIds(filedGroup, tableGroup, whereGroup, paramMap);
            if (null != fieldDataList && fieldDataList.size() > 0) {
                int j2 = fieldDataList.size();
                for (int i = 0; i < j2; ++i) {
                    LinkedHashMap<String, Object> stringObjectMap = fieldDataList.get(i);
                    Object[] arr = new Object[stringObjectMap.size() + 1];
                    int count = 1;
                    arr[0] = i + 1;
                    for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
                        String valueStr;
                        MenuCustomizeField menuCustomizeField = (MenuCustomizeField)((Object)dicFieldMap.get(count - 1));
                        if (entry.getKey().equals("CONTRACT_AMOUNT_") && entry.getValue() != null && StringUtils.isNotBlank((CharSequence)(valueStr = String.valueOf(entry.getValue())))) {
                            BigDecimal entryValue = new BigDecimal(valueStr);
                            entry.setValue(String.valueOf(entryValue.divide(new BigDecimal(10000), 2, 4)));
                        }
                        arr[count] = this.dataFormat(entry.getValue(), menuCustomizeField.getFieldTypeValue(), menuCustomizeField.getDicKey(), menuCustomizeField.getField());
                        ++count;
                    }
                    dataList.add(arr);
                }
            }
        }
        menuCustomizeVo.setDataList(dataList);
        menuCustomizeVo.setHeader(header);
        return menuCustomizeVo;
    }

    @Override
    @Transactional(readOnly=true)
    public MenuCustomizeVo getDataByIdss(MenuCustomizeParamVo menuCustomizeParamVo) {
        String id = menuCustomizeParamVo.getId();
        String queryProjectId = menuCustomizeParamVo.getProjectId();
        String projectType = menuCustomizeParamVo.getProjectType();
        String startMoney = menuCustomizeParamVo.getStartMoney();
        String endMoney = menuCustomizeParamVo.getEndMoney();
        String startTime = menuCustomizeParamVo.getStartTime();
        String endTime = menuCustomizeParamVo.getEndTime();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList<String> queryProjectIdList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)queryProjectId)) {
            paramMap.put("queryProjectId", null);
        } else {
            String[] split;
            for (String str : split = queryProjectId.split(",")) {
                queryProjectIdList.add("'" + str + "'");
            }
            paramMap.put("queryProjectId", queryProjectIdList);
        }
        paramMap.put("projectType", StringUtils.isBlank((CharSequence)projectType) ? null : "'" + projectType + "'");
        paramMap.put("startMoney", StringUtils.isBlank((CharSequence)startMoney) ? null : "'" + startMoney + "'");
        paramMap.put("endMoney", StringUtils.isBlank((CharSequence)endMoney) ? null : "'" + endMoney + "'");
        paramMap.put("startTime", StringUtils.isBlank((CharSequence)startTime) ? null : "'" + startTime + "'");
        paramMap.put("endTime", StringUtils.isBlank((CharSequence)endTime) ? null : "'" + endTime + "'");
        MenuCustomizeVo menuCustomizeVo = new MenuCustomizeVo();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<String> header = new ArrayList<String>();
        MenuFieldTemp menuFieldTemp = (MenuFieldTemp)((Object)((MenuFieldTempDao)this.baseMapper).selectById((Serializable)((Object)id)));
        paramMap.put("queryProjectId", queryProjectIdList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID_", new Object[]{id});
        queryWrapper.orderByAsc((Object)"SN_");
        List menuCustomizeFieldList = this.menuCustomizeFieldManager.list((Wrapper)queryWrapper);
        menuFieldTemp.setMenuCustomizeFieldList(menuCustomizeFieldList);
        header.add("\u5e8f\u53f7");
        String filedGroup = "";
        ArrayList<String> set = new ArrayList<String>();
        String tableGroup = "";
        String whereGroup = " WHERE 1=1 ";
        HashMap<String, Boolean> haveSubTableMap = new HashMap<String, Boolean>();
        LinkedHashMap<Integer, MenuCustomizeField> dicFieldMap = new LinkedHashMap<Integer, MenuCustomizeField>();
        if (null != menuCustomizeFieldList && menuCustomizeFieldList.size() > 0) {
            List<LinkedHashMap<String, Object>> fieldDataList;
            int i;
            ArrayList<Map<String, Object>> tableList = new ArrayList<Map<String, Object>>();
            boolean haveProjectTable = false;
            int j = menuCustomizeFieldList.size();
            for (i = 0; i < j; ++i) {
                String[] tableAndAlias;
                boolean haveProjectParam;
                MenuCustomizeField menuCustomizeField = (MenuCustomizeField)((Object)menuCustomizeFieldList.get(i));
                String head = menuCustomizeField.getFieldName();
                Integer calculationMethod = menuCustomizeField.getCalculationMethod();
                String tableName = menuCustomizeField.getTable();
                String fieldName = menuCustomizeField.getField();
                String project_id_ = null;
                String id_ = null;
                header.add(head);
                String whereSql = " WHERE 1=1 ";
                Boolean haveDel = this.haveColumn(tableName, "IS_DELE_");
                boolean haveSubTable = false;
                boolean bl = haveProjectParam = null != queryProjectIdList && queryProjectIdList.size() > 0;
                if (haveProjectParam) {
                    whereSql = "BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(tableName) ? whereSql + " AND ID_ IN( " + String.join((CharSequence)",", queryProjectIdList) + ")" : whereSql + " AND PROJECT_ID_ IN( " + String.join((CharSequence)",", queryProjectIdList) + ")";
                }
                if (haveDel.booleanValue()) {
                    whereSql = whereSql + " AND " + tableName + ".IS_DELE_=0";
                }
                if (null != calculationMethod && calculationMethod == 2) {
                    String subTableAlias = tableName + "_" + fieldName;
                    String subTableName = "";
                    if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(tableName)) {
                        subTableName = " (SELECT SUM(" + fieldName + ") total,ID_ FROM " + tableName + whereSql + " group by ID_) " + subTableAlias;
                    } else {
                        String fiaryFieldName = fieldName;
                        if ("BIZ_CONTRACT".equalsIgnoreCase(tableName) && "CONTRACT_AMOUNT_".equalsIgnoreCase(fieldName)) {
                            fiaryFieldName = fieldName + "/10000";
                        }
                        subTableName = " (SELECT SUM(" + fiaryFieldName + ") total,PROJECT_ID_ FROM " + tableName + whereSql + " group by PROJECT_ID_) " + subTableAlias;
                    }
                    tableName = subTableName + "#" + subTableAlias;
                    haveSubTable = true;
                    haveSubTableMap.put(subTableName, haveSubTable);
                } else {
                    haveSubTableMap.put(tableName, haveSubTable);
                }
                HashMap<String, Object> tableNumMap = new HashMap<String, Object>();
                int num = ((MenuFieldTempDao)this.baseMapper).countNum(tableName, haveSubTable ? null : (haveDel != false ? "0" : null), haveSubTable ? null : project_id_, haveSubTable ? null : id_);
                tableNumMap.put("tableName", tableName);
                tableNumMap.put("num", num);
                tableList.add(tableNumMap);
                if (i == j - 1) {
                    if (null != calculationMethod && calculationMethod == 2) {
                        tableAndAlias = tableName.split("#");
                        filedGroup = filedGroup + tableAndAlias[1] + ".total";
                    } else {
                        filedGroup = filedGroup + tableName + "." + fieldName;
                    }
                } else if (null != calculationMethod && calculationMethod == 2) {
                    tableAndAlias = tableName.split("#");
                    filedGroup = filedGroup + tableAndAlias[1] + ".total" + ",";
                } else {
                    filedGroup = filedGroup + tableName + "." + fieldName + ",";
                }
                dicFieldMap.put(i, menuCustomizeField);
            }
            BizUtils.removeSame(tableList);
            Collections.sort(tableList, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Integer name1 = Integer.valueOf(o1.get("num").toString());
                    Integer name2 = Integer.valueOf(o2.get("num").toString());
                    return name2.compareTo(name1);
                }
            });
            j = tableList.size();
            for (i = 0; i < j; ++i) {
                Map<String, Object> stringIntegerMap = tableList.get(i);
                set.add(String.valueOf(stringIntegerMap.get("tableName")));
            }
            int index = 1;
            String firstTable = "";
            for (String tableName : set) {
                Boolean haveSubTable = (Boolean)haveSubTableMap.get(tableName);
                String[] tableAndAlias = tableName.split("#");
                String subTableAlias = tableName;
                if (tableAndAlias.length > 1) {
                    tableName = tableAndAlias[0];
                    subTableAlias = tableAndAlias[1];
                }
                Boolean haveSub = null == haveSubTable ? false : haveSubTable;
                String tableFiledSql = subTableAlias + ".PROJECT_ID_ ";
                if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(subTableAlias)) {
                    tableFiledSql = subTableAlias + ".ID_";
                }
                if (index == 1) {
                    tableGroup = "select " + filedGroup + " from " + tableName;
                    if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(subTableAlias)) {
                        firstTable = subTableAlias + ".ID_";
                        if (!haveSub.booleanValue() && null != queryProjectIdList && queryProjectIdList.size() > 0) {
                            whereGroup = whereGroup + " AND ID_ IN( " + String.join((CharSequence)",", queryProjectIdList) + ")";
                        }
                        haveProjectTable = true;
                    } else {
                        firstTable = subTableAlias + ".PROJECT_ID_ ";
                        if (null != haveSubTable && !haveSubTable.booleanValue() && null != queryProjectIdList && queryProjectIdList.size() > 0) {
                            whereGroup = whereGroup + " AND " + firstTable + " IN( " + String.join((CharSequence)",", queryProjectIdList) + ")";
                        }
                    }
                } else if ("BIZ_PROJECT_MANAGEMENT".equalsIgnoreCase(subTableAlias)) {
                    tableGroup = tableGroup + " LEFT JOIN " + tableName + " ON " + tableName + ".ID_ = " + firstTable;
                    haveProjectTable = true;
                } else {
                    tableGroup = tableGroup + " LEFT JOIN " + tableName + " ON " + tableFiledSql + " = " + firstTable;
                }
                Boolean isDel = this.haveColumn(tableName, "IS_DELE_");
                if (null != haveSubTable && !haveSubTable.booleanValue() && isDel.booleanValue()) {
                    whereGroup = whereGroup + " AND (" + tableName + ".IS_DELE_=0 OR ISNULL(" + tableName + ".IS_DELE_))";
                }
                ++index;
            }
            if (!haveProjectTable) {
                tableGroup = tableGroup + " LEFT JOIN biz_project_management ON biz_project_management.ID_ = " + firstTable;
            }
            if (null != (fieldDataList = ((MenuFieldTempDao)this.baseMapper).getDataByIdss(tableGroup, whereGroup, paramMap)) && fieldDataList.size() > 0) {
                int j2 = fieldDataList.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    LinkedHashMap<String, Object> stringObjectMap = fieldDataList.get(i2);
                    Object[] arr = new Object[stringObjectMap.size() + 1];
                    int count = 1;
                    arr[0] = i2 + 1;
                    for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
                        MenuCustomizeField menuCustomizeField = (MenuCustomizeField)((Object)dicFieldMap.get(count - 1));
                        arr[count] = this.dataFormat(entry.getValue(), menuCustomizeField.getFieldTypeValue(), menuCustomizeField.getDicKey(), menuCustomizeField.getField());
                        ++count;
                    }
                    dataList.add(arr);
                }
            }
        }
        menuCustomizeVo.setDataList(dataList);
        menuCustomizeVo.setHeader(header);
        return menuCustomizeVo;
    }

    @Override
    public void exportDataToExcel(MenuCustomizeParamVo menuCustomizeParamVo, HttpServletResponse response) throws IOException {
        String fileName = "\u81ea\u5b9a\u4e49\u53f0\u8d26\u5bfc\u51fa\u7ed3\u679c";
        MenuCustomizeVo vo = this.getDataByIdss(menuCustomizeParamVo);
        List<String> headers = vo.getHeader();
        List<Object[]> data = vo.getDataList();
        HSSFWorkbook wookbook = new HSSFWorkbook();
        HSSFSheet sheet = wookbook.createSheet(fileName);
        HSSFCellStyle style = wookbook.createCellStyle();
        HSSFFont font = wookbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        style.setFont(font);
        AtomicInteger headCounter = new AtomicInteger();
        HSSFRow head = sheet.createRow(0);
        headers.forEach(h -> {
            BizUtils.handelCell(wookbook, style, fileName, head.createCell(headCounter.get()), h, true);
            headCounter.getAndIncrement();
        });
        AtomicInteger dataCounter = new AtomicInteger(1);
        data.forEach(d -> {
            HSSFRow dataRow = sheet.createRow(dataCounter.get());
            AtomicInteger valueCounter = new AtomicInteger();
            for (Object value : d) {
                Pattern pattern = Pattern.compile("(-?\\d+\\.?\\d*)[Ee]{1}[\\+-]?[0-9]*");
                if (value != null && pattern.matcher(String.valueOf(value)).matches()) {
                    DecimalFormat df = new DecimalFormat("0.00");
                    value = df.format(Double.parseDouble(String.valueOf(value))).trim();
                }
                BizUtils.handelCell(wookbook, style, fileName, dataRow.createCell(valueCounter.get()), null == value ? "" : value.toString(), new boolean[0]);
                valueCounter.getAndIncrement();
            }
            dataCounter.getAndIncrement();
        });
        sheet.setColumnWidth(0, 1800);
        for (int i = 1; i < headers.size(); ++i) {
            sheet.setColumnWidth(i, 4800);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)wookbook, (String)fileName, (HttpServletResponse)response);
    }

    public Object dataFormat(Object o, String type, String dicKey, String field) {
        if (null == o) {
            return "";
        }
        SimpleDateFormat sdy = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfsfm = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if ("1".equals(type)) {
            // empty if block
        }
        if ("2".equals(type)) {
            // empty if block
        }
        if ("3".equals(type) || o instanceof Double) {
            DecimalFormat df = new DecimalFormat("0.00");
            return df.format(Double.parseDouble(String.valueOf(o))).trim();
        }
        if ("4".equals(type) && o instanceof BigDecimal) {
            return ((BigDecimal)o).stripTrailingZeros().toPlainString();
        }
        if ("5".equals(type)) {
            if (o instanceof Date) {
                return sdf.format((Date)o);
            }
            if (o instanceof LocalDate) {
                return o;
            }
        }
        if ("6".equals(type)) {
            if (o instanceof Date) {
                return sdfsfm.format((Date)o);
            }
            if (o instanceof LocalDateTime) {
                return o;
            }
            if (o instanceof LocalDate) {
                LocalDate d = (LocalDate)o;
                return d.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00";
            }
        }
        if ("9".equals(type)) {
            if (o instanceof Date) {
                return sdy.format((Date)o);
            }
            if (o instanceof LocalDate) {
                LocalDate d = (LocalDate)o;
                return d.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            }
        }
        if ("7".equals(type)) {
            // empty if block
        }
        if ("8".equals(type) && ObjectUtils.isNotEmpty((Object)o) && StringUtils.isNotBlank((CharSequence)dicKey)) {
            List decisionType = this.sdm.queryDictListItemsByCode(dicKey);
            if ("DECISION_BASIS_TYPE_".equalsIgnoreCase(field)) {
                String[] str = String.valueOf(o).split(",");
                ArrayList<String> val = new ArrayList<String>(str.length);
                for (String s : str) {
                    val.add(BizUtils.getDicValueByCode((List<DictModel>)decisionType, String.valueOf(s)));
                }
                return String.join((CharSequence)",", val);
            }
            return BizUtils.getDicValueByCode((List<DictModel>)decisionType, String.valueOf(o));
        }
        return o;
    }

    public void splicingData(List<Map<String, Object>> result, List<Map<String, Object>> dataList, MenuCustomizeField menuCustomizeField) {
    }

    @Override
    public List<String> getColumnByTable(String tableNmae) {
        return ((MenuFieldTempDao)this.baseMapper).getColumnByTable(tableNmae);
    }

    @Override
    public boolean haveColumn(String tableNmae, String column) {
        if (StringUtils.isBlank((CharSequence)tableNmae) || StringUtils.isBlank((CharSequence)column)) {
            return false;
        }
        List<String> columnByTable = this.getColumnByTable(tableNmae);
        if (null != columnByTable && columnByTable.size() > 0) {
            return columnByTable.contains(column.toUpperCase());
        }
        return false;
    }
}

