/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.designEstimate.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.designEstimate.dao.GeologicalProspectingDao;
import com.artfess.cqxy.designEstimate.manager.GeologicalProspectingManager;
import com.artfess.cqxy.designEstimate.model.GeologicalProspecting;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GeologicalProspectingManagerImpl
extends BaseManagerImpl<GeologicalProspectingDao, GeologicalProspecting>
implements GeologicalProspectingManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(GeologicalProspecting entity) {
        entity.setIsDele("0");
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eight.getCode());
            ele.setGroup("GeologicalProspecting");
            ele.setNode(ProjectStatusEnum.eight.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.six.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, GeologicalProspecting entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.ten.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.ten.getName());
        globalRetrieval.setBizTableName(FunctionEnum.ten.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.ten.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.ten.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.ten.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public GeologicalProspecting getById(String id) {
        GeologicalProspecting result = ((GeologicalProspectingDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<GeologicalProspecting> queryAllByPage(QueryFilter<GeologicalProspecting> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bgp", "pm");
        IPage<GeologicalProspecting> result = ((GeologicalProspectingDao)this.baseMapper).queryAllByPage((IPage<GeologicalProspecting>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<GeologicalProspecting>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (GeologicalProspecting ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                GeologicalProspecting data = new GeologicalProspecting();
                data.setDocumentNumber(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                data.setGeologicalProspectingUnit(null == row.getCell(2) ? row.createCell(2).getStringCellValue() : row.getCell(2).getStringCellValue());
                if (null != row.getCell(3)) {
                    String dateValue = row.getCell(3).getStringCellValue();
                    data.setProspectingDate(LocalDate.parse(dateValue));
                }
                data.setConstructionScale(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setEstablishmentRemarks(null == row.getCell(5) ? row.createCell(5).getStringCellValue() : row.getCell(5).getStringCellValue());
                data.setProjectId(projectId);
                this.saveOrUpdate(data);
                this.handleRetrieval(new GlobalRetrieval(), data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<GeologicalProspecting> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8bbe\u8ba1\u6982\u7b97-\u5730\u52d8-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bgp", "pm");
        List data = ((GeologicalProspectingDao)this.baseMapper).queryAllByPage((IPage<GeologicalProspecting>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<GeologicalProspecting>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, GeologicalProspecting.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

