package com.artfess.report.bigScreen.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.report.bigScreen.manager.BladeVisualMapManager;
import com.artfess.report.bigScreen.model.BladeVisualMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 可视化地图配置表 前端控制器
 *
 * @author 王平
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@RestController
@RequestMapping("/bigScreen/bladeVisualMap/v1")
@Api(tags = "可视化地图配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class BladeVisualMapController extends BaseController<BladeVisualMapManager, BladeVisualMap> {
    @Resource
    BladeVisualMapManager bladeVisualMapManager;

    /**
     * 可视化地图配置明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "可视化地图配置详情", httpMethod = "GET", notes = "可视化地图配置详情")
    public BladeVisualMap get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bladeVisualMapManager.get(id);
    }

    /**
     * 新增消息发送日志
     *
     * @param
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新可视化地图配置", httpMethod = "POST", notes = "新增,更新可视化地图配置")
    public CommonResult<String> save(@ApiParam(name = "BladeVisualMap", value = "可视化地图配置对象", required = true) @RequestBody BladeVisualMap BladeVisualMap) throws Exception {
        String msg = "添加可视化地图配置成功";
        if (StringUtil.isEmpty(BladeVisualMap.getId())) {
            bladeVisualMapManager.create(BladeVisualMap);
        } else {
            bladeVisualMapManager.update(BladeVisualMap);
            msg = "更新可视化地图配置成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除消息发送日志记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除可视化地图配置", httpMethod = "DELETE", notes = "删除可视化地图配置")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        bladeVisualMapManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

}
