/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.webSocket;

import com.artfess.base.webSocket.HeartBeatHandler;
import com.artfess.base.webSocket.WebSocketHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NettyServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private static final String WEBSOCKET_PROTOCOL = "websocket";
    @Value(value="${webSocket.netty.port:8099}")
    private int port;
    @Value(value="${webSocket.netty.path:/websocket}")
    private String webSocketPath;
    @Autowired
    private WebSocketHandler webSocketHandler;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workGroup;

    private void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group(this.bossGroup, this.workGroup);
            bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.localAddress((SocketAddress)new InetSocketAddress(this.port));
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler("info")});
                    ch.pipeline().addLast(new ChannelHandler[]{new ObjectEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(7000L, 7000L, 11L, TimeUnit.SECONDS)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HeartBeatHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettyServer.this.webSocketPath, NettyServer.WEBSOCKET_PROTOCOL, true, 655360)});
                    ch.pipeline().addLast(new ChannelHandler[]{NettyServer.this.webSocketHandler});
                }
            });
            ChannelFuture channelFuture = bootstrap.bind().sync();
            log.info("NettyServer started and listen on:{}", (Object)channelFuture.channel().localAddress());
            channelFuture.channel().closeFuture().sync();
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workGroup.shutdownGracefully();
        }
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully().sync();
        }
        if (this.workGroup != null) {
            this.workGroup.shutdownGracefully().sync();
        }
    }

    @PostConstruct
    public void init() {
        new Thread(() -> {
            try {
                this.start();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }
}

