package com.artfess.cqxy.warranty.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.warranty.entity.Warranty;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * (Warranty)表服务接口
 *
 * @author 黎沐华
 * @since 2022-06-01 15:00:58
 */
public interface WarrantyManager extends BaseManager<Warranty> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<Warranty> queryFilter, HttpServletResponse response) throws IOException;

    boolean deleteByIds(List<String> asList);

    Warranty getById(String id);

    PageList<Warranty> queryAllByPage(QueryFilter<Warranty> queryFilter);
}

