package com.artfess.cqxy.projectManagement.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.artfess.cqxy.projectManagement.dao.ProjectPersonnelDao;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 项目人员中间表(BizProjectPersonnel)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
@Service
public class ProjectPersonnelManagerImpl extends BaseManagerImpl<ProjectPersonnelDao, ProjectPersonnel> implements ProjectPersonnelManager {

    @Override
    public PageList<ProjectPersonnelVo> queryAllByPage(QueryFilter<ProjectPersonnel> queryFilter) {
        // 限制项目ID不能为空
        String projectId = null;
        List<QueryField> test = queryFilter.getQuerys();
        for (QueryField ele : test){
            if("pp.PROJECT_ID_".equals(ele.getProperty())) {
                projectId = String.valueOf(ele.getValue());
                break;
            }
        }
        Assert.notNull(projectId,"项目ID不能为空");
        queryFilter.addFilter("uc.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("pp.IS_DELE_","0", QueryOP.EQUAL);
        IPage<ProjectPersonnelVo> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<ProjectPersonnelVo>(result);
    }

    @Override
    public List<ProjectPersonnelVo> getAllUsers(String projectId) {
        return baseMapper.getAllUsers(projectId);
    }

    @Async
    @Override
    public void linkUsers(String projectId) {
        List<ProjectPersonnelVo> vo = getAllUsers("");
        List<ProjectPersonnel> personnels = new ArrayList<>();
        for (ProjectPersonnelVo ele:vo) {
            ProjectPersonnel temp = new ProjectPersonnel();
            temp.setProjectId(projectId);
            temp.setPersonnelId(ele.getPersonnelId());
            personnels.add(temp);
        }
        saveBatch(personnels);
    }

    @Async
    @Override
    public void linkUsersByProjectManager(String projectId, String projectManagerId) {
        if(StringUtils.isBlank(projectManagerId) || StringUtils.isBlank(projectId)){
            return;
        }
        ProjectPersonnel temp = new ProjectPersonnel();
        temp.setProjectId(projectId);
        temp.setPersonnelId(projectManagerId);
        int index = projectManagerId.indexOf(",");
        if(-1 == index){
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("PROJECT_ID_",projectId);
            queryWrapper.eq("PERSONNEL_ID_",projectManagerId);
            Integer count = baseMapper.selectCount(queryWrapper);
            if(count < 1){
                baseMapper.insert(temp);
            }
        }else {
            String[] projectManagerIds = projectManagerId.split(",");
            for(String personId : projectManagerIds){
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq("PROJECT_ID_", projectId);
                queryWrapper.eq("PERSONNEL_ID_", personId);
                Integer count = baseMapper.selectCount(queryWrapper);
                if(count < 1){
                    baseMapper.insert(temp);
                }
            }
        }



    }


    @Override
    public ProjectPersonnelVo getVoById(String id) {
        return baseMapper.getVoById(id);
    }

    @Override
    public boolean batchSaveData(ProjectPersonnel perObject) {
        List<String> ids = Arrays.asList(perObject.getPersonnelId().split(","));
        List<ProjectPersonnel> dataList = new ArrayList<>();
        for (String ele : ids) {
            ProjectPersonnel temp = new ProjectPersonnel(perObject.getProjectId(), ele);
            dataList.add(temp);
        }
        Boolean result = saveBatch(dataList);
        return result;
    }

    @Override
    public List<String> getProjectPersonnelByProjectId(String projectId) {

        return baseMapper.getProjectPersonnelByProjectId(projectId);
    }

    @Override
    public List<String> getProjectByPersonnelId(String personnelId) {

        return baseMapper.getProjectByPersonnelId(personnelId);
    }



}

