package com.artfess.cqxy.designEstimate.dao;

import com.artfess.cqxy.designEstimate.model.Estimate;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 设计概算 - 概算表(BizEstimate)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-15 17:29:48
 */
public interface EstimateDao extends BaseMapper<Estimate> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    Estimate getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<Estimate> queryAllByPage(IPage<Estimate> convert2IPage, @Param(Constants.WRAPPER) Wrapper<Estimate> convert2Wrapper);

    BigDecimal getEstimate(@Param("pid") String pid, @Param("year") String year);
}

