/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectApproval.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectApproval.manager.DecisionAnnualPlanManager;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5e74\u5ea6\u8ba1\u5212\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/projectApproval/decisionBasis/decisionAnnualPlan/v1"})
public class DecisionAnnualPlanController
extends BaseController<DecisionAnnualPlanManager, DecisionAnnualPlan> {
    private static final Logger log = LoggerFactory.getLogger(DecisionAnnualPlanController.class);

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult<String> insert(@RequestBody DecisionAnnualPlan decisionAnnualPlan) {
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)decisionAnnualPlan);
        String msg = "\u6dfb\u52a0";
        if (StringUtils.isNotBlank((CharSequence)decisionAnnualPlan.getId())) {
            msg = "\u4fee\u6539";
        }
        boolean save = ((DecisionAnnualPlanManager)this.baseService).saveOrUpdate((Object)decisionAnnualPlan);
        msg = msg + (save ? "\u6210\u529f" : "\u5931\u8d25");
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(save, msg);
    }

    @PostMapping(value={"/importExcelData"})
    @ApiOperation(value="S-\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e")
    public CommonResult importExcelData(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, String projectId) {
        log.debug("\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)file, (Object)projectId);
        ((DecisionAnnualPlanManager)this.baseService).importExcelData(file, projectId);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981\uff0c\u67e5\u8be2\u6761\u4ef6\u8981\u5e26\u4e0a\u8868\u522b\u540d\uff1a\u4e3b\u8868 bdap\u3001\u526f\u8868 pm\uff1b\u4f20\u5165pm.ID_\u5bfc\u51fa\u8be5\u9879\u76ee\u4e0b\u7684\u6570\u636e\uff0c\u5426\u5219\u5c06\u5bfc\u51fa\u6240\u6709\u6570\u636e")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<DecisionAnnualPlan> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        ((DecisionAnnualPlanManager)this.baseService).exportDatatoExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u5220\u9664\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((DecisionAnnualPlanManager)this.baseService).deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<DecisionAnnualPlan> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)id);
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        DecisionAnnualPlan result = ((DecisionAnnualPlanManager)this.baseService).getById(id);
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u4f20\u5165 PROJECT_ID_ \u9879\u76eeID \u4ee5\u5207\u6362\u9879\u76ee\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014\u4e3b\u8868\u4e3abdap\u3001\u526f\u8868\u4e3apm", httpMethod="POST")
    public CommonResult<PageList<DecisionAnnualPlan>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<DecisionAnnualPlan> queryFilter) {
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<DecisionAnnualPlan> result = ((DecisionAnnualPlanManager)this.baseService).queryAllByPage(queryFilter);
        log.debug("\u51b3\u7b56\u4f9d\u636e-\u5e74\u5ea6\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/updateProjectIdByProiectId"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeid\u4fee\u6539\u9879\u76eeid", notes="\u6309\u7167\u9879\u76ee", httpMethod="POST")
    public CommonResult<String> updateProjectIdByProiectId(@ApiParam(name="oldProjectIds", value="\u88ab\u4fee\u6539\u7684\u9879\u76eeID") String oldProjectIds, @ApiParam(name="newProjectId", value="\u9700\u8981\u4fee\u6539\u7684\u9879\u76eeID") String newProjectId) {
        ((DecisionAnnualPlanManager)this.baseService).updateProjectIdByProiectId(oldProjectIds, newProjectId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }
}

