/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.dao.ProjectStartDao;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectStartManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.projectManagement.model.ProjectStart;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProjectStartManagerImpl
extends BaseManagerImpl<ProjectStartDao, ProjectStart>
implements ProjectStartManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(ProjectStart entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.three.getCode());
            ele.setGroup("ProjectStart");
            ele.setNode(ProjectStatusEnum.three.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.three.getCode()));
        if (StringUtils.isNotBlank((CharSequence)entity.getProjectId())) {
            ProjectManagement pm = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
            if (null != entity.getStartDate()) {
                pm.setCommencementTime(entity.getStartDate());
            }
            this.pmm.updateById((Object)pm);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProjectStart entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.four.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.four.getName());
        globalRetrieval.setBizTableName(FunctionEnum.four.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.four.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.four.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.four.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocunemtNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getProjectName() + "_" + entity.getProjectManager() + "_" + entity.getRemarks() + "_" + entity.getMainEngineer());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public ProjectStart getById(String id) {
        ProjectStart result = ((ProjectStartDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<ProjectStart> queryAllByPage(QueryFilter<ProjectStart> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bps", "pm");
        IPage<ProjectStart> result = ((ProjectStartDao)this.baseMapper).queryAllByPage((IPage<ProjectStart>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectStart>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ProjectStart ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProjectStart> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u9879\u76ee\u5f00\u5de5-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bps", "pm");
        List data = ((ProjectStartDao)this.baseMapper).queryAllByPage((IPage<ProjectStart>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ProjectStart>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ProjectStart.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, ProjectStart.class, (ImportParams)new ImportParams());
            for (ProjectStart ele : data) {
                ele.setProjectId(projectId);
                ele.setProjectName(((ProjectManagement)this.pmm.get((Serializable)((Object)projectId))).getProjectName());
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

