/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import com.artfess.cqxy.processManagermant.vo.ProgressManageTotalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u65bd\u5de5\u7ba1\u7406-\u8fdb\u5ea6\u7ba1\u7406-\u5de5\u7a0b\u652f\u4ed8\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/processManagement/progressManage/v1"})
public class ProgressManageController
extends BaseController<ProgressManageManager, ProgressManage> {
    private static final Logger log = LoggerFactory.getLogger(ProgressManageController.class);

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult<ProgressManage> insert(@RequestBody ProgressManage progressManage) {
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)progressManage);
        Assert.notNull((Object)progressManage.getProjectId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        boolean save = ((ProgressManageManager)this.baseService).saveOrUpdateEntity(progressManage);
        return new CommonResult(true, "\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01", (Object)progressManage);
    }

    @PostMapping(value={"/importExcelData"})
    @ApiOperation(value="S-\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e")
    public CommonResult importExcelData(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, @ApiParam(value="\u9879\u76eeID") @RequestParam(value="projectId") String projectId, @ApiParam(value="\u5408\u540cID") @RequestParam(value="contractId") String contractId) {
        log.debug("\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{file, projectId, contractId});
        ((ProgressManageManager)this.baseService).importExcelData(file, projectId, contractId);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981\uff0c\u67e5\u8be2\u6761\u4ef6\u8981\u5e26\u4e0a\u8868\u522b\u540d\uff1a\u4e3b\u8868 bcm\u3001\u526f\u8868 pm\uff1b\u4f20\u5165pm.ID_\u5bfc\u51fa\u8be5\u9879\u76ee\u4e0b\u7684\u6570\u636e\uff0c\u5426\u5219\u5c06\u5bfc\u51fa\u6240\u6709\u6570\u636e")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProgressManage> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        ((ProgressManageManager)this.baseService).exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @GetMapping(value={"/exportApprovalForm"})
    @ApiOperation(value="S-\u5bfc\u51fa\u9879\u76ee\u62e8\uff08\u4ed8\uff09\u6b3e\u7533\u8bf7\u5ba1\u6279\u5355", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u4f20\u5165\u6570\u636eID\uff0c\u5bfc\u51fa\u5bf9\u5e94\u7684\u5ba1\u6279\u5355")
    public CommonResult exportApprovalForm(@ApiParam(name="id", value="\u6570\u636eID") @RequestParam String id, HttpServletResponse response) throws IOException {
        Assert.notNull((Object)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ((ProgressManageManager)this.baseService).exportApprovalForm(id, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u5220\u9664\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((ProgressManageManager)this.baseService).deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<ProgressManage> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)id);
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ProgressManage result = ((ProgressManageManager)this.baseService).getById(id);
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u67e5\u8be2\u6761\u4ef6\u8981\u5e26\u4e0a\u8868\u522b\u540d\uff1a\u4e3b\u8868-\u8fdb\u5ea6\u7ba1\u7406\u4fe1\u606f bcm\u3001\u526f\u8868-\u9879\u76ee\u4fe1\u606f pm\u3001\u526f\u8868-\u5408\u540c\u4fe1\u606f bc\uff1b\u4f20\u5165pm.ID_ \u9879\u76eeID \u4ee5\u5207\u6362\u9879\u76ee", httpMethod="POST")
    public CommonResult<PageList<ProgressManage>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProgressManage> queryFilter) {
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<ProgressManage> result = ((ProgressManageManager)this.baseService).queryAllByPage(queryFilter);
        log.debug("\u8fdb\u5ea6\u7ba1\u7406-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/getAppropriatedl"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u83b7\u53d6\u5df2\u62e8\u6b3e\u989d(\u83b7\u53d6\u6240\u6709\u7528\u9014\u7684\u5df2\u62e8\u6b3e)", httpMethod="POST")
    public CommonResult<BigDecimal> getAppropriatedl(@ApiParam(name="appropriatedlVo", value="\u5df2\u62e8\u6b3e\u989d\u67e5\u8be2\u53c2\u6570VO") @RequestBody AppropriatedlVo appropriatedlVo) {
        Assert.notNull((Object)appropriatedlVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)appropriatedlVo.getProjectId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BigDecimal result = ((ProgressManageManager)this.baseService).getAmountAppropriatedl(appropriatedlVo);
        return new CommonResult(true, "\u5df2\u62e8\u6b3e\u989d\u67e5\u8be2\u6210\u529f", (Object)result.stripTrailingZeros());
    }

    @PostMapping(value={"/getProgressManageTotalByProjectId"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u67e5\u8be2\u652f\u4ed8\u6c47\u603b\u6570\u636e\uff08\u67e5\u770b\u754c\u9762\uff09", httpMethod="POST")
    public CommonResult<ProgressManageTotalVo> getProgressManageTotalByProjectId(@ApiParam(name="progressManageTotalVo", value="\u6839\u636e\u9879\u76eeID\u67e5\u8be2\u652f\u4ed8\u6c47\u603b\u6570\u636e\u53c2\u6570VO") @RequestBody ProgressManageTotalVo progressManageTotalVo) {
        Assert.notNull((Object)progressManageTotalVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)progressManageTotalVo.getProjectId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", (Object)((ProgressManageManager)this.baseService).getProgressByProjectId(progressManageTotalVo));
    }

    @GetMapping(value={"/getProgressManageByProjectId/{projectId}"})
    @ApiOperation(value="S-\u6839\u636e\u9879\u76eeID\u67e5\u8be2\u6709\u6536\u6b3e\u5355\u4f4d\u3001\u8d26\u53f7\u3001\u5f00\u6237\u884c\u7684\u652f\u4ed8\u5355\u5b50\uff09", httpMethod="GET")
    public CommonResult<ProgressManage> getProgressManageByProjectId(@ApiParam(name="projectId", value="\u9879\u76eeID") @PathVariable String projectId) {
        Assert.notNull((Object)projectId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", (Object)((ProgressManageManager)this.baseService).getProgressManageByProjectId(projectId));
    }

    @PostMapping(value={"/recalManage"})
    @ApiOperation(value="\u591a\u7ebf\u7a0b\u91cd\u7b97\u5de5\u7a0b\u652f\u4ed8", httpMethod="POST")
    public void recalManage(String projectId) {
        ((ProgressManageManager)this.baseService).recalManage(projectId);
    }
}

