/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.controller;

import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.manager.InvestmentLedgerManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f0\u8d26-\u6295\u8d44\u8fdb\u5ea6\u53f0\u8d26\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/ledger/investment/v1"})
public class InvestmentLedgerController {
    private static final Logger log = LoggerFactory.getLogger(InvestmentLedgerController.class);
    @Autowired
    private InvestmentLedgerManager manager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u4f7f\u7528\u9879\u76ee\u67e5\u8be2\u5668\uff0cXX\u5e74\u9879\u76ee\u5373\u5f00\u5de5\u65f6\u95f4\u4e3a YEAR(COMMENCEMENT_TIME_)", httpMethod="POST")
    public CommonResult<Map<String, Object>> page(@ApiParam(name="queryFilter", value="\u9879\u76ee\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        Map<String, Object> result = this.manager.queryByPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u4f7f\u7528\u9879\u76ee\u67e5\u8be2\u5668\uff0cXX\u5e74\u9879\u76ee\u5373\u5f00\u5de5\u65f6\u95f4\u4e3a YEAR(COMMENCEMENT_TIME_)")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception {
        this.manager.exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/yearTotalInvest"})
    @ApiOperation(value="S-\u5e74\u5ea6\u603b\u6295\u8d44", notes="\u4f20\u5165\u5e74\u4efd year")
    public CommonResult yearTotalInvest(@ApiParam(name="year", value="\u7edf\u8ba1\u5e74\u4efd") @RequestParam Integer year) {
        JSONObject result = this.manager.yearTotalInvest(year);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/totalInvestByYear"})
    @ApiOperation(value="S-\u5e74\u5ea6\u603b\u6295\u8d44", notes="\u4f20\u5165\u5e74\u4efd year")
    public CommonResult totalInvestByYear(@ApiParam(name="year", value="\u7edf\u8ba1\u5e74\u4efd") @RequestParam Integer year) {
        BigDecimal result = this.manager.totalInvestByYear(year);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }
}

