/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.bidManagement.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.dao.BidManagementDao;
import com.artfess.cqxy.bidManagement.manager.BidManagementManager;
import com.artfess.cqxy.bidManagement.model.BidManagement;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BidManagementManagerImpl
extends BaseManagerImpl<BidManagementDao, BidManagement>
implements BidManagementManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private ProjectManagementManager pmm;

    public boolean saveOrUpdate(BidManagement entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eight.getCode());
            ele.setGroup("BidManagement");
            ele.setNode(ProjectStatusEnum.eight.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eight.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, BidManagement entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirteen.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getTenderee() + "_" + entity.getBiddingAgency() + "_" + entity.getBiddingRange() + "_" + entity.getProjectOverview());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public BidManagement getById(String id) {
        BidManagement result = ((BidManagementDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<BidManagement> queryAllByPage(QueryFilter<BidManagement> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bbm0", "pm");
        IPage<BidManagement> result = ((BidManagementDao)this.baseMapper).queryAllByPage((IPage<BidManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BidManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (BidManagement ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List bidOf = this.sdm.queryDictListItemsByCode("tbgl-sfzb");
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                BidManagement data = new BidManagement();
                data.setDocumentNumber(null == row.getCell(0) ? row.createCell(0).getStringCellValue() : row.getCell(0).getStringCellValue());
                data.setProjectOverview(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                data.setTenderee(null == row.getCell(2) ? row.createCell(2).getStringCellValue() : row.getCell(2).getStringCellValue());
                data.setBiddingChargePerson(null == row.getCell(3) ? row.createCell(3).getStringCellValue() : row.getCell(3).getStringCellValue());
                data.setBiddingAgency(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setBiddingDate(null == row.getCell(5) ? row.createCell(5).getDateCellValue() : row.getCell(5).getDateCellValue());
                data.setBiddingFixedPrice(null == row.getCell(6) ? row.createCell(6).getStringCellValue() : row.getCell(6).getStringCellValue());
                data.setBiddingRange(null == row.getCell(7) ? row.createCell(7).getStringCellValue() : row.getCell(7).getStringCellValue());
                data.setConstructionControlUnit(null == row.getCell(8) ? row.createCell(8).getStringCellValue() : row.getCell(8).getStringCellValue());
                data.setTestingUnit(null == row.getCell(9) ? row.createCell(9).getStringCellValue() : row.getCell(9).getStringCellValue());
                data.setPlannedConstructionPeriod(null == row.getCell(10) ? row.createCell(10).getStringCellValue() : row.getCell(10).getStringCellValue());
                data.setBidAmount(null == row.getCell(11) ? row.createCell(11).getStringCellValue() : row.getCell(11).getStringCellValue());
                data.setBidDate(null == row.getCell(12) ? row.createCell(12).getDateCellValue() : row.getCell(12).getDateCellValue());
                data.setEstablishmentRemarks(null == row.getCell(14) ? row.createCell(14).getStringCellValue() : row.getCell(14).getStringCellValue());
                data.setProjectId(projectId);
                data.setName(((ProjectManagement)this.pmm.get((Serializable)((Object)projectId))).getProjectName());
                ((BidManagementDao)this.baseMapper).insert((Object)data);
                this.handleRetrieval(new GlobalRetrieval(), data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<BidManagement> queryFilter, HttpServletResponse response) throws IOException {
        List bidOf = this.sdm.queryDictListItemsByCode("tbgl-sfzb");
        String fileName = "\u6295\u6807\u4fe1\u606f-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bbm0", "pm");
        List data = ((BidManagementDao)this.baseMapper).queryAllByPage((IPage<BidManagement>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BidManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (BidManagement ele : data) {
            ele.setBidOf(BizUtils.getDicValueByCode((List<DictModel>)bidOf, ele.getBidOf()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BidManagement.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

