/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.MessageFlow;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFlowParser
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)MessageFlowParser.class.getName());

    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String id = xtr.getAttributeValue(null, "id");
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            String messageRef;
            String targetRef;
            String sourceRef;
            MessageFlow messageFlow = new MessageFlow();
            messageFlow.setId(id);
            String name = xtr.getAttributeValue(null, "name");
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                messageFlow.setName(name);
            }
            if (StringUtils.isNotEmpty((CharSequence)(sourceRef = xtr.getAttributeValue(null, "sourceRef")))) {
                messageFlow.setSourceRef(sourceRef);
            }
            if (StringUtils.isNotEmpty((CharSequence)(targetRef = xtr.getAttributeValue(null, "targetRef")))) {
                messageFlow.setTargetRef(targetRef);
            }
            if (StringUtils.isNotEmpty((CharSequence)(messageRef = xtr.getAttributeValue(null, "messageRef")))) {
                messageFlow.setMessageRef(messageRef);
            }
            model.addMessageFlow(messageFlow);
        }
    }
}

