/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.HuaweiyunOssUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import org.springframework.stereotype.Service;

@Service
public class HuaweiyunObsAttachmentServiceImpl
implements AttachmentService {
    public String getStoreType() {
        return "huaweiObs";
    }

    private HwObsSetting initMinioSettings(Attachment attachment, String propertiesId) {
        HwObsSetting ossSettings = (HwObsSetting)AppUtil.getBean(HwObsSetting.class);
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FileStorageManager fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = (FileStorage)fileStorageManager.get((Serializable)((Object)propertiesId));
            if (BeanUtils.isNotEmpty((Object)((Object)fileStorage))) {
                ossSettings.setAk(fileStorage.getUserName());
                ossSettings.setSk(fileStorage.getPassword());
                ossSettings.setEndpoint(fileStorage.getEndpoint());
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(Boolean.valueOf(fileStorage.getEncryptName() != 0));
            }
        } else {
            FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
            FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
            if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                ossSettings.setAk(uploadProperties.getAccessKeyId());
                ossSettings.setSk(uploadProperties.getAccessKeySecret());
                ossSettings.setEndpoint(uploadProperties.getEndpoint());
                ossSettings.setBucketName(uploadProperties.getLocation());
                attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
            }
        }
        HuaweiyunOssUtil.setAk(ossSettings.getAk());
        HuaweiyunOssUtil.setSk(ossSettings.getSk());
        HuaweiyunOssUtil.setEndpoint(ossSettings.getEndpoint());
        HuaweiyunOssUtil.setBucketName(ossSettings.getBucketName());
        return ossSettings;
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        this.initMinioSettings(attachment, propertiesId);
        HuaweiyunOssUtil.deleteFile(fileName);
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        this.initMinioSettings(attachment, propertiesId);
        HuaweiyunOssUtil.uploadFile(fileName, inputStream);
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        this.initMinioSettings(attachment, propertiesId);
        HuaweiyunOssUtil.Download(fileName, outStream);
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        this.initMinioSettings(attachment, propertiesId);
        boolean b = HuaweiyunOssUtil.chekckFile(attachment.getFileName());
        return b;
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }
}

