/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelMenuManager;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelMenuVo;
import com.artfess.sysConfig.persistence.model.SysMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u7ba1\u7406-\u9879\u76ee\u4eba\u5458\u83dc\u5355\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/projectManagement/projectPersonnelMenu/v1"})
public class ProjectPersonnelMenuController {
    private static final Logger log = LoggerFactory.getLogger(ProjectPersonnelMenuController.class);
    @Resource
    private ProjectPersonnelMenuManager projectPersonnelMenuManager;

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6570\u636e", notes="\u7ea6\u5b9a\u53ef\u4ee5\u5c06\u591a\u4e2a\u4eba\u5458ID\u653e\u5230\u4e00\u4e2apersonnelId\u4e2d\uff0c\u4ee5\u82f1\u6587\u9017\u53f7\u9694\u5f00\uff0c\u540e\u7aef\u505a\u6279\u91cf\u65b0\u589e", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="dirObject", value="\u76ee\u5f55\u7ba1\u7406\u4fe1\u606f\u8868\u5bf9\u8c61") @RequestBody ProjectPersonnelMenuVo projectPersonnelMenuVo) {
        Assert.notNull((Object)projectPersonnelMenuVo, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.projectPersonnelMenuManager.create(projectPersonnelMenuVo);
        return new CommonResult(true, "\u83dc\u5355\u6388\u6743\u6210\u529f");
    }

    @RequestMapping(value={"/getAllMenuByProject"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u524d\u53f0\u6811\u5f62\u5168\u90e8\u83dc\u5355\uff08\u7528\u4e8e\u6388\u6743\u83dc\u5355\u65f6\u4f7f\u7528\uff09", httpMethod="GET", notes="\u6839\u636e\u9879\u76eeID\u548c\u7528\u6237\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355\uff08\u7528\u4e8e\u6388\u6743\u83dc\u5355\u65f6\u4f7f\u7528\uff09")
    public ArrayList<Map<String, Object>> getAllMenuRoleAlias(@ApiParam(name="projectId", value="\u9879\u76eeID", required=true) @RequestParam String projectId, @ApiParam(name="userId", value="\u4eba\u5458ID", required=true) @RequestParam String userId) throws Exception {
        return (ArrayList)this.projectPersonnelMenuManager.getAllMenuByProject(projectId, userId, null);
    }

    @RequestMapping(value={"/getCurrentUserMenuByProjectId"})
    @ApiOperation(value="\u6839\u636e\u9879\u76eeID\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355", httpMethod="POST", notes="\u6839\u636e\u9879\u76eeID\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getCurrentUserMenuByProjectId(@ApiParam(name="projectId", value="\u9879\u76eeID", required=true) @RequestParam String projectId) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u6839\u636e\u9879\u76eeID\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355");
        List<SysMenu> menuByProject = this.projectPersonnelMenuManager.getCurrentUserMenuByProject(projectId, "front_menu");
        commonResult.setValue(menuByProject);
        return commonResult;
    }
}

