/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.completionAcceptance.manager.RecordAcceptanceManager;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitManager;
import com.artfess.cqxy.constructionPermit.model.ConstructionPermit;
import com.artfess.cqxy.designEstimate.manager.ConstructionDrawingDesignManager;
import com.artfess.cqxy.designEstimate.manager.EstimateManager;
import com.artfess.cqxy.designEstimate.manager.PreliminaryDesignManager;
import com.artfess.cqxy.designEstimate.model.ConstructionDrawingDesign;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.designEstimate.model.PreliminaryDesign;
import com.artfess.cqxy.feasiblePlan.manager.FeasibilityStudyReplyManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningEngineeringManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningSelectionSiteManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningUseLandManager;
import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.artfess.cqxy.feasiblePlan.model.PlanningEngineering;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;
import com.artfess.cqxy.feasiblePlan.model.PlanningUseLand;
import com.artfess.cqxy.ledger.manager.ApprovalLedgerManager;
import com.artfess.cqxy.ledger.vo.ApprovalLedgerVo;
import com.artfess.cqxy.projectApproval.manager.ProjectEstablishmentManager;
import com.artfess.cqxy.projectApproval.model.ProjectEstablishment;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApprovalLedgerManagerImpl
implements ApprovalLedgerManager {
    @Autowired
    private ProjectManagementManager projectManager;
    @Autowired
    private ProjectEstablishmentManager establishmentManager;
    @Autowired
    private FeasibilityStudyReplyManager replyManager;
    @Autowired
    private EstimateManager estimateManager;
    @Autowired
    private PlanningSelectionSiteManager siteManager;
    @Autowired
    private PlanningUseLandManager useLandManager;
    @Autowired
    private PlanningEngineeringManager engineeringManager;
    @Autowired
    private PreliminaryDesignManager designManager;
    @Autowired
    private ConstructionDrawingDesignManager drawingManager;
    @Autowired
    ConstructionPermitManager permitManager;
    @Autowired
    private RecordAcceptanceManager recordManager;
    @Autowired
    private SysDictionaryManager sdm;

    @Override
    public Map<String, Object> queryByPage(QueryFilter<ProjectManagement> queryFilter) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        queryFilter.addFilter("PARENT_ID_", (Object)"root", QueryOP.EQUAL);
        PageList<ProjectManagement> project = this.projectManager.queryAllByPage(queryFilter);
        ArrayList<ProjectManagement> projectList = null == project.getRows() ? new ArrayList() : project.getRows();
        result.put("data", this.handleAppro(projectList));
        result.put("total", project.getTotal());
        result.put("page", project.getPage());
        result.put("pageSize", project.getPageSize());
        return result;
    }

    private List<ApprovalLedgerVo> handleAppro(List<ProjectManagement> projectList) {
        ArrayList<ApprovalLedgerVo> data = new ArrayList<ApprovalLedgerVo>();
        for (ProjectManagement ele : projectList) {
            ApprovalLedgerVo temp = new ApprovalLedgerVo();
            List projectStatus = this.sdm.queryDictListItemsByCode("xmgl-xmzt");
            temp.setProjectName(ele.getProjectName());
            temp.setCurrentProcedure(BizUtils.getDicValueByCode((List<DictModel>)projectStatus, ele.getProjectStatus()));
            temp.setProjectType(Integer.valueOf(ele.getProjectType()));
            List establishments = this.establishmentManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"}));
            String establishDT = "";
            if (BeanUtils.isNotEmpty((Object)establishments) && establishments.size() > 0) {
                for (ProjectEstablishment pe : establishments) {
                    if (!BeanUtils.isNotEmpty((Object)pe.getDocumentNumber())) continue;
                    if (establishments.indexOf((Object)pe) == 0) {
                        establishDT = pe.getDocumentNumber() + " " + BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate());
                        continue;
                    }
                    establishDT = establishDT + "\u3001" + pe.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate());
                }
            }
            temp.setEstablishDT(establishDT);
            FeasibilityStudyReply reply = (FeasibilityStudyReply)((Object)this.replyManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            FeasibilityStudyReply feasibilityStudyReply = reply = reply == null ? new FeasibilityStudyReply() : reply;
            temp.setFeasiblePlanDT(null == reply ? "" : (StringUtils.isBlank((CharSequence)reply.getDocumentNumber()) ? "" : reply.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(reply.getEstablishmentDate())));
            temp.setFeasiblePlanInfo(StringUtils.isBlank((CharSequence)reply.getEstablishmentInvestmentAmount()) ? "" : (StringUtils.isBlank((CharSequence)reply.getEstablishmentScale()) ? "" : reply.getEstablishmentScale() + "\u603b\u6295\u8d44\u4e3a" + reply.getEstablishmentInvestmentAmount() + "\u4e07\u5143\uff0c\u5efa\u5b89" + (StringUtils.isBlank((CharSequence)reply.getEngineeringCost()) ? "0" : reply.getEngineeringCost() + "\u4e07\u5143\u3002")));
            Estimate estimate = (Estimate)((Object)this.estimateManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            estimate = null == estimate ? new Estimate() : estimate;
            temp.setEstimateDT(StringUtils.isBlank((CharSequence)estimate.getDocumentNumber()) ? "" : estimate.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(estimate.getEstablishmentDate()));
            temp.setEstimateInfo(StringUtils.isBlank((CharSequence)estimate.getTotalEstimate()) ? "" : "\u603b\u6295\u8d44\u4e3a" + estimate.getTotalEstimate() + "\u4e07\u5143\uff0c\u5efa\u5b89" + (StringUtils.isBlank((CharSequence)estimate.getEngineeringCost()) ? "0" : estimate.getEngineeringCost()) + "\u4e07\u5143\u3002");
            PlanningSelectionSite site = (PlanningSelectionSite)((Object)this.siteManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).last("limit 1")));
            temp.setSiteDT(null == site ? "" : (StringUtils.isBlank((CharSequence)site.getDocumentNumber()) ? "" : site.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(site.getEstablishmentDate())));
            PlanningUseLand useLand = (PlanningUseLand)((Object)this.useLandManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            temp.setUseLandDT(null == useLand ? "" : (StringUtils.isBlank((CharSequence)useLand.getCode()) ? "" : useLand.getCode() + "  " + BizUtils.dateFormatChineseStyle(useLand.getEstablishmentDate())));
            temp.setUseLandCode(null == useLand ? "" : BizUtils.handleStringFormat(useLand.getCode()));
            PreliminaryDesign design = (PreliminaryDesign)((Object)this.designManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            design = null == design ? new PreliminaryDesign() : design;
            temp.setPreliminaryDesignDT(StringUtils.isBlank((CharSequence)design.getDocumentNumber()) ? "" : design.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(design.getEstablishmentDate()));
            List engineeringType = this.sdm.queryDictListItemsByCode("gcgh-lx");
            List planningEngineeringList = this.engineeringManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0"));
            ArrayList<String> specialReview = new ArrayList<String>();
            for (PlanningEngineering pe : planningEngineeringList) {
                if ("1".equals(pe.getType())) {
                    temp.setPorjectPlanningDT(StringUtils.isBlank((CharSequence)pe.getDocumentNumber()) ? "" : pe.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate()));
                    temp.setPorjectPlanningScale(StringUtils.isBlank((CharSequence)pe.getConstructionScale()) ? "" : pe.getConstructionScale());
                    continue;
                }
                specialReview.add(BizUtils.getDicValueByCode((List<DictModel>)engineeringType, pe.getType()) + "\uff1a" + pe.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate()));
            }
            temp.setSpecialReview(specialReview);
            ConstructionDrawingDesign drawingDesign = (ConstructionDrawingDesign)((Object)this.drawingManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            temp.setConstructionDrawingDT(null == drawingDesign ? "" : (StringUtils.isBlank((CharSequence)drawingDesign.getDocumentNumber()) ? "" : drawingDesign.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(drawingDesign.getEstablishmentDate())));
            ConstructionPermit constructionPermit = (ConstructionPermit)((Object)this.permitManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            temp.setConstructionPermitName(null == constructionPermit ? "" : BizUtils.handleStringFormat(constructionPermit.getName()));
            temp.setConstructionDrawingDT(null == constructionPermit ? "" : (StringUtils.isBlank((CharSequence)constructionPermit.getCode()) ? "" : constructionPermit.getCode() + "  " + BizUtils.dateFormatChineseStyle(constructionPermit.getEstablishmentDate())));
            RecordAcceptance record = (RecordAcceptance)((Object)this.recordManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"APPROVAL_FILING_AUTHORITY_DATE_"})).last("limit 1")));
            record = null == record ? new RecordAcceptance() : record;
            temp.setRecordAcceptanceDT(StringUtils.isBlank((CharSequence)record.getDocumentNumber()) ? "" : record.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(record.getApprovalFilingAuthorityDate()));
            data.add(temp);
        }
        return data;
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws IOException {
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        List pStatus = this.sdm.queryDictListItemsByCode("xmgl-xmzt");
        List engineeringType = this.sdm.queryDictListItemsByCode("gcgh-lx");
        String year = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"COMMENCEMENT_TIME_".equals(ele.getProperty()) && !"COMMENCEMENT_TIME_".toLowerCase().equals(ele.getProperty())) continue;
            String value = ele.getValue().toString();
            year = value.split("-")[0].replaceAll("\\[", "");
            break;
        }
        String fileName = "\u897f\u6c38\u5fae\u7535\u56ed\u516c\u53f8\u5efa\u8bbe\u9879\u76ee\u5ba1\u6279\u53f0\u8d26\u4e00\u89c8\u8868" + (StringUtils.isEmpty(year) ? "" : "\uff08" + year + "\uff09");
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        HSSFRow titleRow = sheet.createRow(0);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), fileName, true);
        ArrayList<String> heards = new ArrayList<String>();
        heards.addAll(Arrays.asList("\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u7acb\u9879/\u6838\u51c6/\u5907\u6848", "\u53ef\u7814", " ", "\u7528\u5730\u9884\u5ba1\u4e0e\u9009\u5740\u610f\u89c1\u4e66", "\u7528\u5730\u624b\u7eed", "\u89c4\u5212\u7528\u5730\u8bb8\u53ef", "\u4e13\u9879\u5ba1\u67e5\uff08\u8f68\u9053\u3001\u73af\u4fdd\u3001\u6d88\u9632\u3001\u884c\u6d2a\u7b49\uff09"));
        ArrayList<String> subHeards = new ArrayList<String>();
        subHeards.addAll(Arrays.asList(" ", " ", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u89c4\u6a21\u3001\u603b\u6295\u8d44\u53ca\u5efa\u5b89\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u7c7b\u578b\u3001\u6279\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4"));
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        queryFilter.addFilter("PARENT_ID_", (Object)"root", QueryOP.EQUAL);
        ArrayList result = this.handleAppro(this.projectManager.queryAllByPage(queryFilter).getRows());
        ArrayList data = null == result ? new ArrayList() : result;
        int maxSpecialNum = 1;
        for (int i = 0; i < data.size(); ++i) {
            int target = ((ApprovalLedgerVo)data.get(i)).getSpecialReview().size();
            if (target <= maxSpecialNum) continue;
            maxSpecialNum = target;
        }
        int cloEnd = 8;
        for (int i = 0; i < maxSpecialNum; ++i) {
            heards.add("");
            subHeards.add("\u7c7b\u522b\u3001\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4");
            ++cloEnd;
        }
        heards.remove(heards.size() - 1);
        heards.addAll(Arrays.asList("\u89c4\u5212\u8bb8\u53ef", " ", "\u521d\u6b65\u8bbe\u8ba1", "\u6982\u7b97", " ", "\u65bd\u5de5\u56fe\u5ba1\u67e5\u5907\u6848", "\u65bd\u5de5\u8bb8\u53ef", " ", "\u7ae3\u5de5\u9a8c\u6536\u5907\u6848"));
        subHeards.addAll(Arrays.asList("\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u89c4\u6a21", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u603b\u6295\u8d44\u53ca\u5efa\u5b89\u6295\u8d44\uff08\u4e07\u5143\uff09", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u65bd\u5de5\u8bb8\u53ef\u540d\u79f0", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4", "\u6279\u590d\u6587\u53f7\u53ca\u65f6\u95f4"));
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i = 0; i < heards.size(); ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i), (String)heards.get(i), new boolean[0]);
        }
        HSSFRow titleRow2 = sheet.createRow(2);
        for (int i = 0; i < subHeards.size(); ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow2.createCell(i), (String)subHeards.get(i), new boolean[0]);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, cloEnd + 8));
        sheet.addMergedRegion(new CellRangeAddress(1, 2, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(1, 2, 1, 1));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 3, 4));
        if (cloEnd != 9) {
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 8, cloEnd - 1));
        }
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd, cloEnd + 1));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd + 3, cloEnd + 4));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd + 6, cloEnd + 7));
        int row = 3;
        int currentType = ((ApprovalLedgerVo)data.get(0)).getProjectType() - 1;
        int counter = 1;
        for (int j = 1; j < ((ApprovalLedgerVo)data.get(0)).getProjectType(); ++j) {
            HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
            this.handleSubTitle(j, fileName, subHeards.size(), pType, workbook, addRow);
            ++row;
        }
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(row);
            if (currentType != ((ApprovalLedgerVo)data.get(i)).getProjectType()) {
                int oldType = currentType;
                currentType = ((ApprovalLedgerVo)data.get(i)).getProjectType();
                if (currentType - oldType > 1) {
                    int j = oldType++;
                    while (j < currentType) {
                        if (oldType <= 7 || oldType >= 12) {
                            this.handleSubTitleOther(oldType, fileName, subHeards.size(), pType, workbook, listRow);
                            if (oldType != currentType) {
                                listRow = sheet.createRow(++row);
                            }
                        }
                        j = oldType++;
                    }
                } else {
                    this.handleSubTitleOther(currentType, fileName, subHeards.size(), pType, workbook, listRow);
                }
                counter = 1;
                --i;
            } else if (((ApprovalLedgerVo)data.get(i)).getProjectType() - currentType > 1) {
                int j = currentType++;
                while (j < ((ApprovalLedgerVo)data.get(i)).getProjectType()) {
                    HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
                    this.handleSubTitleOther(currentType, fileName, subHeards.size(), pType, workbook, addRow);
                    j = currentType++;
                }
            } else {
                ((ApprovalLedgerVo)data.get(i)).replace();
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(0), String.valueOf(counter), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(1), ((ApprovalLedgerVo)data.get(i)).getProjectName(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(2), ((ApprovalLedgerVo)data.get(i)).getEstablishDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(3), ((ApprovalLedgerVo)data.get(i)).getFeasiblePlanDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(4), ((ApprovalLedgerVo)data.get(i)).getFeasiblePlanInfo(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(5), ((ApprovalLedgerVo)data.get(i)).getSiteDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(6), ((ApprovalLedgerVo)data.get(i)).getUseLandDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(7), ((ApprovalLedgerVo)data.get(i)).getUseLandCode(), new boolean[0]);
                ArrayList specialReview = null == ((ApprovalLedgerVo)data.get(i)).getSpecialReview() ? new ArrayList() : ((ApprovalLedgerVo)data.get(i)).getSpecialReview();
                int currCell = 8;
                for (int t = 0; t < maxSpecialNum; ++t) {
                    if (t < specialReview.size()) {
                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), (String)specialReview.get(t), new boolean[0]);
                    } else {
                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), "", new boolean[0]);
                    }
                    ++currCell;
                }
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), ((ApprovalLedgerVo)data.get(i)).getPorjectPlanningDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, fileName, listRow.createCell(currCell + 1), ((ApprovalLedgerVo)data.get(i)).getPorjectPlanningScale(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 2), ((ApprovalLedgerVo)data.get(i)).getPreliminaryDesignDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 3), ((ApprovalLedgerVo)data.get(i)).getEstimateDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 4), ((ApprovalLedgerVo)data.get(i)).getEstimateInfo(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 5), ((ApprovalLedgerVo)data.get(i)).getConstructionDrawingDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 6), ((ApprovalLedgerVo)data.get(i)).getConstructionPermitName(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 7), ((ApprovalLedgerVo)data.get(i)).getConstructionPermitDT(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell + 8), ((ApprovalLedgerVo)data.get(i)).getRecordAcceptanceDT(), new boolean[0]);
                ++counter;
            }
            ++row;
        }
        int lastIndex = sheet.getLastRowNum() + 1;
        int i = currentType++;
        while (i < pType.size()) {
            HSSFRow lastRow = sheet.createRow(lastIndex++);
            if (currentType == 8) {
                this.handleSubTitleOther(12, fileName, subHeards.size(), pType, workbook, lastRow);
            } else {
                this.handleSubTitleOther(currentType, fileName, subHeards.size(), pType, workbook, lastRow);
            }
            i = currentType++;
        }
        sheet.setColumnWidth(0, 2000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 8000);
        for (i = 3; i < subHeards.size(); ++i) {
            sheet.setColumnWidth(i, 4000);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private void handleSubTitle(int currentType, String fileName, int length, List<DictModel> dic, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t < length; ++t) {
            if (t == 0) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), BizUtils.converttoChinaNumber(currentType), new boolean[0]);
                continue;
            }
            if (t == 1) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), BizUtils.getDicValueByCode(dic, currentType), new boolean[0]);
                continue;
            }
            BizUtils.handelCell(workbook, fileName, row.createCell(t), "", new boolean[0]);
        }
    }

    private void handleSubTitleOther(int currentType, String fileName, int length, List<DictModel> dic, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t < length; ++t) {
            if (t == 0) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), BizUtils.converttoChinaNumber(currentType == 12 ? 8 : currentType), new boolean[0]);
                continue;
            }
            if (t == 1) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), BizUtils.getDicValueByCode(dic, currentType), new boolean[0]);
                continue;
            }
            BizUtils.handelCell(workbook, fileName, row.createCell(t), "", new boolean[0]);
        }
    }
}

