/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.wps.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.wps.model.User;
import com.artfess.cqxy.wps.vo.FileVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"WPS\u5728\u7ebf\u6587\u6863\u670d\u52a1.\u6587\u4ef6\u56de\u8c03\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/v1/3rd/file"})
public class FileCallbackController {
    private static final Logger log = LoggerFactory.getLogger(FileCallbackController.class);
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;

    @ResponseBody
    @GetMapping(value={"/info"})
    @ApiOperation(value="\u6587\u4ef6\u4fe1\u606f")
    public FileVo fileInfo(String _w_fileid) {
        com.artfess.cqxy.wps.model.File file = new com.artfess.cqxy.wps.model.File();
        Accessory accessory = (Accessory)((Object)this.accessoryManager.getOne((Wrapper)new QueryWrapper().select(new String[]{"*"}).eq((Object)"ID_", (Object)_w_fileid)));
        file.setId(accessory.getId());
        file.setName(accessory.getName());
        file.setVersion(StringUtil.isEmpty((Long)accessory.getVersion()) ? 0L : accessory.getVersion());
        file.setSize(accessory.getFileSizeB());
        file.setCreate_time(accessory.getCreateTime().toEpochSecond(ZoneOffset.of("+8")));
        file.setModify_time(accessory.getUpdateTime().toEpochSecond(ZoneOffset.of("+8")));
        file.setCreator(accessory.getCreateBy());
        file.setModifier(accessory.getUpdateBy());
        file.setDownload_url(accessory.getUrl());
        User user = new User();
        user.setId(this.baseContext.getCurrentUserId());
        user.setName(this.baseContext.getCurrentUserName());
        user.setPermission("read");
        user.setAvatar_url("http://122.9.167.145:9086/fvue/cqxy.ico");
        return new FileVo(200, "success", "\u64cd\u4f5c\u6210\u529f", file, user);
    }

    @ResponseBody
    @PostMapping(value={"/online"})
    public CommonResult online() {
        return new CommonResult("");
    }

    @ResponseBody
    @PostMapping(value={"/save"})
    public Object save(@RequestParam(value="file") MultipartFile file, @RequestParam(value="_w_fileid") String fileid) {
        Accessory accessory = (Accessory)this.accessoryManager.get((Serializable)((Object)fileid));
        if (!file.isEmpty()) {
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(accessory.getUrl())));
                out.write(file.getBytes());
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.getSize() / 1024.0 / 1024.0) + " MB");
        accessory.setVersion(accessory.getVersion() + 1L);
        this.accessoryManager.updateById((Object)accessory);
        return accessory;
    }

    @ResponseBody
    @GetMapping(value={"/version/{version}"})
    public Object fileVersionInfo(@PathVariable(value="version") Long version, @RequestParam(value="_w_fileid") String _w_fileid) throws UnsupportedEncodingException {
        com.artfess.cqxy.wps.model.File file = new com.artfess.cqxy.wps.model.File();
        Accessory accessory = (Accessory)((Object)this.accessoryManager.getOne((Wrapper)new QueryWrapper().select(new String[]{"*"}).eq((Object)"ID_", (Object)_w_fileid)));
        file.setId(accessory.getId());
        file.setName(accessory.getName());
        file.setVersion(version);
        file.setSize(accessory.getFileSizeB());
        file.setCreate_time(accessory.getCreateTime().toEpochSecond(ZoneOffset.of("+8")));
        file.setModify_time(accessory.getUpdateTime().toEpochSecond(ZoneOffset.of("+8")));
        file.setCreator(accessory.getCreateBy());
        file.setModifier(accessory.getUpdateBy());
        file.setDownload_url(accessory.getUrl());
        User user = new User();
        user.setId(this.baseContext.getCurrentUserId());
        user.setName(this.baseContext.getCurrentUserName());
        user.setPermission("read");
        user.setAvatar_url("http://122.9.167.145:9086/fvue/cqxy.ico");
        return new FileVo(200, "success", "\u64cd\u4f5c\u6210\u529f", file, user);
    }
}

