/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.designEstimate.manager.EstimateManager;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.ledger.manager.BiddingLedgerManager;
import com.artfess.cqxy.ledger.vo.BiddingLedgerVo;
import com.artfess.cqxy.projectManagement.dao.ProjectManagementDao;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BiddingLedgerManagerImpl
implements BiddingLedgerManager {
    @Autowired
    private BiddingManagementManager biddingManager;
    @Autowired
    private ProjectManagementManager projectManager;
    @Autowired
    private EstimateManager estimateManager;
    @Autowired
    private ContractManager contractManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private ProjectManagementDao projectManagementDao;

    @Override
    public PageList<BiddingLedgerVo> queryByPage(QueryFilter<BiddingManagement> queryFilter) {
        PageList<BiddingManagement> pageList;
        List<String> projectList;
        PageList pageListvo = new PageList();
        queryFilter.withSorter(new FieldSort("bbm.COMMENCEMENT_DATE_", Direction.ASC));
        if (BizUtils.isProjectIdFields(queryFilter.getQuerys()).booleanValue() && null != (projectList = BizUtils.handProjectAuthByUser(this.ucFeignService, this.projectPersonnelManager, this.projectManagementDao)) && projectList.size() > 0) {
            queryFilter.addFilter("bbm.PROJECT_ID_", projectList, QueryOP.IN);
        }
        ArrayList<BiddingManagement> biddingList = null == (pageList = this.biddingManager.queryAllByPage(queryFilter)).getRows() ? new ArrayList() : pageList.getRows();
        pageListvo.setPage(pageList.getPage());
        pageListvo.setTotal(pageList.getTotal());
        pageListvo.setRows(this.handleAppro(biddingList));
        pageListvo.setPageSize(pageList.getPageSize());
        return pageListvo;
    }

    private List<BiddingLedgerVo> handleAppro(List<BiddingManagement> projectList) {
        ArrayList<BiddingLedgerVo> data = new ArrayList<BiddingLedgerVo>();
        for (BiddingManagement ele : projectList) {
            BiddingLedgerVo temp = new BiddingLedgerVo();
            ProjectManagement project = (ProjectManagement)((Object)this.projectManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)ele.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")).last("limit 1")));
            project = BeanUtils.isEmpty((Object)((Object)project)) ? new ProjectManagement() : project;
            temp.setProjectId(project.getId());
            temp.setProjectName(project.getProjectName());
            temp.setProjectManager(project.getProjectManager());
            temp.setCommencementTime(project.getCommencementTime());
            temp.setCompletionTime(project.getCompletionTime());
            temp.setYear(null != project.getCompletionTime() ? BizUtils.handleDateFormat(project.getCompletionTime()).split("-")[0] + "\u5e74" : "");
            Estimate estimate = (Estimate)((Object)this.estimateManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")).orderBy(true, false, (Object[])new String[]{"ESTABLISHMENT_DATE_"})).last("limit 1")));
            estimate = BeanUtils.isEmpty((Object)((Object)estimate)) ? new Estimate() : estimate;
            String documentNumber = StringUtils.isBlank((CharSequence)estimate.getDocumentNumber()) ? "" : estimate.getDocumentNumber();
            temp.setPreliminaryEstimate(null == estimate.getTotalEstimate() ? "" : estimate.getTotalEstimate());
            temp.setSourceFunds(estimate.getSourceFunds());
            List chargeType = this.sdm.queryDictListItemsByCode("zbfs");
            List hasComplaint = this.sdm.queryDictListItemsByCode("zbgl-ywts");
            temp.setDocumentNumber(ele.getDocumentNumber());
            temp.setBiddingChargeType(BizUtils.getDicValueByCode((List<DictModel>)chargeType, ele.getBiddingChargeType()));
            temp.setBidAmountExamine(this.yuanToWanyuan(ele.getBidAmountExamine()));
            temp.setBidWinner(ele.getBidWinner());
            temp.setBidWinnerPhone(ele.getBidWinnerAgentPhone());
            temp.setBidAmount(this.yuanToWanyuan(ele.getBidAmount()));
            temp.setActualSettlementAmount(this.yuanToWanyuan(ele.getActualSettlementAmount()));
            temp.setBiddingAgency(ele.getBiddingAgency());
            temp.setResponsibleUnit(ele.getResponsibleUnit());
            temp.setResponsiblePerson(ele.getResponsiblePerson());
            temp.setProjectBudget(this.yuanToWanyuan(ele.getProjectBudget()));
            List implementationDic = this.sdm.queryDictListItemsByCode("zbgl-tbbzjzffs");
            temp.setImplementationPersonnelPhone(StringUtils.isBlank((CharSequence)ele.getImplementationPersonnelPhone()) ? "\u73b0\u91d1" : BizUtils.getDicValueByCode((List<DictModel>)implementationDic, ele.getImplementationPersonnelPhone()));
            temp.setImplementationPersonnelPhoneUrl(ele.getImplementationPersonnelPhoneUrl());
            List pbffDic = this.sdm.queryDictListItemsByCode("zbgl-pbff");
            temp.setImplementationPersonnelName(BizUtils.getDicValueByCode((List<DictModel>)pbffDic, ele.getImplementationPersonnelName()));
            temp.setCommencementDate(ele.getCommencementDate());
            temp.setFundsSource(StringUtils.isBlank((CharSequence)ele.getFundsSource()) ? "\u5426" : ele.getFundsSource());
            temp.setFundsSourceUrl(ele.getFundsSourceUrl());
            temp.setHasComplaint(StringUtils.isBlank((CharSequence)ele.getHasComplaint()) ? "\u65e0" : BizUtils.getDicValueByCode((List<DictModel>)hasComplaint, ele.getHasComplaint()));
            temp.setHasComplaintUrl(ele.getHasComplaintUrl());
            temp.setComplaintSituation(ele.getComplaintSituation());
            temp.setActualPaymentMethod(ele.getActualPaymentMethod());
            List paymentMethodDic = this.sdm.queryDictListItemsByCode("zbgl-zbdwxz");
            temp.setContractPaymentMethod(BizUtils.getDicValueByCode((List<DictModel>)paymentMethodDic, ele.getContractPaymentMethod()));
            temp.setBidWinnerAgentName(StringUtils.isBlank((CharSequence)ele.getBidWinnerAgentName()) ? "" : ele.getBidWinnerAgentName() + "\n" + (StringUtils.isBlank((CharSequence)ele.getPayeePhone()) ? "" : ele.getPayeePhone()));
            temp.setCompletionDate(ele.getCompletionDate());
            temp.setPayeeNameAccount(ele.getPayeeNameAccount());
            temp.setPayeePhone(ele.getPayeePhone());
            temp.setRemarks(ele.getRemarks());
            QueryWrapper contractQueryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")).like((Object)"SECOND_PARTY_", (Object)ele.getBidWinner())).last("limit 1");
            Contract contract = (Contract)((Object)this.contractManager.getOne((Wrapper)contractQueryWrapper));
            contract = BeanUtils.isEmpty((Object)((Object)contract)) ? new Contract() : contract;
            List moldDic = this.sdm.queryDictListItemsByCode("zhtgl-htfl");
            temp.setTreatyContents(contract.getTreatyContents());
            temp.setMold(BizUtils.getDicValueByCode((List<DictModel>)moldDic, contract.getMold()));
            temp.setPayeeAccountPhone(contract.getPayeeAccountPhone());
            temp.setPayType(contract.getTreatyContents());
            data.add(temp);
        }
        return data;
    }

    public String yuanToWanyuan(String rmb) {
        if (StringUtils.isNotBlank((CharSequence)rmb)) {
            BigDecimal newRmb = new BigDecimal(rmb);
            return newRmb.divide(new BigDecimal(10000)).setScale(2, 4).stripTrailingZeros().toPlainString();
        }
        return "";
    }

    @Override
    public void exportDataToExcel(QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException {
        int i;
        String fileName = "";
        String title = "\u5de5\u7a0b\u5efa\u8bbe\u9879\u76ee\u62db\u6295\u6807\u57fa\u672c\u60c5\u51b5\u8868";
        for (QueryField qf : queryFilter.getQuerys()) {
            if (!"bbm.COMMENCEMENT_DATE_".equalsIgnoreCase(qf.getProperty())) continue;
            if (QueryOP.BETWEEN.equals((Object)qf.getOperation())) {
                fileName = fileName + String.valueOf(Arrays.asList(qf.getValue()).get(0)).split("-")[0].replace("[", "") + "\u5e74";
            }
            if (!QueryOP.EQUAL.equals((Object)qf.getOperation())) continue;
            fileName = fileName + qf.getValue() + "\u5e74";
        }
        fileName = fileName + "\u62db\u6295\u6807\u53f0\u8d26";
        List chargeType = this.sdm.queryDictListItemsByCode("zbfs");
        List hasComplaint = this.sdm.queryDictListItemsByCode("zbgl-ywts");
        List biddingChargeType = this.sdm.queryDictListItemsByCode("zbfs");
        List implementationDic = this.sdm.queryDictListItemsByCode("zbgl-tbbzjzffs");
        List moldDic = this.sdm.queryDictListItemsByCode("zhtgl-htfl");
        List pbffDic = this.sdm.queryDictListItemsByCode("zbgl-pbff");
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        ArrayList<String> informant = new ArrayList<String>();
        informant.addAll(Arrays.asList("\u5355\u4f4d\u540d\u79f0", "", "", "", "", "", "", "\u586b\u62a5\u4eba", "", "", "", "", "", "", "\u5ba1\u9605\u4eba", "", "", "", "", "", "\u586b\u62a5\u65f6\u95f4", "", ""));
        ArrayList<String> headers = new ArrayList<String>();
        headers.addAll(Arrays.asList("\u5e8f\u53f7", "\u5f00\u6807\u65e5\u671f", "\u7ecf\u529e\u4eba", "\u9879\u76ee\u540d\u79f0", "\u9879\u76ee\u6982\u7b97(\u4e07\u5143)", "\u62db\u6807\u4ee3\u7406\u673a\u6784\u540d\u79f0", "\u8d44\u91d1\u6765\u6e90\uff08\u542bBT\u3001PPP\u7b49\uff09", "\u62db\u6807\u65b9\u5f0f", "\u6709\u65e0\u6295\u8bc9\u3001\u6295\u8bc9\u4eba\u53ca\u8054\u7cfb\u65b9\u5f0f", "\u6295\u8bc9\u60c5\u51b5", "\u4e2d\u6807\u5355\u4f4d", "\u4e2d\u6807\u5355\u4f4d\u4ee3\u7406\u4eba\u59d3\u540d\u3001\u7535\u8bdd", "\u8bc4\u5ba1\u9650\u4ef7\uff08\u4e07\u5143\uff09", "\u4e2d\u6807\u91d1\u989d\uff08\u4e07\u5143\uff09", "\u5f00\u5de5\u65f6\u95f4", "\u7ae3\u5de5\u65f6\u95f4", "\u5b9e\u65bd\u65bd\u5de5\u4eba\uff08\u627f\u5efa\u4eba\uff09\u3001\u7535\u8bdd", "\u5408\u540c\u7ea6\u5b9a\u4ed8\u6b3e\u65b9\u5f0f", "\u5b9e\u9645\u4ed8\u6b3e\u65b9\u5f0f\u53ca\u60c5\u51b5", "\u6536\u6b3e\u4eba\u53ca\u8d26\u53f7\u3001\u7535\u8bdd", "\u5b9e\u9645\u7ed3\u7b97\u91d1\u989d\uff08\u4e07\u5143\uff09", "\u5ba1\u8ba1\u60c5\u51b5\u53ca\u5b58\u5728\u4e3b\u8981\u95ee\u9898", "\u5907\u6ce8"));
        HSSFRow titleRow0 = sheet.createRow(0);
        BizUtils.handelCell(workbook, fileName, titleRow0.createCell(0), title, true);
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i2 = 0; i2 < informant.size(); ++i2) {
            BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i2), (String)informant.get(i2), new boolean[0]);
        }
        HSSFRow titleRow2 = sheet.createRow(2);
        for (int i3 = 0; i3 < headers.size(); ++i3) {
            BizUtils.handelCell(workbook, fileName, titleRow2.createCell(i3), (String)headers.get(i3), new boolean[0]);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 22));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 3));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 15, 16));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 21, 22));
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        queryFilter.withSorter(new FieldSort("PROJECT_ID_", Direction.ASC));
        queryFilter.getPageBean().setPageSize(-1);
        ArrayList result = this.handleAppro(this.biddingManager.queryAllByPage(queryFilter).getRows());
        ArrayList data = null == result ? new ArrayList() : result;
        int row = 3;
        boolean currentType = false;
        int counter = 1;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String nowDate = dateFormat.format(new Date());
        for (i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(row + i);
            BiddingLedgerVo ele = (BiddingLedgerVo)data.get(i);
            BizUtils.setDefaultValue(ele);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(0), String.valueOf(counter), new boolean[0]);
            String commencementDate = BizUtils.handleDateFormat(ele.getCommencementDate());
            if (StringUtils.isBlank((CharSequence)commencementDate) || commencementDate.equalsIgnoreCase(nowDate)) {
                commencementDate = " ";
            }
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(1), commencementDate, new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(2), ele.getProjectManager(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(3), ele.getProjectName(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(4), StringUtils.isBlank((CharSequence)ele.getPreliminaryEstimate()) ? null : Double.valueOf(ele.getPreliminaryEstimate()), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(5), ele.getBiddingAgency(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(6), ele.getSourceFunds(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(7), BizUtils.getDicValueByCode((List<DictModel>)biddingChargeType, ele.getBiddingChargeType()), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(8), ele.getHasComplaint(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(9), ele.getComplaintSituation(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(10), ele.getBidWinner(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(11), ele.getBidWinnerAgentName() + "\n" + ele.getPayeePhone(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(12), StringUtils.isBlank((CharSequence)ele.getBidAmountExamine()) ? null : Double.valueOf(ele.getBidAmountExamine()), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(13), StringUtils.isBlank((CharSequence)ele.getBidAmount()) ? null : Double.valueOf(ele.getBidAmount()), new boolean[0]);
            String commencementTime = BizUtils.handleDateFormat(ele.getCommencementTime());
            if (StringUtils.isBlank((CharSequence)commencementTime) || commencementTime.equalsIgnoreCase(nowDate)) {
                commencementTime = " ";
            }
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(14), commencementTime, new boolean[0]);
            String completionTime = BizUtils.handleDateFormat(ele.getCompletionTime());
            if (StringUtils.isBlank((CharSequence)completionTime) || completionTime.equalsIgnoreCase(nowDate)) {
                completionTime = " ";
            }
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(15), completionTime, new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(16), ele.getBidWinnerAgentName() + "\n" + ele.getPayeePhone(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(17), ele.getTreatyContents(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(18), ele.getPayType(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(19), ele.getPayeeNameAccount() + "\n" + ele.getPayeeAccountPhone(), new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(20), "", new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(21), "", new boolean[0]);
            BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(22), ele.getRemarks(), new boolean[0]);
            ++counter;
        }
        sheet.setColumnWidth(0, 1800);
        for (i = 1; i < headers.size(); ++i) {
            sheet.setColumnWidth(i, 4000);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

