package com.artfess.cqxy.ledger.manager;

import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.ledger.vo.ContractKeeperVo;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/18 10:49
 */
public interface ContractLedgerManager {

    /**
     * 分页查询数据，使用了合同管理的查询器
     * @param queryFilter 项目管理查询器
     * @return 数据
     */
    Map<String, Object> queryByPage(QueryFilter<Contract> queryFilter);

    /**
     * 导出数据到Excel
     * @param queryFilter 项目管理查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 根据合同ID修改经办人
     * @param contractKeeperVo
     */
    void updateContractReceiverById(ContractKeeperVo contractKeeperVo);
}
