package com.artfess.cqxy.warranty.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.cqxy.warranty.dao.WarrantyDao;
import com.artfess.cqxy.warranty.entity.Warranty;
import com.artfess.cqxy.warranty.manager.WarrantyManager;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * (Warranty)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-06-01 15:00:58
 */
@Service
public class WarrantyManagerImpl extends BaseManagerImpl<WarrantyDao, Warranty> implements WarrantyManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(Warranty entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>():flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.three.getCode());
            ele.setGroup("Warranty");
            ele.setNode(ProjectStatusEnum.three.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.three.getCode()));
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval,Warranty entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.four.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.four.getName());
        globalRetrieval.setBizTableName(FunctionEnum.four.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.four.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.four.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.four.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.four.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getName()+"_"+entity.getRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public Warranty getById(String id) {
        Warranty result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<Warranty> queryAllByPage(QueryFilter<Warranty> queryFilter) {
        BizUtils.handleFilter(queryFilter,"bw" ,"pm");
        IPage<Warranty> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<Warranty> records = result.getRecords();
        for (Warranty ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void exportDataToExcel(QueryFilter<Warranty> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "竣工验收-质量保修-导出结果";

        // 获取数据
        BizUtils.handleFilter(queryFilter, "bw", "pm");
        List<Warranty> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0,-1,false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, Warranty.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId, "项目ID不能为空");
        ProjectManagement project = pmm.get(projectId);
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<Warranty> data = ExcelImportUtil.importExcel(inputStream,Warranty.class,new ImportParams());
            for(Warranty ele:data){
                ele.setProjectId(projectId);
                ele.setProjectName(project.getProjectName());
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}

