package com.artfess.cqxy.projectManagement.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author Limuhua
 * @date 2022/2/12 17:55
 */
@Data
@ApiModel(description = "项目人员VO对象")
public class ProjectPersonnelVo {
    @ApiModelProperty(name = "projectId", notes = "项目ID")
    private String projectId;

    @ApiModelProperty(name = "projectName", notes = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "人员ID（关联人员表ID）")
    private String personnelId;

    @ApiModelProperty(name = "id", notes = "用户ID")
    private String id;

    @ApiModelProperty(name = "fullname", notes = "姓名")
    private String fullname;

    @ApiModelProperty(name = "account", notes = "账号")
    private String account;

    @ApiModelProperty(name = "email", notes = "邮箱")
    private String email;

    @ApiModelProperty(name = "mobile", notes = "手机号码")
    private String mobile;

    @ApiModelProperty(name = "address", notes = "地址")
    private String address;

    @ApiModelProperty(name = "sex", notes = "性别")
    private String sex;

    @ApiModelProperty(name = "weixin", notes = "微信号")
    private String weixin;

    @ApiModelProperty(name = "userNumber", notes = "工号")
    private String userNumber;

    @ApiModelProperty(name = "idCard", notes = "身份证号")
    private String idCard;

    @ApiModelProperty(name = "phone", notes = "办公电话")
    private String phone;

    @ApiModelProperty(name = "birthday", notes = "生日")
    private LocalDate birthday;

    @ApiModelProperty(name = "entryDate", notes = "入职日期")
    private LocalDate entryDate;

    @ApiModelProperty(name = "education", notes = "学历")
    private String education;
}
