package com.artfess.cqxy.projectManagement.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 项目开工(ProjectStart)表实体类
 *
 * @author 黎沐华
 * @since 2022-06-01 16:47:14
 */
@Data
@TableName("biz_project_start")
@ApiModel(value="项目开工对象-ProjectStart", description="项目开工表")
public class ProjectStart extends BizModel<ProjectStart> {

    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID，关联项目表")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

    @Excel(name = "文号")
    @TableField("DOCUNEMT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String docunemtNumber;

    @Excel(name = "审核日期",format = "yyyy-MM-dd")
    @TableField("ESTIMANE_DATE_")
    @ApiModelProperty(value = "审核日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimaneDate;

    @Excel(name = "开工日期",format = "yyyy-MM-dd")
    @TableField("START_DATE_")
    @ApiModelProperty(value = "开工日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    @Excel(name = "总监理工程师")
    @TableField("MAIN_ENGINEER_")
    @ApiModelProperty(value = "总监理工程师")
    private String mainEngineer;

    @Excel(name = "施工单位负责人")
    @TableField("PROJECT_MANAGER_")
    @ApiModelProperty(value = "施工单位负责人")
    private String projectManager;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

}

