package com.artfess.cqxy.projectApproval.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 决策依据表(BizDecisionBasis)表实体类
 * @author 黎沐华
 * @since 2022-02-14 13:57:39
 */
@Data
@TableName("BIZ_DECISION_BASIS")
@ApiModel(value="决策立项-决策依据对象-DecisionBasis", description="决策依据表")
public class DecisionBasis extends BizModel<DecisionBasis> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("DECISION_ANNUAL_PLAN_ID_")
    @ApiModelProperty(value = "年度计划ID（关联年度计划表ID）,当决策文件类型选项中包含了年度计划时需要选择关联年度计划")
    private String decisionAnnualPlanId;

    @Excel(name = "决策类型")
    @TableField("DECISION_BASIS_TYPE_")
    @ApiModelProperty(value = "决策文件类型，可多选（使用字典，1：党委会，2：董事会，3：总经理办公会，4：请示，5：年度计划，6：其他）")
    private String decisionBasisType;

    @Excel(name = "决策时间",format = "yyyy-MM-dd")
    @TableField("DECISION_BASIS_TIME_")
    @ApiModelProperty(value = "决策时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date decisionBasisTime;

    @Excel(name = "决策描述")
    @TableField("DECISION_BASIS_DESCRIBE_")
    @ApiModelProperty(value = "决策描述")
    private String decisionBasisDescribe;

    @Excel(name = "决策人")
    @TableField("DECISION_BASIS_PERSION_")
    @ApiModelProperty(value = "决策人")
    private String decisionBasisPersion;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "DecisionBasis{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", decisionBasisType='" + decisionBasisType + '\'' +
                ", decisionBasisTime=" + decisionBasisTime +
                ", decisionBasisPersion='" + decisionBasisPersion + '\'' +
                ", decisionBasisDescribe='" + decisionBasisDescribe + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

