package com.artfess.cqxy.ledger.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.vo.PayLedgerVo;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * @author 黎沐华
 * @date 2022/6/2 10:11
 */
public interface  PayLedgerManager extends BaseManager<PayLedgerVo> {

    /**
     * 分页查询数据
     * @param queryFilter 查询器
     * @return 数据
     */
    PageList<PayLedgerVo> queryByPage(QueryFilter<PayLedgerVo> queryFilter);

    /**
     * 导出数据到Excel
     * @param queryFilter 项目管理查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<PayLedgerVo> queryFilter, HttpServletResponse response) throws IOException;


    /**
     * 查询年度总支付
     * @param year
     * @return
     */
    BigDecimal totalPayByYear(Integer year);
}
