package com.artfess.cqxy.ledger.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.ledger.vo.BiddingLedgerVo;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * @author 黎沐华
 * @date 2022/5/25 15:51
 */
public interface BiddingLedgerManager {

    /**
     * 分页查询数据，使用了项目管理的查询器
     * @param queryFilter 项目管理查询器
     * @return 数据
     */
    PageList<BiddingLedgerVo> queryByPage(QueryFilter<BiddingManagement> queryFilter);

    /**
     * 导出数据到Excel
     * @param queryFilter 项目管理查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException;



}
