package com.artfess.cqxy.contract.dao;

import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 合同管理表(BizContract)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-02-26 10:35:03
 */
public interface ContractDao extends BaseMapper<Contract> {

    IPage<Contract> queryAllByPage(IPage<Contract> convert2IPage, @Param(Constants.WRAPPER) Wrapper<Contract> convert2Wrapper);

    /**
     * 根据条件查询合同统计信息
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);

    /**
     * 根据项目ID查询出项目所有施工合同总金额
     * @param projectId 项目ID
     * @return 施工合同总金额
     */
    BigDecimal queryConstructionAmount(@Param("projectId")String projectId);
}

