package com.artfess.cqxy.bidManagement.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 招投标管理 - 清单限价 - 审核(BiddingPriceExamine)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-08 11:08:31
 */
@Data
@TableName("BIZ_BIDDING_PRICE_EXAMINE")
@ApiModel(value="招投标管理-清单限价-审核对象-BiddingPriceExamine", description="清单限价-审核表")
public class BiddingPriceExamine extends BizModel<BiddingPriceExamine> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "审核单位")
    @TableField("TENDEREE_")
    @ApiModelProperty(value = "审核单位")
    private String tenderee;

    @Excel(name = "审核日期", format = "yyyy-MM-dd")
    @TableField("TENDEREE_DATE_")
    @ApiModelProperty(value = "审核日期（默认当天）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tendereeDate;

    @Excel(name = "审定金额(元)", type = 10, numFormat = "0.00")
    @TableField("PRICE_CEILING_")
    @ApiModelProperty(value = "审定金额(元)")
    private BigDecimal priceCeiling;

    @Excel(name = "安全文明施工费(元)", type = 10, numFormat = "0.00")
    @TableField("NAME_")
    @ApiModelProperty(value = "安全文明施工费(元)")
    private BigDecimal name;

    @Excel(name = "审减金额(元)", type = 10, numFormat = "0.00")
    @TableField("DOC_NUMBER_")
    @ApiModelProperty(value = "审减金额（单位：元）")
    private BigDecimal docNumber;

    // TODO 对于这样需要经过业务处理的字段，不能出现在导入模板中，
    //  但是@Excel()同时处理了导入和导出的动作，也没有提供手段将其隔离，就意味着不在导入规则里的字段也不会被导出
    //  原设想通过Excel函数在模板中实现业务计算，但是这将会导致excel中每一行都有值而导入异常
//    @Excel(name = "审减率")
    @TableField("OWNER_UNIT_")
    @ApiModelProperty(value = "审减率，（百分比，保留两位小数，计算公式：审减金额÷审定金额×100%）")
    private String ownerUnit;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @TableField("PRICE_LIMIT_ID_")
    @ApiModelProperty(value = "清单信息ID（关联清单限价编制表ID，前端根据项目ID弹窗选择清单限价编制数据）")
    private String priceLimitId;

//    @Excel(name = "清单名称")
    @TableField("PRICE_LIMIT_NAME_")
    @ApiModelProperty(value = "清单信息NAME（关联清单限价名称，目前只展示清单限价）")
    private String priceLimitName;

//    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人（默认值：选择项目后将项目负责人填入）")
    private String handler;

//    @Excel(name = "项目概况")
    @TableField("PROJECT_OVERVIEW_")
    @ApiModelProperty(value = "项目概况（默认值：选择清单信息后自动带入）")
    private String projectOverview;

    @TableField(exist = false)
    @ApiModelProperty(value = "清单信息")
    private BiddingPriceLimit limitInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    public BiddingPriceExamine() {
        ownerUnit = "重庆西永微电子产业园区开发有限公司";
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

