package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.NumberFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理(BizProgressManage)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-04 16:49:30
 */
@Data
@TableName("BIZ_PROGRESS_MANAGE")
@ApiModel(value="过程管理-进度管理-工程支付-ProgressManage", description="过程管理-进度管理表-工程支付")
public class ProgressManage extends BizModel<ProgressManage> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "关联合同ID（关联合同信息表）")
    private String contractId;

    @TableField("DEPT_")
//    @Excel(name = "建设部")
    @Value("建设部")
    @ApiModelProperty(value = "部室(子公司），默认值：建设部")
    private String dept;

//    @Excel(name = "账号")
    @TableField("HANDLER_PERSON_")
    @ApiModelProperty(value = "账号")
    private String handlerPerson;

    @Excel(name = "用途")
    @TableField("PURPOSE_")
    @ApiModelProperty(value = "用途（使用字典：1：工程款，）")
    private String purpose;

    @Excel(name = "审批日期",format = "yyyy-MM-dd")
    @TableField("REGISTER_DATE_")
    @ApiModelProperty(value = "审批日期，（默认今天，时间格式：2022-02-22）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate;

    @Excel(name = "总投资额(万元)", type = 10, numFormat = "0.00")
    @TableField("TOTAL_INVESTMENT_")
    @ApiModelProperty(value = "总投资额（单位：元）")
    @BigDecimalFormat
    private BigDecimal totalInvestment;

    @Excel(name = "本次拨付总额(元)", type = 10, numFormat = "0.00")
    @TableField("PAYEE_AMOUNT_TOTAL_")
    @ApiModelProperty(value = "本次拨付总额（单位：元）")
    @BigDecimalFormat
    private BigDecimal payeeAmountTotal;

    @Excel(name = "已拨款额(元)", type = 10, numFormat = "0.00")
    @TableField("AMOUNT_APPROPRIATED_")
    @ApiModelProperty(value = "已拨款额（单位：元，添加时需后端计算出该项目已拨付款项）")
    @BigDecimalFormat
    private BigDecimal amountAppropriated;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField("YEAR_")
    @ApiModelProperty(value = "年度（前端页面默认当前年度）")
    private Integer year;

    @TableField("MONTH_")
    @ApiModelProperty(value = "月份（前端页面默认当前月份）")
    private Integer month;

    @TableField("REGISTER_PERSON_ID_")
    @ApiModelProperty(value = "开户行")
    private String registerPersonId;

    @TableField("REGISTER_PERSON_NAME_")
    @ApiModelProperty(value = "收款单位")
    private String registerPersonName;

    @TableField("OUTPUT_VALUE_")
    @ApiModelProperty(value = "当前完成产值")
    @BigDecimalFormat
    private BigDecimal outputValue;

    @TableField("HAVE_FUND_PLAN_")
    @ApiModelProperty(value = "是否有资金计划（0：是，1：否）")
    private String haveFundPlan;

    @TableField("CONTRACT_AGREEMENT_")
    @ApiModelProperty(value = "合同协议（单位：份）")
    private Integer contractAgreement;

    @TableField("SUPERVISOR_CONTRACT_")
    @ApiModelProperty(value = "监理合同（单位：份）")
    private Integer supervisorContract;

    @TableField("MEASUREMENT_DATA_")
    @ApiModelProperty(value = "项目进度情况及已完成工作量")
    private String measurementData;

    @TableField("SETTLEMENT_BILL_TYPE_")
    @ApiModelProperty(value = "结算票据（使用字典：1：发票，2：收据，3：其他）")
    private String settlementBillType;

    @TableField("SETTLEMENT_BILL_NUM_")
    @ApiModelProperty(value = "票据号码")
    private String settlementBillNum;

    @TableField("AMOUNT_TOTAL_WORDS_")
    @ApiModelProperty(value = "大写金额（前端使用插件自动写入）")
    private String amountTotalWords;

    @TableField(exist = false)
    @ApiModelProperty(value = "关联的拨款明细信息")
    private List<ProgressManageDefinite> definiteInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProgressManage{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", contractId='" + contractId + '\'' +
                ", dept='" + dept + '\'' +
                ", year=" + year +
                ", month=" + month +
                ", registerDate=" + registerDate +
                ", registerPersonId='" + registerPersonId + '\'' +
                ", registerPersonName='" + registerPersonName + '\'' +
                ", totalInvestment=" + totalInvestment +
                ", amountAppropriated=" + amountAppropriated +
                ", outputValue=" + outputValue +
                ", purpose=" + purpose +
                ", haveFundPlan=" + haveFundPlan +
                ", contractAgreement=" + contractAgreement +
                ", supervisorContract=" + supervisorContract +
                ", measurementData=" + measurementData +
                ", settlementBillType=" + settlementBillType +
                ", settlementBillNum='" + settlementBillNum + '\'' +
                ", payeeAmountTotal=" + payeeAmountTotal +
                ", amountTotalWords='" + amountTotalWords + '\'' +
                ", handlerPerson='" + handlerPerson + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", contractInfo=" + contractInfo +
                ", definiteInfo=" + definiteInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

