package com.artfess.cqxy.processManagermant.dao;

import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.artfess.cqxy.processManagermant.model.ChangeManagement;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 过程管理 - 变更管理(BizChangeManagement)表数据库访问层
 * @author 黎沐华
 * @since 2022-03-03 09:19:49
 */
public interface ChangeManagementDao extends BaseMapper<ChangeManagement> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ChangeManagement getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ChangeManagement> queryAllByPage(IPage<ChangeManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ChangeManagement> convert2Wrapper);

    /**
     * 根据条件查询变更统计情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);


    /**
     * 根据条件查询变更数量统计情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> engineeringChangeNumber(@Param("statisticsVo") StatisticsVo statisticsVo);

    BigDecimal SumAmount2(@Param("pid") String pid);
}

