package com.artfess.cqxy.projectManagement.model;


import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 项目人员中间表(BizProjectPersonnel)表实体类
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
@Data
@TableName("BIZ_PROJECT_PERSONNEL_MENU")
@ApiModel(value="项目管理-项目人员菜单对象-ProjectPersonnelMenu", description="项目人员菜单中间表")
public class ProjectPersonnelMenu extends BizModel<ProjectPersonnelMenu> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("USER_ID_")
    @ApiModelProperty(value = "人员ID（关联人员表ID）")
    private String userlId;

    @TableField("MENU_ALIAS_")
    @ApiModelProperty(value = "菜单别名")
    private String menuAlias;

    @ApiModelProperty(name = "methodAlias", notes = "请求方法别名")
    @TableField("method_alias_")
    protected String methodAlias;

    @ApiModelProperty(name = "dataPermission", notes = "数据权限设置json")
    @TableField("data_permission_")
    protected String dataPermission;

    @ApiModelProperty(name = "methodRequestUrl", notes = "请求方法地址")
    @TableField(exist=false)
    private String methodRequestUrl;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }



}

