/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.documentLibrary.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryManager;
import com.artfess.cqxy.documentLibrary.model.FileLibrary;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6587\u4ef6\u5e93\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/fileLibrary/v1"})
public class FileLibraryController
extends BaseController<FileLibraryManager, FileLibrary> {
    private static final Logger log = LoggerFactory.getLogger(FileLibraryController.class);

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014\u4e3b\u8868\u4e3abfl \u6587\u4ef6\u5e93\u3001\u526f\u8868\u4e3abflt \u6587\u4ef6\u5e93\u7c7b\u578b", httpMethod="POST")
    public CommonResult<PageList<FileLibrary>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<FileLibrary> queryFilter) {
        log.debug("\u6587\u4ef6\u5e93-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<FileLibrary> result = ((FileLibraryManager)this.baseService).queryAllByPage(queryFilter);
        log.debug("\u6587\u4ef6\u5e93-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult insert(@RequestBody FileLibrary fileLibrary) {
        log.debug("\u6587\u4ef6\u5e93-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)fileLibrary);
        boolean add = StringUtils.isEmpty((CharSequence)fileLibrary.getId());
        boolean save = ((FileLibraryManager)this.baseService).saveOrUpdate((Object)fileLibrary);
        String msg = (add ? "\u6dfb\u52a0" : "\u4fee\u6539") + (save ? "\u6210\u529f" : "\u5931\u8d25");
        log.debug("\u6587\u4ef6\u5e93-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(save, msg);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        log.debug("\u6587\u4ef6\u5e93-\u5220\u9664\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((FileLibraryManager)this.baseService).deleteByIds(ids);
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u6587\u4ef6\u5e93-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<FileLibrary> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        log.debug("\u6587\u4ef6\u5e93-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)id);
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        FileLibrary result = (FileLibrary)((FileLibraryManager)this.baseService).get((Serializable)((Object)id));
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        log.debug("\u6587\u4ef6\u5e93-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }
}

