/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.universal.manager.impl;

import com.artfess.application.service.impl.TemplateServiceImpl;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.dao.NoticeDao;
import com.artfess.cqxy.universal.manager.NoticeManager;
import com.artfess.cqxy.universal.model.NoticeDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NoticeManagerImpl
extends BaseManagerImpl<NoticeDao, NoticeDTO>
implements NoticeManager {
    @Autowired
    private ProjectManagementManager pmm;

    @Override
    @Scheduled(cron="0 15 10 ? * *")
    public void isSend() {
        for (ProjectManagement projectManagement : this.pmm.list()) {
            if (Integer.valueOf(projectManagement.getProjectStatus()) >= 11) continue;
            String projectId = projectManagement.getId();
            String projectName = projectManagement.getProjectName();
            Integer prevStatus = Integer.valueOf(projectManagement.getProjectStatus()) - 1;
            String tableName = this.getTableNameByStatus(String.valueOf(prevStatus));
            Calendar target = Calendar.getInstance();
            String targetStatus = projectManagement.getProjectStatus();
            if (projectManagement.getProjectStatus().equals("9")) {
                tableName = this.getTableNameByStatus(projectManagement.getProjectStatus());
                targetStatus = String.valueOf(Integer.valueOf(projectManagement.getProjectStatus()) + 1);
            }
            String createTime = this.getCreateTimeById(tableName, projectId);
            Date date = DateUtils.str2Date((String)createTime, (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            target.setTime(date);
            int tYear = target.get(1);
            int tMonth = target.get(2);
            int tDay = target.get(5);
            Calendar now = Calendar.getInstance();
            int nowYear = now.get(1);
            int nowMonth = now.get(2);
            int nowDay = now.get(5);
            Integer targetNum = this.getCount(this.getTableNameByStatus(String.valueOf(targetStatus)), projectId);
            Integer limitTime = this.getLimitTimeByCode(targetStatus);
            if (nowYear == tYear && nowMonth == tMonth && nowDay - tDay < limitTime || targetNum != 0) continue;
            System.out.println("\u53d1\u9001\u6d88\u606f");
            this.send(projectManagement.getProjectManagerId(), projectName, this.getFileNameByStatus(String.valueOf(targetStatus)));
        }
    }

    @Override
    @Scheduled(cron="0 30 9 25,26,27,28,29,30,31 * ? ")
    public void isReportSend() {
        for (ProjectManagement projectManagement : this.pmm.list()) {
            if (!projectManagement.getProjectStatus().equals("11")) continue;
            String projectId = projectManagement.getId();
            String projectName = projectManagement.getProjectName();
            Integer count = this.getCountReport(projectId);
            Calendar now = Calendar.getInstance();
            int nowMonth = now.get(2) + 1;
            if (!BeanUtils.isEmpty((Object)count) && count != 0) continue;
            this.send(projectManagement.getProjectManagerId(), projectName, nowMonth + "\u6708\u5de5\u7a0b\u6708\u62a5");
            break;
        }
    }

    @Override
    public void send(String id, String projectName, String content) {
        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
        String[] ids = id.split(",");
        if (ids.length >= 1) {
            TemplateServiceImpl templateService = new TemplateServiceImpl();
            Notice notice = new Notice();
            notice.setMessageTypes(new NoticeMessageType[]{NoticeMessageType.INNER});
            notice.setSubject("\u4e0a\u4f20\u8d44\u6599\u901a\u77e5");
            notice.setContent("\u60a8\u7ba1\u7406\u7684\u3010" + projectName + "\u3011\u9879\u76ee" + content + "\u8d44\u6599\u8fd8\u672a\u8fdb\u884c\u586b\u62a5\uff0c\u8bf7\u53ca\u65f6\u8fdb\u884c\u586b\u62a5\u3002");
            notice.setReceivers(this.getAccountById(id).split(","));
            for (String pId : ids) {
                JmsActor jmsActor = new JmsActor();
                jmsActor.setAccount(this.getAccountById(pId));
                jmsActor.setId(pId);
                actors.add(jmsActor);
            }
            notice.setReceiver(actors);
            templateService.sendNotice(notice);
        }
    }

    public String getTableNameByStatus(String status) {
        String tableName = "";
        switch (status) {
            case "1": {
                tableName = "BIZ_DECISION_BASIS";
                break;
            }
            case "2": {
                tableName = "BIZ_PROJECT_ESTABLISHMENT";
                break;
            }
            case "3": {
                tableName = "biz_feasibility_study_reply";
                break;
            }
            case "4": {
                tableName = "BIZ_PLANNING_ENGINEERING";
                break;
            }
            case "5": {
                tableName = "BIZ_PRELIMINARY_DESIGN";
                break;
            }
            case "6": {
                tableName = "BIZ_ESTIMATE";
                break;
            }
            case "7": {
                tableName = "BIZ_CONSTRUCTION_DRAWING";
                break;
            }
            case "8": {
                tableName = "BIZ_BIDDING_MANAGEMENT";
                break;
            }
            case "9": {
                tableName = "BIZ_CONTRACT";
                break;
            }
            default: {
                tableName = "BIZ_CONSTRUCTION_PERMIT";
            }
        }
        return tableName;
    }

    @Override
    public Integer getLimitTimeByCode(String id) {
        Integer intId = Integer.valueOf(id);
        if (intId > 7) {
            intId = intId + 2;
            id = String.valueOf(intId);
        }
        return ((NoticeDao)this.baseMapper).getLimitTimeByCode(id);
    }

    public String getFileNameByStatus(String status) {
        String fileName = "";
        switch (status) {
            case "1": {
                fileName = "\u51b3\u7b56";
                break;
            }
            case "2": {
                fileName = "\u7acb\u9879";
                break;
            }
            case "3": {
                fileName = "\u53ef\u7814";
                break;
            }
            case "4": {
                fileName = "\u89c4\u5212";
                break;
            }
            case "5": {
                fileName = "\u521d\u6b65\u8bbe\u8ba1";
                break;
            }
            case "6": {
                fileName = "\u6982\u7b97";
                break;
            }
            case "7": {
                fileName = "\u65bd\u5de5\u56fe";
                break;
            }
            case "8": {
                fileName = "\u62db\u6295\u6807";
                break;
            }
            case "9": {
                fileName = "\u5408\u540c";
                break;
            }
            default: {
                fileName = "\u65bd\u5de5\u8bb8\u53ef";
            }
        }
        return fileName;
    }

    @Override
    public String getAccountById(String id) {
        return ((NoticeDao)this.baseMapper).getAccountById(id);
    }

    @Override
    public String getCreateTimeById(String tableName, String projectId) {
        return ((NoticeDao)this.baseMapper).getCreateTimeById(tableName, projectId);
    }

    @Override
    public Integer getCount(String tableName, String projectId) {
        return ((NoticeDao)this.baseMapper).getCount(tableName, projectId);
    }

    @Override
    public Integer getCountReport(String projectId) {
        return ((NoticeDao)this.baseMapper).getCountReport(projectId);
    }
}

