/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.processManagermant.dao.ProgressManageDao;
import com.artfess.cqxy.processManagermant.manager.ProgressManageDefiniteManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.model.ProgressManageDefinite;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import com.artfess.cqxy.processManagermant.vo.ProgressManageTotalVo;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.cqxy.utils.ThreadUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProgressManageManagerImpl
extends BaseManagerImpl<ProgressManageDao, ProgressManage>
implements ProgressManageManager {
    private static Logger log = LoggerFactory.getLogger(ProgressManageManagerImpl.class);
    public static final String ROOT_PATH = System.getProperty("user.dir");
    public static final String DATA_TEMP_FILE = "tempFile";
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + "tempFile";
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    ProgressManageDefiniteManager progressManageDefiniteManager;
    @Autowired
    private ContractManager contractManager;
    @Resource
    private ProgressManageDao progressManageDao;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdateEntity(ProgressManage entity) {
        Contract contract;
        ArrayList<Accessory> flag;
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        Date registerDate = entity.getRegisterDate();
        entity.setRegisterDate(null == registerDate ? new Date() : registerDate);
        if (null != entity.getId() && !entity.getId().isEmpty()) {
            SimpleDateFormat syd = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal total = ((ProgressManageDao)this.baseMapper).getAmountAppropriatedlExceptId(entity.getProjectId(), syd.format(registerDate), entity.getContractId(), entity.getId());
            entity.setAmountAppropriated(total);
        }
        boolean savedMain = null == entity.getId() ? this.save((Object)entity) : this.updateById((Object)entity);
        List<ProgressManageDefinite> definites = entity.getDefiniteInfo();
        if (null != definites && definites.size() > 0) {
            for (ProgressManageDefinite ele : definites) {
                ele.setProgressManageId(entity.getId());
            }
            this.progressManageDefiniteManager.saveOrUpdateBatch(definites);
        }
        ArrayList<Accessory> accessoryList = null == (flag = entity.getAccessoryInfo()) ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("ProgressManage");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        if (StringUtils.isNotBlank((CharSequence)entity.getContractId()) && null != (contract = (Contract)((Object)this.contractManager.getById((Serializable)((Object)entity.getContractId()))))) {
            if (StringUtils.isNotBlank((CharSequence)entity.getRegisterPersonName())) {
                contract.setPayee(entity.getRegisterPersonName());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getHandlerPerson())) {
                contract.setPayeeAccount(entity.getHandlerPerson());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getRegisterPersonId())) {
                contract.setPayeeContactPhone(entity.getRegisterPersonId());
            }
            this.contractManager.update((Model)contract);
        }
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProgressManage entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyOne.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyOne.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyOne.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyOne.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyOne.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyOne.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyOne.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyOne.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getDept() + "_" + entity.getRegisterPersonName() + "_" + entity.getAmountTotalWords() + "_" + entity.getHandlerPerson() + "_" + entity.getRegisterPersonName());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    private ProgressManage handleAmountAppropriated(ProgressManage entity) {
        List progressManageList = ((ProgressManageDao)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"PROJECT_ID_", (Object)entity.getProjectId()));
        List result = null == progressManageList ? new ArrayList() : progressManageList;
        BigDecimal amountAppropriated = new BigDecimal(0);
        for (ProgressManage ele : result) {
            BigDecimal value = null == ele.getPayeeAmountTotal() ? new BigDecimal(0) : ele.getPayeeAmountTotal();
            amountAppropriated.add(value);
        }
        entity.setAmountAppropriated(amountAppropriated);
        return entity;
    }

    @Override
    public ProgressManage getById(String id) {
        ProgressManage result = ((ProgressManageDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        List definites = this.progressManageDefiniteManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROGRESS_MANAGE_ID_", (Object)result.getId())).eq((Object)"IS_DELE_", (Object)"0"));
        result.setDefiniteInfo(definites);
        return result;
    }

    @Override
    public PageList<ProgressManage> queryAllByPage(QueryFilter<ProgressManage> queryFilter) {
        queryFilter.addFilter("bpm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.VALID_FLAG_", (Object)1, QueryOP.EQUAL);
        IPage<ProgressManage> result = ((ProgressManageDao)this.baseMapper).queryAllByPage((IPage<ProgressManage>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProgressManage>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ProgressManage ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
            List definites = this.progressManageDefiniteManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROGRESS_MANAGE_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0"));
            ele.setDefiniteInfo(definites);
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        List purpose = this.sdm.queryDictListItemsByCode("jdgl-yt");
        try (InputStream inputStream = file.getInputStream();){
            List<ProgressManage> data = ExcelImportUtil.importExcel((InputStream)inputStream, ProgressManage.class, (ImportParams)new ImportParams());
            data = this.removeNullData(data);
            for (ProgressManage ele : data) {
                ele.setProjectId(projectId);
                ele.setContractId(contractId);
                ele.setPurpose(BizUtils.getDicCodeByValue(purpose, ele.getPurpose()));
                this.handleAmountAppropriated(ele);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<ProgressManage> removeNullData(List<ProgressManage> data) {
        ArrayList<ProgressManage> result = new ArrayList<ProgressManage>();
        data.forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getPurpose())) {
                result.add((ProgressManage)((Object)e));
            }
        });
        return result;
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProgressManage> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u8fdb\u5ea6\u7ba1\u7406-\u5bfc\u51fa\u7ed3\u679c";
        List fundPlan = this.sdm.queryDictListItemsByCode("jdgl-sfyzjjh");
        List purpose = this.sdm.queryDictListItemsByCode("jdgl-yt");
        List billType = this.sdm.queryDictListItemsByCode("jdgl-jspj");
        BizUtils.handleFilter(queryFilter, "bpm", true);
        List data = ((ProgressManageDao)this.baseMapper).queryAllByPage((IPage<ProgressManage>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ProgressManage>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (ProgressManage ele : data) {
            ele.setPurpose(BizUtils.getDicValueByCode((List<DictModel>)purpose, ele.getPurpose()));
            ele.setHaveFundPlan(BizUtils.getDicValueByCode((List<DictModel>)fundPlan, ele.getHaveFundPlan()));
            ele.setSettlementBillType(BizUtils.getDicValueByCode((List<DictModel>)billType, ele.getSettlementBillType()));
            if (null != ele.getTotalInvestment()) {
                ele.setTotalInvestment(ele.getTotalInvestment().stripTrailingZeros());
            }
            if (null != ele.getPayeeAmountTotal()) {
                ele.setPayeeAmountTotal(ele.getPayeeAmountTotal().stripTrailingZeros());
            }
            if (null != ele.getAmountAppropriated()) {
                ele.setAmountAppropriated(ele.getAmountAppropriated().stripTrailingZeros());
            }
            if (null == ele.getOutputValue()) continue;
            ele.setOutputValue(ele.getOutputValue().stripTrailingZeros());
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ProgressManage.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo) {
        return ((ProgressManageDao)this.baseMapper).queryInvestment(statisticsVo);
    }

    @Override
    public BigDecimal getAmountAppropriatedl(AppropriatedlVo appropriatedlVo) {
        BigDecimal total;
        String projectId = appropriatedlVo.getProjectId();
        String registerDate = appropriatedlVo.getRegisterDate();
        String contractId = appropriatedlVo.getContractId();
        if (StringUtils.isBlank((CharSequence)registerDate)) {
            registerDate = LocalDate.now().toString();
        }
        if ((total = ((ProgressManageDao)this.baseMapper).getAmountAppropriatedl(projectId, registerDate, contractId)) == null) {
            total = new BigDecimal(0);
        }
        return total;
    }

    @Override
    public BigDecimal getNotAppropriatedl(String projectId, String registerDate) {
        BigDecimal total;
        if (StringUtils.isBlank((CharSequence)registerDate)) {
            registerDate = LocalDate.now().toString();
        }
        if ((total = ((ProgressManageDao)this.baseMapper).getNotAppropriatedl(projectId, registerDate)) == null) {
            total = new BigDecimal(0);
        }
        return total;
    }

    @Override
    public void exportApprovalForm(String id, HttpServletResponse response) throws IOException {
        String fileName = "\u897f\u6c38\u5fae\u7535\u56ed\u516c\u53f8\u9879\u76ee\u62e8\uff08\u4ed8\uff09\u6b3e\u7533\u8bf7\u5ba1\u6279\u5355";
        List purpose = this.sdm.queryDictListItemsByCode("jdgl-yt");
        ProgressManage data = ((ProgressManageDao)this.baseMapper).getById(id);
        File filePath = new File(TEMP_DATA_EXCEL);
        if (!filePath.exists() && !filePath.isDirectory()) {
            filePath.mkdirs();
        }
        File file = new File(TEMP_DATA_EXCEL + File.separator + "appropriationApprovalTemplate.xls");
        FileInputStream inputStream = new FileInputStream(file);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)inputStream);
        HSSFSheet sheet = workbook.getSheetAt(0);
        Date registerDate = data.getRegisterDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(registerDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 22, 23));
        HSSFRow row1 = sheet.getRow(1);
        row1.getCell(0).setCellValue(row1.getCell(0).getStringCellValue() + data.getDept());
        HSSFCellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        row1.getCell(22).setCellStyle(style);
        row1.getCell(22).setCellValue((double)year);
        row1.getCell(25).setCellValue((double)month);
        row1.getCell(27).setCellValue((double)day);
        HSSFRow row2 = sheet.getRow(2);
        row2.getCell(5).setCellValue(BeanUtils.isEmpty((Object)((Object)data.getProjectInfo())) ? "" : data.getProjectInfo().getProjectName());
        row2.getCell(22).setCellValue(BizUtils.getDicValueByCode((List<DictModel>)purpose, data.getPurpose()));
        HSSFRow row3 = sheet.getRow(3);
        DecimalFormat nf = new DecimalFormat("\uffe5,###.##");
        BigDecimal bigDecimal1 = new BigDecimal(null == data.getTotalInvestment() ? "0.00" : data.getTotalInvestment().toPlainString());
        if (new BigDecimal(bigDecimal1.intValue()).compareTo(bigDecimal1) == 0) {
            row3.getCell(5).setCellValue(nf.format(bigDecimal1).toString() + ".00");
        } else {
            bigDecimal1.setScale(2);
            row3.getCell(5).setCellValue(nf.format(bigDecimal1));
        }
        BigDecimal bigDecimal2 = new BigDecimal(null == data.getAmountAppropriated() ? "0.00" : data.getAmountAppropriated().toPlainString());
        if (new BigDecimal(bigDecimal2.intValue()).compareTo(bigDecimal2) == 0) {
            row3.getCell(22).setCellValue(nf.format(bigDecimal2).toString() + ".00");
        } else {
            bigDecimal2.setScale(2);
            row3.getCell(22).setCellValue(nf.format(bigDecimal2));
        }
        sheet.getRow(4).getCell(5).setCellValue(StringUtils.isEmpty((CharSequence)data.getMeasurementData()) ? "" : "    " + data.getMeasurementData());
        sheet.getRow(8).getCell(24).setCellValue(data.getSettlementBillNum());
        HSSFRow row11 = sheet.getRow(11);
        row11.getCell(6).setCellValue(data.getRegisterPersonName());
        row11.getCell(22).setCellValue(data.getRegisterPersonId());
        HSSFRow row12 = sheet.getRow(12);
        row12.getCell(6).setCellValue(data.getHandlerPerson());
        BigDecimal bigDecimal3 = new BigDecimal(null == data.getPayeeAmountTotal() ? "0.00" : data.getPayeeAmountTotal().toPlainString());
        if (new BigDecimal(bigDecimal3.intValue()).compareTo(bigDecimal3) == 0) {
            row12.getCell(23).setCellValue(nf.format(bigDecimal3).toString() + ".00");
        } else {
            bigDecimal3.setScale(2);
            row12.getCell(23).setCellValue(nf.format(bigDecimal3));
        }
        HSSFRow row13 = sheet.getRow(13);
        String capital = null == data.getPayeeAmountTotal() ? "" : StringUtil.convertToChineseNumeral2((double)data.getPayeeAmountTotal().doubleValue());
        for (int i = 28; i > 6; --i) {
            row13.getCell(i).setCellValue(String.valueOf(capital.charAt(capital.length() - 1)));
            capital = capital.substring(0, capital.length() - 1);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public ProgressManageTotalVo getProgressByProjectId(ProgressManageTotalVo progressManageTotalVoParam) {
        ProgressManageTotalVo progressManageTotalVo = this.progressManageDao.getProgressManageTotalByProjectId(progressManageTotalVoParam);
        progressManageTotalVo = progressManageTotalVo == null ? new ProgressManageTotalVo() : progressManageTotalVo;
        BigDecimal totalInvestment = progressManageTotalVo.getTotalInvestment();
        if (null == totalInvestment || totalInvestment.stripTrailingZeros().equals(BigDecimal.ZERO.stripTrailingZeros())) {
            ProjectManagement projectManagement = (ProjectManagement)this.pm.get((Serializable)((Object)progressManageTotalVoParam.getProjectId()));
            if (null != projectManagement && null != projectManagement.getProjectMoney()) {
                progressManageTotalVo.setTotalInvestment(projectManagement.getProjectMoney());
            } else {
                progressManageTotalVo.setTotalInvestment(BigDecimal.ZERO);
            }
        }
        if (progressManageTotalVo.getTotalInvestment() == null) {
            progressManageTotalVo.setTotalInvestment(BigDecimal.ZERO);
        }
        if (progressManageTotalVo.getAmountAppropriated() == null) {
            progressManageTotalVo.setAmountAppropriated(BigDecimal.ZERO);
        }
        if (BigDecimal.ZERO.equals(progressManageTotalVo.getTotalInvestment()) || BigDecimal.ZERO.equals(progressManageTotalVo.getAmountAppropriated())) {
            progressManageTotalVo.setMeasurementData("-");
        } else {
            BigDecimal percentageNum = progressManageTotalVo.getAmountAppropriated().divide(progressManageTotalVo.getTotalInvestment(), 4, 4).multiply(new BigDecimal(100)).stripTrailingZeros();
            if (null == percentageNum) {
                progressManageTotalVo.setMeasurementData("-");
            } else if (percentageNum.compareTo(new BigDecimal("100")) > 0) {
                progressManageTotalVo.setMeasurementData("100%");
            } else {
                progressManageTotalVo.setMeasurementData(percentageNum.toString() + "%");
            }
        }
        if (progressManageTotalVo.getTotalInvestment().equals(BigDecimal.ZERO)) {
            progressManageTotalVo.setOutputValue(BigDecimal.ZERO);
        } else {
            BigDecimal outputValue = progressManageTotalVo.getTotalInvestment().subtract(progressManageTotalVo.getAmountAppropriated()).setScale(0, 4).stripTrailingZeros();
            progressManageTotalVo.setOutputValue(outputValue);
        }
        return progressManageTotalVo;
    }

    @Override
    public ProgressManage getProgressManageByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.isNotNull((Object)"REGISTER_PERSON_NAME_");
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        queryWrapper.last("limit 1");
        return (ProgressManage)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    public BigDecimal geTamountAppropriatedTotalByProjectId(String projectId) {
        return ((ProgressManageDao)this.baseMapper).geTamountAppropriatedTotalByProjectId(projectId);
    }

    @Override
    public BigDecimal geTamountAppropriatedTotalByProjectIdAndPurpose(String projectId, boolean operation, String purpose) {
        List<String> purposeList = Arrays.asList(purpose.split(","));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(PAYEE_AMOUNT_TOTAL_),0) as totalInvestment"});
        if (operation) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IS_DELE_", (Object)0)).eq((Object)"PROJECT_ID_", (Object)projectId)).in((Object)"PURPOSE_", purposeList);
        } else {
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IS_DELE_", (Object)0)).eq((Object)"PROJECT_ID_", (Object)projectId)).notIn((Object)"PURPOSE_", purposeList);
        }
        ProgressManage one = (ProgressManage)((Object)this.getOne((Wrapper)queryWrapper));
        return one.getTotalInvestment();
    }

    @Override
    public List<ProgressManage> fundplanGetProgressManage(LambdaQueryWrapper<ProgressManage> lambdaQueryWrapper) {
        return ((ProgressManageDao)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public BigDecimal getTwoPrice(String projectId, String purpose) {
        List<String> purposeList = Arrays.asList(purpose.split(","));
        return ((ProgressManageDao)this.baseMapper).getTwoPrice(projectId, purposeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recalManage(String projectId) {
        if (null != projectId && !"".equals(projectId)) {
            List<String> projectIds = Arrays.asList(projectId);
            this.recalManageLogic(projectIds);
        } else {
            List<String> projectIds = ((ProgressManageDao)this.baseMapper).selectProjectIds();
            if (null != projectIds && projectIds.size() > 0) {
                log.info("\u9879\u76ee\u652f\u4ed8\u91cd\u7b97\u5f00\u59cb\uff0c\u9879\u76ee\u5171" + projectIds.size() + "\u4e2a");
                int projectNum = projectIds.size();
                int threadNum = 4;
                int threadTaskNum = ThreadUtil.getThreadTaskNum(threadNum, projectNum);
                log.info("\u9879\u76ee\u652f\u4ed8\u91cd\u7b97-\u5f00\u542f\u591a\u7ebf\u7a0b, \u4efb\u52a1\u6570[{}], \u7ebf\u7a0b\u6570[{}], \u6bcf\u4e2a\u7ebf\u7a0b\u4efb\u52a1\u6570[{}]", new Object[]{projectNum, threadNum, threadTaskNum});
                for (int i = 0; i < threadNum; ++i) {
                    List<String> subList = projectIds.subList(i * threadTaskNum, i == threadNum - 1 ? projectNum : (i + 1) * threadTaskNum);
                    Future<Object[]> future = ThreadUtil.publicPool.submit(new recalManageThread(subList));
                }
            }
        }
        log.info("\u9879\u76ee\u652f\u4ed8\u91cd\u7b97\u5168\u90e8\u5b8c\u6210");
    }

    private void recalManageLogic(List<String> projectIds) {
        for (String projectId : projectIds) {
            log.info("\u9879\u76ee\u652f\u4ed8\u91cd\u7b97\u5f00\u59cb-projectId:" + projectId);
            List<ProgressManage> progressManageList = ((ProgressManageDao)this.baseMapper).selectByProjectId(projectId);
            if (null != progressManageList && progressManageList.size() > 0) {
                for (ProgressManage progressManage : progressManageList) {
                    String contractId = progressManage.getContractId();
                    Date registerDate = progressManage.getRegisterDate();
                    String id = progressManage.getId();
                    BigDecimal amountAppropriated = ((ProgressManageDao)this.baseMapper).selectAmountAppropriated(projectId, contractId, registerDate, id);
                    progressManage.setAmountAppropriated(amountAppropriated);
                }
                this.saveOrUpdateBatch(progressManageList);
            }
            log.info("\u9879\u76ee\u652f\u4ed8\u91cd\u7b97\u5b8c\u6210-projectId:" + projectId);
        }
    }

    class recalManageThread
    implements Callable<Object[]> {
        private List<String> projectIds;

        public recalManageThread(List<String> projectIds) {
            this.projectIds = projectIds;
        }

        @Override
        public Object[] call() {
            ProgressManageManagerImpl.this.recalManageLogic(this.projectIds);
            return new Object[0];
        }
    }
}

