/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.completionAcceptance.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.completionAcceptance.dao.AcceptanceSettlementDao;
import com.artfess.cqxy.completionAcceptance.manager.AcceptanceSettlementManager;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceSettlement;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AcceptanceSettlementManagerImpl
extends BaseManagerImpl<AcceptanceSettlementDao, AcceptanceSettlement>
implements AcceptanceSettlementManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private ContractManager cm;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private BaseContext baseContext;

    public boolean saveOrUpdate(AcceptanceSettlement entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("AcceptanceSettlement");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.thirteen.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, AcceptanceSettlement entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyFive.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyFive.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyFive.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyFive.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyFive.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyFive.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyFive.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyFive.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getFilingAuthorityOpinions() + "_" + entity.getHandler() + "_" + entity.getApprovalOpinion() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public AcceptanceSettlement getById(String id) {
        AcceptanceSettlement result = ((AcceptanceSettlementDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<AcceptanceSettlement> queryAllByPage(QueryFilter<AcceptanceSettlement> queryFilter) {
        queryFilter.addFilter("bas.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.VALID_FLAG_", (Object)1, QueryOP.EQUAL);
        IPage<AcceptanceSettlement> result = ((AcceptanceSettlementDao)this.baseMapper).queryAllByPage((IPage<AcceptanceSettlement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<AcceptanceSettlement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (AcceptanceSettlement ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId, String contractName) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractName, (String)"\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, AcceptanceSettlement.class, (ImportParams)new ImportParams());
            for (AcceptanceSettlement ele : data) {
                ele.setProjectId(projectId);
                ele.setContractId(contractId);
                ele.setCreateName(contractName);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDataToExcel(QueryFilter<AcceptanceSettlement> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u7ae3\u5de5\u9a8c\u6536-\u7ed3\u7b97-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bas", true);
        List data = ((AcceptanceSettlementDao)this.baseMapper).queryAllByPage((IPage<AcceptanceSettlement>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<AcceptanceSettlement>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, AcceptanceSettlement.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

